/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.eclipse.jetty.server.handler;

import io.hops.hadoop.shaded.javax.servlet.ServletException;
import io.hops.hadoop.shaded.javax.servlet.http.HttpServletRequest;
import io.hops.hadoop.shaded.javax.servlet.http.HttpServletResponse;
import io.hops.hadoop.shaded.org.eclipse.jetty.io.EndPoint;
import io.hops.hadoop.shaded.org.eclipse.jetty.server.HttpChannel;
import io.hops.hadoop.shaded.org.eclipse.jetty.server.Request;
import io.hops.hadoop.shaded.org.eclipse.jetty.server.handler.HandlerWrapper;
import io.hops.hadoop.shaded.org.eclipse.jetty.util.IncludeExcludeSet;
import io.hops.hadoop.shaded.org.eclipse.jetty.util.InetAddressSet;
import io.hops.hadoop.shaded.org.eclipse.jetty.util.log.Log;
import io.hops.hadoop.shaded.org.eclipse.jetty.util.log.Logger;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collection;

public class InetAccessHandler
extends HandlerWrapper {
    private static final Logger LOG = Log.getLogger(InetAccessHandler.class);
    private final IncludeExcludeSet<String, InetAddress> _set = new IncludeExcludeSet(InetAddressSet.class);

    public void include(String pattern) {
        this._set.include((Object)pattern);
    }

    public void include(String ... patterns) {
        this._set.include((Object[])patterns);
    }

    public void exclude(String pattern) {
        this._set.exclude((Object)pattern);
    }

    public void exclude(String ... patterns) {
        this._set.exclude((Object[])patterns);
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        InetSocketAddress address;
        EndPoint endp;
        HttpChannel channel = baseRequest.getHttpChannel();
        if (channel != null && (endp = channel.getEndPoint()) != null && (address = endp.getRemoteAddress()) != null && !this.isAllowed(address.getAddress(), request)) {
            response.sendError(403);
            baseRequest.setHandled(true);
            return;
        }
        this.getHandler().handle(target, baseRequest, request, response);
    }

    protected boolean isAllowed(InetAddress address, HttpServletRequest request) {
        return this.isAllowed(address);
    }

    @Deprecated
    protected boolean isAllowed(InetAddress address) {
        boolean allowed = this._set.test((Object)address);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} {} {}", new Object[]{this, allowed ? "allowed" : "denied", address});
        }
        return allowed;
    }

    public void dump(Appendable out, String indent) throws IOException {
        this.dumpBeans(out, indent, new Collection[]{this._set.getIncluded(), this._set.getExcluded()});
    }
}

