/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.ehcache.impl.config.executor;

import io.hops.hadoop.shaded.org.ehcache.core.spi.service.ExecutionService;
import io.hops.hadoop.shaded.org.ehcache.spi.service.ServiceCreationConfiguration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class PooledExecutionServiceConfiguration
implements ServiceCreationConfiguration<ExecutionService> {
    private final Map<String, PoolConfiguration> poolConfigurations = new HashMap<String, PoolConfiguration>();
    private String defaultAlias;

    public void addDefaultPool(String alias, int minSize, int maxSize) {
        if (alias == null) {
            throw new NullPointerException("Pool alias cannot be null");
        }
        if (this.defaultAlias != null) {
            throw new IllegalArgumentException("'" + this.defaultAlias + "' is already configured as the default pool");
        }
        this.addPool(alias, minSize, maxSize);
        this.defaultAlias = alias;
    }

    public void addPool(String alias, int minSize, int maxSize) {
        if (alias == null) {
            throw new NullPointerException("Pool alias cannot be null");
        }
        if (this.poolConfigurations.containsKey(alias)) {
            throw new IllegalArgumentException("A pool with the alias '" + alias + "' is already configured");
        }
        this.poolConfigurations.put(alias, new PoolConfiguration(minSize, maxSize));
    }

    public Map<String, PoolConfiguration> getPoolConfigurations() {
        return Collections.unmodifiableMap(this.poolConfigurations);
    }

    public String getDefaultPoolAlias() {
        return this.defaultAlias;
    }

    @Override
    public Class<ExecutionService> getServiceType() {
        return ExecutionService.class;
    }

    public static final class PoolConfiguration {
        private final int minSize;
        private final int maxSize;

        private PoolConfiguration(int minSize, int maxSize) {
            this.minSize = minSize;
            this.maxSize = maxSize;
        }

        public int minSize() {
            return this.minSize;
        }

        public int maxSize() {
            return this.maxSize;
        }
    }
}

