/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.ehcache.impl.internal.events;

import io.hops.hadoop.shaded.org.ehcache.core.events.CacheEventDispatcher;
import io.hops.hadoop.shaded.org.ehcache.core.events.CacheEventDispatcherFactory;
import io.hops.hadoop.shaded.org.ehcache.core.spi.service.ExecutionService;
import io.hops.hadoop.shaded.org.ehcache.core.spi.service.ServiceUtils;
import io.hops.hadoop.shaded.org.ehcache.core.spi.store.Store;
import io.hops.hadoop.shaded.org.ehcache.impl.config.event.CacheEventDispatcherFactoryConfiguration;
import io.hops.hadoop.shaded.org.ehcache.impl.config.event.DefaultCacheEventDispatcherConfiguration;
import io.hops.hadoop.shaded.org.ehcache.impl.events.CacheEventDispatcherImpl;
import io.hops.hadoop.shaded.org.ehcache.spi.service.Service;
import io.hops.hadoop.shaded.org.ehcache.spi.service.ServiceConfiguration;
import io.hops.hadoop.shaded.org.ehcache.spi.service.ServiceDependencies;
import io.hops.hadoop.shaded.org.ehcache.spi.service.ServiceProvider;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;

@ServiceDependencies(value={ExecutionService.class})
public class CacheEventDispatcherFactoryImpl
implements CacheEventDispatcherFactory {
    private final String defaultThreadPoolAlias;
    private volatile ExecutionService executionService;

    public CacheEventDispatcherFactoryImpl() {
        this.defaultThreadPoolAlias = null;
    }

    public CacheEventDispatcherFactoryImpl(CacheEventDispatcherFactoryConfiguration configuration) {
        this.defaultThreadPoolAlias = configuration.getThreadPoolAlias();
    }

    @Override
    public void start(ServiceProvider<Service> serviceProvider) {
        this.executionService = serviceProvider.getService(ExecutionService.class);
    }

    @Override
    public void stop() {
    }

    @Override
    public <K, V> CacheEventDispatcher<K, V> createCacheEventDispatcher(Store<K, V> store, ServiceConfiguration<?> ... serviceConfigs) {
        String threadPoolAlias = this.defaultThreadPoolAlias;
        DefaultCacheEventDispatcherConfiguration config = ServiceUtils.findSingletonAmongst(DefaultCacheEventDispatcherConfiguration.class, serviceConfigs);
        if (config != null) {
            threadPoolAlias = config.getThreadPoolAlias();
        }
        ExecutorService orderedExecutor = this.executionService.getOrderedExecutor(threadPoolAlias, new LinkedBlockingQueue<Runnable>());
        ExecutorService unOrderedExecutor = this.executionService.getUnorderedExecutor(threadPoolAlias, new LinkedBlockingQueue<Runnable>());
        return new CacheEventDispatcherImpl(unOrderedExecutor, orderedExecutor);
    }

    @Override
    public <K, V> void releaseCacheEventDispatcher(CacheEventDispatcher<K, V> eventDispatcher) {
        if (eventDispatcher != null) {
            eventDispatcher.shutdown();
        }
    }
}

