/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.ehcache.impl.internal.store.disk;

import io.hops.hadoop.shaded.org.ehcache.config.EvictionAdvisor;
import io.hops.hadoop.shaded.org.ehcache.core.spi.function.Function;
import io.hops.hadoop.shaded.org.ehcache.impl.internal.store.disk.factories.EhcachePersistentSegmentFactory;
import io.hops.hadoop.shaded.org.ehcache.impl.internal.store.offheap.EhcacheOffHeapBackingMap;
import io.hops.hadoop.shaded.org.terracotta.offheapstore.MetadataTuple;
import io.hops.hadoop.shaded.org.terracotta.offheapstore.Segment;
import io.hops.hadoop.shaded.org.terracotta.offheapstore.disk.persistent.AbstractPersistentConcurrentOffHeapCache;
import io.hops.hadoop.shaded.org.terracotta.offheapstore.jdk8.BiFunction;
import java.io.IOException;
import java.io.ObjectInput;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class EhcachePersistentConcurrentOffHeapClockCache<K, V>
extends AbstractPersistentConcurrentOffHeapCache<K, V>
implements EhcacheOffHeapBackingMap<K, V> {
    private final EvictionAdvisor<? super K, ? super V> evictionAdvisor;
    private final AtomicLong[] counters;

    public EhcachePersistentConcurrentOffHeapClockCache(ObjectInput input, EvictionAdvisor<? super K, ? super V> evictionAdvisor, EhcachePersistentSegmentFactory<K, V> segmentFactory) throws IOException {
        this(evictionAdvisor, segmentFactory, EhcachePersistentConcurrentOffHeapClockCache.readSegmentCount(input));
    }

    public EhcachePersistentConcurrentOffHeapClockCache(EvictionAdvisor<? super K, ? super V> evictionAdvisor, EhcachePersistentSegmentFactory<K, V> segmentFactory, int concurrency) {
        super(segmentFactory, concurrency);
        this.evictionAdvisor = evictionAdvisor;
        this.counters = new AtomicLong[this.segments.length];
        for (int i = 0; i < this.segments.length; ++i) {
            this.counters[i] = new AtomicLong();
        }
    }

    @Override
    public long allocatedMemory() {
        long total = 0L;
        for (Segment segment : this.segments) {
            total += segment.getAllocatedMemory();
        }
        return total;
    }

    @Override
    public long occupiedMemory() {
        long total = 0L;
        for (Segment segment : this.segments) {
            total += segment.getOccupiedMemory();
        }
        return total;
    }

    @Override
    public long dataAllocatedMemory() {
        long total = 0L;
        for (Segment segment : this.segments) {
            total += segment.getDataAllocatedMemory();
        }
        return total;
    }

    @Override
    public long dataOccupiedMemory() {
        long total = 0L;
        for (Segment segment : this.segments) {
            total += segment.getDataOccupiedMemory();
        }
        return total;
    }

    @Override
    public long dataSize() {
        long total = 0L;
        for (Segment segment : this.segments) {
            total += segment.getDataSize();
        }
        return total;
    }

    @Override
    public long longSize() {
        long total = 0L;
        for (Segment segment : this.segments) {
            total += segment.getSize();
        }
        return total;
    }

    @Override
    public long tableCapacity() {
        long total = 0L;
        for (Segment segment : this.segments) {
            total += segment.getTableCapacity();
        }
        return total;
    }

    @Override
    public long usedSlotCount() {
        long total = 0L;
        for (Segment segment : this.segments) {
            total += segment.getUsedSlotCount();
        }
        return total;
    }

    @Override
    public long removedSlotCount() {
        long total = 0L;
        for (Segment segment : this.segments) {
            total += segment.getRemovedSlotCount();
        }
        return total;
    }

    @Override
    public long reprobeLength() {
        long total = 0L;
        for (Segment segment : this.segments) {
            total += (long)segment.getReprobeLength();
        }
        return total;
    }

    @Override
    public long vitalMemory() {
        long total = 0L;
        for (Segment segment : this.segments) {
            total += segment.getVitalMemory();
        }
        return total;
    }

    @Override
    public long dataVitalMemory() {
        long total = 0L;
        for (Segment segment : this.segments) {
            total += segment.getDataVitalMemory();
        }
        return total;
    }

    @Override
    public V compute(K key, final io.hops.hadoop.shaded.org.ehcache.core.spi.function.BiFunction<K, V, V> mappingFunction, final boolean pin) {
        MetadataTuple result = this.computeWithMetadata(key, new BiFunction<K, MetadataTuple<V>, MetadataTuple<V>>(){

            @Override
            public MetadataTuple<V> apply(K k, MetadataTuple<V> current) {
                Object oldValue = current == null ? null : (Object)current.value();
                Object newValue = mappingFunction.apply(k, oldValue);
                if (newValue == null) {
                    return null;
                }
                if (oldValue == newValue) {
                    return MetadataTuple.metadataTuple(newValue, (pin ? 0x40000000 : 0) | current.metadata());
                }
                return MetadataTuple.metadataTuple(newValue, (pin ? 0x40000000 : 0) | (EhcachePersistentConcurrentOffHeapClockCache.this.evictionAdvisor.adviseAgainstEviction(k, newValue) ? 0x20000000 : 0));
            }
        });
        return result == null ? null : (V)result.value();
    }

    @Override
    public V computeIfPresent(K key, final io.hops.hadoop.shaded.org.ehcache.core.spi.function.BiFunction<K, V, V> mappingFunction) {
        MetadataTuple result = this.computeIfPresentWithMetadata(key, new BiFunction<K, MetadataTuple<V>, MetadataTuple<V>>(){

            @Override
            public MetadataTuple<V> apply(K k, MetadataTuple<V> current) {
                Object oldValue = current.value();
                Object newValue = mappingFunction.apply(k, oldValue);
                if (newValue == null) {
                    return null;
                }
                if (oldValue == newValue) {
                    return current;
                }
                return MetadataTuple.metadataTuple(newValue, EhcachePersistentConcurrentOffHeapClockCache.this.evictionAdvisor.adviseAgainstEviction(k, newValue) ? 0x20000000 : 0);
            }
        });
        return result == null ? null : (V)result.value();
    }

    @Override
    public V computeIfPresentAndPin(K key, final io.hops.hadoop.shaded.org.ehcache.core.spi.function.BiFunction<K, V, V> mappingFunction) {
        MetadataTuple result = this.computeIfPresentWithMetadata(key, new BiFunction<K, MetadataTuple<V>, MetadataTuple<V>>(){

            @Override
            public MetadataTuple<V> apply(K k, MetadataTuple<V> current) {
                Object oldValue = current.value();
                Object newValue = mappingFunction.apply(k, oldValue);
                if (newValue == null) {
                    return null;
                }
                if (oldValue == newValue) {
                    return MetadataTuple.metadataTuple(newValue, 0x40000000 | current.metadata());
                }
                return MetadataTuple.metadataTuple(newValue, 0x40000000 | (EhcachePersistentConcurrentOffHeapClockCache.this.evictionAdvisor.adviseAgainstEviction(k, newValue) ? 0x20000000 : 0));
            }
        });
        return result == null ? null : (V)result.value();
    }

    @Override
    public boolean computeIfPinned(K key, final io.hops.hadoop.shaded.org.ehcache.core.spi.function.BiFunction<K, V, V> remappingFunction, final Function<V, Boolean> unpinFunction) {
        final AtomicBoolean unpin = new AtomicBoolean();
        this.computeIfPresentWithMetadata(key, new BiFunction<K, MetadataTuple<V>, MetadataTuple<V>>(){

            @Override
            public MetadataTuple<V> apply(K k, MetadataTuple<V> current) {
                if ((current.metadata() & 0x40000000) != 0) {
                    Object oldValue = current.value();
                    Object newValue = remappingFunction.apply(k, oldValue);
                    Boolean unpinLocal = (Boolean)unpinFunction.apply(oldValue);
                    if (newValue == null) {
                        unpin.set(true);
                        return null;
                    }
                    if (oldValue == newValue) {
                        unpin.set(unpinLocal);
                        return MetadataTuple.metadataTuple(oldValue, current.metadata() & (unpinLocal != false ? -1073741825 : -1));
                    }
                    unpin.set(false);
                    return MetadataTuple.metadataTuple(newValue, EhcachePersistentConcurrentOffHeapClockCache.this.evictionAdvisor.adviseAgainstEviction(k, newValue) ? 0x20000000 : 0);
                }
                return current;
            }
        });
        return unpin.get();
    }

    @Override
    public long nextIdFor(K key) {
        return this.counters[this.getIndexFor(key.hashCode())].getAndIncrement();
    }
}

