/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.ehcache.jsr107;

import io.hops.hadoop.shaded.javax.cache.Cache;
import io.hops.hadoop.shaded.javax.cache.configuration.CacheEntryListenerConfiguration;
import io.hops.hadoop.shaded.javax.cache.configuration.Factory;
import io.hops.hadoop.shaded.javax.cache.event.CacheEntryEventFilter;
import io.hops.hadoop.shaded.javax.cache.event.CacheEntryListener;
import io.hops.hadoop.shaded.org.ehcache.jsr107.CacheResources;
import io.hops.hadoop.shaded.org.ehcache.jsr107.EventListenerAdaptors;
import io.hops.hadoop.shaded.org.ehcache.jsr107.MultiCacheException;
import io.hops.hadoop.shaded.org.ehcache.jsr107.NullCacheEntryEventFilter;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

class ListenerResources<K, V>
implements Closeable {
    private final CacheEntryListener<? super K, ? super V> listener;
    private final CacheEntryEventFilter<? super K, ? super V> filter;
    private List<EventListenerAdaptors.EventListenerAdaptor<K, V>> ehListeners = null;

    static <K, V> ListenerResources<K, V> createListenerResources(CacheEntryListenerConfiguration<K, V> listenerConfig, MultiCacheException mce) {
        CacheEntryEventFilter<Object, Object> filter;
        CacheEntryListener<K, V> listener = listenerConfig.getCacheEntryListenerFactory().create();
        try {
            Factory<CacheEntryEventFilter<K, V>> filterFactory = listenerConfig.getCacheEntryEventFilterFactory();
            filter = filterFactory != null ? listenerConfig.getCacheEntryEventFilterFactory().create() : NullCacheEntryEventFilter.INSTANCE;
        }
        catch (Throwable t) {
            mce.addThrowable(t);
            CacheResources.close(listener, mce);
            throw mce;
        }
        try {
            return new ListenerResources<K, V>(listener, filter);
        }
        catch (Throwable t) {
            mce.addThrowable(t);
            CacheResources.close(filter, mce);
            CacheResources.close(listener, mce);
            throw mce;
        }
    }

    ListenerResources(CacheEntryListener<? super K, ? super V> listener, CacheEntryEventFilter<? super K, ? super V> filter) {
        this.listener = listener;
        this.filter = filter;
    }

    CacheEntryEventFilter<? super K, ? super V> getFilter() {
        return this.filter;
    }

    CacheEntryListener<? super K, ? super V> getListener() {
        return this.listener;
    }

    synchronized List<EventListenerAdaptors.EventListenerAdaptor<K, V>> getEhcacheListeners(Cache<K, V> source, boolean requestsOld) {
        if (this.ehListeners == null) {
            this.ehListeners = EventListenerAdaptors.ehListenersFor(this.listener, this.filter, source, requestsOld);
        }
        return Collections.unmodifiableList(this.ehListeners);
    }

    @Override
    public void close() throws IOException {
        MultiCacheException mce = new MultiCacheException();
        CacheResources.close(this.listener, mce);
        CacheResources.close(this.filter, mce);
        mce.throwIfNotEmpty();
    }
}

