/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.glassfish.grizzly;

import io.hops.hadoop.shaded.org.glassfish.grizzly.Closeable;
import io.hops.hadoop.shaded.org.glassfish.grizzly.CompletionHandler;
import io.hops.hadoop.shaded.org.glassfish.grizzly.ConnectionProbe;
import io.hops.hadoop.shaded.org.glassfish.grizzly.GrizzlyFuture;
import io.hops.hadoop.shaded.org.glassfish.grizzly.IOEvent;
import io.hops.hadoop.shaded.org.glassfish.grizzly.Processor;
import io.hops.hadoop.shaded.org.glassfish.grizzly.ProcessorSelector;
import io.hops.hadoop.shaded.org.glassfish.grizzly.Readable;
import io.hops.hadoop.shaded.org.glassfish.grizzly.Transport;
import io.hops.hadoop.shaded.org.glassfish.grizzly.Writable;
import io.hops.hadoop.shaded.org.glassfish.grizzly.attributes.AttributeStorage;
import io.hops.hadoop.shaded.org.glassfish.grizzly.attributes.NullaryFunction;
import io.hops.hadoop.shaded.org.glassfish.grizzly.monitoring.MonitoringAware;
import io.hops.hadoop.shaded.org.glassfish.grizzly.monitoring.MonitoringConfig;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public interface Connection<L>
extends Readable<L>,
Writable<L>,
Closeable<Connection>,
AttributeStorage,
MonitoringAware<ConnectionProbe> {
    public Transport getTransport();

    public boolean isOpen();

    public void configureBlocking(boolean var1);

    public boolean isBlocking();

    public void configureStandalone(boolean var1);

    public boolean isStandalone();

    public Processor obtainProcessor(IOEvent var1);

    public Processor getProcessor();

    public void setProcessor(Processor var1);

    public ProcessorSelector getProcessorSelector();

    public void setProcessorSelector(ProcessorSelector var1);

    public <E> E obtainProcessorState(Processor var1, NullaryFunction<E> var2);

    public L getPeerAddress();

    public L getLocalAddress();

    @Override
    public GrizzlyFuture<Connection> close();

    @Override
    public void close(CompletionHandler<Connection> var1);

    public void closeSilently();

    public int getReadBufferSize();

    public void setReadBufferSize(int var1);

    public int getWriteBufferSize();

    public void setWriteBufferSize(int var1);

    public int getMaxAsyncWriteQueueSize();

    public void setMaxAsyncWriteQueueSize(int var1);

    public long getReadTimeout(TimeUnit var1);

    public void setReadTimeout(long var1, TimeUnit var3);

    public long getWriteTimeout(TimeUnit var1);

    public void setWriteTimeout(long var1, TimeUnit var3);

    public void simulateIOEvent(IOEvent var1) throws IOException;

    public void enableIOEvent(IOEvent var1) throws IOException;

    public void disableIOEvent(IOEvent var1) throws IOException;

    @Override
    public MonitoringConfig<ConnectionProbe> getMonitoringConfig();

    public void addCloseListener(CloseListener var1);

    public boolean removeCloseListener(CloseListener var1);

    public void notifyConnectionError(Throwable var1);

    public static interface CloseListener {
        public void onClosed(Connection var1, CloseType var2) throws IOException;
    }

    public static enum CloseType {
        LOCALLY,
        REMOTELY;

    }
}

