/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.glassfish.grizzly.compression.zip;

import io.hops.hadoop.shaded.org.glassfish.grizzly.AbstractTransformer;
import io.hops.hadoop.shaded.org.glassfish.grizzly.Buffer;
import io.hops.hadoop.shaded.org.glassfish.grizzly.TransformationException;
import io.hops.hadoop.shaded.org.glassfish.grizzly.TransformationResult;
import io.hops.hadoop.shaded.org.glassfish.grizzly.attributes.AttributeStorage;
import io.hops.hadoop.shaded.org.glassfish.grizzly.memory.Buffers;
import io.hops.hadoop.shaded.org.glassfish.grizzly.memory.ByteBufferArray;
import io.hops.hadoop.shaded.org.glassfish.grizzly.memory.MemoryManager;
import java.nio.ByteBuffer;
import java.util.zip.CRC32;
import java.util.zip.Deflater;

public class GZipEncoder
extends AbstractTransformer<Buffer, Buffer> {
    private static final int GZIP_MAGIC = 35615;
    private static final int TRAILER_SIZE = 8;
    private final int bufferSize;
    private static final Buffer header = MemoryManager.DEFAULT_MEMORY_MANAGER.allocate(10);

    public GZipEncoder() {
        this(512);
    }

    public GZipEncoder(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    @Override
    public String getName() {
        return "gzip-encoder";
    }

    @Override
    public boolean hasInputRemaining(AttributeStorage storage, Buffer input) {
        return input.hasRemaining();
    }

    protected GZipOutputState createStateObject() {
        return new GZipOutputState();
    }

    @Override
    protected TransformationResult<Buffer, Buffer> transformImpl(AttributeStorage storage, Buffer input) throws TransformationException {
        MemoryManager memoryManager = this.obtainMemoryManager(storage);
        GZipOutputState state = (GZipOutputState)this.obtainStateObject(storage);
        Buffer headerToWrite = null;
        if (!state.isInitialized()) {
            headerToWrite = this.initializeOutput(state);
        }
        Buffer encodedBuffer = null;
        if (input != null && input.hasRemaining()) {
            encodedBuffer = this.encodeBuffer(input, state, memoryManager);
        }
        if (headerToWrite == null && encodedBuffer == null) {
            return TransformationResult.createIncompletedResult(null);
        }
        encodedBuffer = Buffers.appendBuffers(memoryManager, headerToWrite, encodedBuffer);
        return TransformationResult.createCompletedResult(encodedBuffer, null);
    }

    public Buffer finish(AttributeStorage storage) {
        MemoryManager memoryManager = this.obtainMemoryManager(storage);
        GZipOutputState state = (GZipOutputState)this.obtainStateObject(storage);
        Buffer resultBuffer = null;
        if (state.isInitialized()) {
            Deflater deflater = state.getDeflater();
            if (!deflater.finished()) {
                deflater.finish();
                while (!deflater.finished()) {
                    resultBuffer = Buffers.appendBuffers(memoryManager, resultBuffer, this.deflate(deflater, memoryManager));
                }
                Object trailer = memoryManager.allocate(8);
                CRC32 crc32 = state.getCrc32();
                GZipEncoder.putUInt(trailer, (int)crc32.getValue());
                GZipEncoder.putUInt(trailer, deflater.getTotalIn());
                trailer.flip();
                resultBuffer = Buffers.appendBuffers(memoryManager, resultBuffer, trailer);
            }
            state.setInitialized(false);
        }
        return resultBuffer;
    }

    private Buffer initializeOutput(GZipOutputState state) {
        Deflater deflater = new Deflater(-1, true);
        CRC32 crc32 = new CRC32();
        crc32.reset();
        state.setDeflater(deflater);
        state.setCrc32(crc32);
        state.setInitialized(true);
        Buffer headerToWrite = header.duplicate();
        headerToWrite.allowBufferDispose(false);
        return headerToWrite;
    }

    private Buffer encodeBuffer(Buffer buffer, GZipOutputState state, MemoryManager memoryManager) {
        CRC32 crc32 = state.getCrc32();
        Deflater deflater = state.getDeflater();
        if (deflater.finished()) {
            throw new IllegalStateException("write beyond end of stream");
        }
        int stride = this.bufferSize;
        Buffer resultBuffer = null;
        ByteBufferArray byteBufferArray = buffer.toByteBufferArray();
        ByteBuffer[] buffers = (ByteBuffer[])byteBufferArray.getArray();
        int size = byteBufferArray.size();
        for (int i = 0; i < size; ++i) {
            int off;
            byte[] buf;
            ByteBuffer byteBuffer = buffers[i];
            int len = byteBuffer.remaining();
            if (len <= 0) continue;
            if (byteBuffer.hasArray()) {
                buf = byteBuffer.array();
                off = byteBuffer.arrayOffset() + byteBuffer.position();
            } else {
                buf = new byte[len];
                off = 0;
                byteBuffer.get(buf);
                byteBuffer.position(byteBuffer.position() - len);
            }
            for (int j = 0; j < len; j += stride) {
                deflater.setInput(buf, off + j, Math.min(stride, len - j));
                while (!deflater.needsInput()) {
                    Buffer deflated = this.deflate(deflater, memoryManager);
                    if (deflated == null) continue;
                    resultBuffer = Buffers.appendBuffers(memoryManager, resultBuffer, deflated);
                }
            }
            crc32.update(buf, off, len);
        }
        byteBufferArray.restore();
        byteBufferArray.recycle();
        buffer.position(buffer.limit());
        return resultBuffer;
    }

    protected Buffer deflate(Deflater deflater, MemoryManager memoryManager) {
        int offset;
        Object buffer = memoryManager.allocate(this.bufferSize);
        ByteBuffer byteBuffer = buffer.toByteBuffer();
        byte[] array = byteBuffer.array();
        int len = deflater.deflate(array, offset = byteBuffer.arrayOffset() + byteBuffer.position(), this.bufferSize);
        if (len <= 0) {
            buffer.dispose();
            return null;
        }
        buffer.position(len);
        buffer.trim();
        return buffer;
    }

    private static void putUInt(Buffer buffer, int value) {
        GZipEncoder.putUShort(buffer, value & 0xFFFF);
        GZipEncoder.putUShort(buffer, value >> 16 & 0xFFFF);
    }

    private static void putUShort(Buffer buffer, int value) {
        buffer.put((byte)(value & 0xFF));
        buffer.put((byte)(value >> 8 & 0xFF));
    }

    static {
        header.put((byte)31);
        header.put((byte)-117);
        header.put((byte)8);
        header.put((byte)0);
        header.put((byte)0);
        header.put((byte)0);
        header.put((byte)0);
        header.put((byte)0);
        header.put((byte)0);
        header.put((byte)0);
        header.flip();
    }

    protected static final class GZipOutputState
    extends AbstractTransformer.LastResultAwareState<Buffer, Buffer> {
        private boolean isInitialized;
        private CRC32 crc32;
        private Deflater deflater;

        protected GZipOutputState() {
        }

        public boolean isInitialized() {
            return this.isInitialized;
        }

        public void setInitialized(boolean isInitialized) {
            this.isInitialized = isInitialized;
        }

        public Deflater getDeflater() {
            return this.deflater;
        }

        public void setDeflater(Deflater deflater) {
            this.deflater = deflater;
        }

        public CRC32 getCrc32() {
            return this.crc32;
        }

        public void setCrc32(CRC32 crc32) {
            this.crc32 = crc32;
        }
    }
}

