/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.glassfish.grizzly.memory;

import io.hops.hadoop.shaded.org.glassfish.grizzly.Buffer;
import io.hops.hadoop.shaded.org.glassfish.grizzly.Cacheable;
import io.hops.hadoop.shaded.org.glassfish.grizzly.memory.MemoryManager;
import io.hops.hadoop.shaded.org.glassfish.grizzly.memory.MemoryProbe;
import io.hops.hadoop.shaded.org.glassfish.grizzly.memory.ProbeNotifier;
import io.hops.hadoop.shaded.org.glassfish.grizzly.memory.ThreadLocalPool;
import io.hops.hadoop.shaded.org.glassfish.grizzly.memory.ThreadLocalPoolProvider;
import io.hops.hadoop.shaded.org.glassfish.grizzly.monitoring.jmx.AbstractJmxMonitoringConfig;
import io.hops.hadoop.shaded.org.glassfish.grizzly.monitoring.jmx.JmxObject;
import io.hops.hadoop.shaded.org.glassfish.grizzly.threadpool.DefaultWorkerThread;

public abstract class AbstractMemoryManager<E extends Buffer>
implements MemoryManager<E>,
ThreadLocalPoolProvider {
    public static final int DEFAULT_MAX_BUFFER_SIZE = 65536;
    protected final AbstractJmxMonitoringConfig<MemoryProbe> monitoringConfig = new AbstractJmxMonitoringConfig<MemoryProbe>(MemoryProbe.class){

        @Override
        public JmxObject createManagementObject() {
            return AbstractMemoryManager.this.createJmxManagementObject();
        }
    };
    protected final int maxBufferSize;

    public AbstractMemoryManager() {
        this(65536);
    }

    public AbstractMemoryManager(int maxBufferSize) {
        this.maxBufferSize = maxBufferSize;
    }

    public int getReadyThreadBufferSize() {
        ThreadLocalPool threadLocalPool = AbstractMemoryManager.getThreadLocalPool();
        if (threadLocalPool != null) {
            return threadLocalPool.remaining();
        }
        return 0;
    }

    public int getMaxBufferSize() {
        return this.maxBufferSize;
    }

    protected Object allocateFromPool(ThreadLocalPool threadLocalCache, int size) {
        if (threadLocalCache.remaining() >= size) {
            ProbeNotifier.notifyBufferAllocatedFromPool(this.monitoringConfig, size);
            return threadLocalCache.allocate(size);
        }
        return null;
    }

    protected abstract JmxObject createJmxManagementObject();

    protected static ThreadLocalPool getThreadLocalPool() {
        Thread t = Thread.currentThread();
        if (t instanceof DefaultWorkerThread) {
            return ((DefaultWorkerThread)t).getMemoryPool();
        }
        return null;
    }

    protected static interface TrimAware
    extends Cacheable {
    }
}

