/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.glassfish.grizzly.strategies;

import io.hops.hadoop.shaded.org.glassfish.grizzly.Connection;
import io.hops.hadoop.shaded.org.glassfish.grizzly.Grizzly;
import io.hops.hadoop.shaded.org.glassfish.grizzly.IOEvent;
import io.hops.hadoop.shaded.org.glassfish.grizzly.IOEventProcessingHandler;
import io.hops.hadoop.shaded.org.glassfish.grizzly.nio.NIOConnection;
import io.hops.hadoop.shaded.org.glassfish.grizzly.nio.SelectorRunner;
import io.hops.hadoop.shaded.org.glassfish.grizzly.strategies.AbstractIOStrategy;
import java.io.IOException;
import java.util.logging.Logger;

public final class LeaderFollowerNIOStrategy
extends AbstractIOStrategy {
    private static final LeaderFollowerNIOStrategy INSTANCE = new LeaderFollowerNIOStrategy();
    private static final Logger logger = Grizzly.logger(LeaderFollowerNIOStrategy.class);

    private LeaderFollowerNIOStrategy() {
    }

    public static LeaderFollowerNIOStrategy getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean executeIoEvent(Connection connection, IOEvent ioEvent, boolean isIoEventEnabled) throws IOException {
        NIOConnection nioConnection = (NIOConnection)connection;
        IOEventProcessingHandler ph = null;
        if (LeaderFollowerNIOStrategy.isReadWrite(ioEvent)) {
            if (isIoEventEnabled) {
                connection.disableIOEvent(ioEvent);
            }
            ph = ENABLE_INTEREST_PROCESSING_HANDLER;
        }
        if (LeaderFollowerNIOStrategy.isExecuteInWorkerThread(ioEvent)) {
            SelectorRunner runner = nioConnection.getSelectorRunner();
            runner.postpone();
            LeaderFollowerNIOStrategy.getWorkerThreadPool(connection).execute(runner);
            LeaderFollowerNIOStrategy.fireIOEvent(connection, ioEvent, ph, logger);
            return false;
        }
        LeaderFollowerNIOStrategy.fireIOEvent(connection, ioEvent, ph, logger);
        return true;
    }
}

