/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.glassfish.grizzly.threadpool;

import io.hops.hadoop.shaded.org.glassfish.grizzly.memory.MemoryManager;
import io.hops.hadoop.shaded.org.glassfish.grizzly.monitoring.jmx.JmxMonitoringAware;
import io.hops.hadoop.shaded.org.glassfish.grizzly.monitoring.jmx.JmxMonitoringConfig;
import io.hops.hadoop.shaded.org.glassfish.grizzly.threadpool.AbstractThreadPool;
import io.hops.hadoop.shaded.org.glassfish.grizzly.threadpool.FixedThreadPool;
import io.hops.hadoop.shaded.org.glassfish.grizzly.threadpool.QueueLimitedThreadPool;
import io.hops.hadoop.shaded.org.glassfish.grizzly.threadpool.SyncThreadPool;
import io.hops.hadoop.shaded.org.glassfish.grizzly.threadpool.ThreadPoolConfig;
import io.hops.hadoop.shaded.org.glassfish.grizzly.threadpool.ThreadPoolProbe;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public class GrizzlyExecutorService
extends AbstractExecutorService
implements JmxMonitoringAware<ThreadPoolProbe> {
    private final Object statelock = new Object();
    private volatile AbstractThreadPool pool;
    protected volatile ThreadPoolConfig config;

    public static GrizzlyExecutorService createInstance() {
        return GrizzlyExecutorService.createInstance(ThreadPoolConfig.defaultConfig());
    }

    public static GrizzlyExecutorService createInstance(ThreadPoolConfig cfg) {
        return new GrizzlyExecutorService(cfg);
    }

    protected GrizzlyExecutorService(ThreadPoolConfig config) {
        this.setImpl(config);
    }

    protected final void setImpl(ThreadPoolConfig cfg) {
        Queue<Runnable> queue;
        if (cfg == null) {
            throw new IllegalArgumentException("config is null");
        }
        if ((cfg = cfg.copy()).getMemoryManager() == null) {
            cfg.setMemoryManager(MemoryManager.DEFAULT_MEMORY_MANAGER);
        }
        this.pool = !((queue = cfg.getQueue()) != null && !(queue instanceof BlockingQueue) || cfg.getCorePoolSize() >= 0 && cfg.getCorePoolSize() != cfg.getMaxPoolSize()) ? (cfg.getQueueLimit() < 0 ? new FixedThreadPool(cfg) : new QueueLimitedThreadPool(cfg)) : new SyncThreadPool(cfg);
        this.config = cfg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GrizzlyExecutorService reconfigure(ThreadPoolConfig config) {
        Object object = this.statelock;
        synchronized (object) {
            AbstractThreadPool oldpool = this.pool;
            if (config.getQueue() == oldpool.getQueue()) {
                config.setQueue(null);
            }
            this.setImpl(config);
            AbstractThreadPool.drain(oldpool.getQueue(), this.pool.getQueue());
            oldpool.shutdown();
        }
        return this;
    }

    public ThreadPoolConfig getConfiguration() {
        return this.config.copy();
    }

    @Override
    public void shutdown() {
        this.pool.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.pool.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.pool.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.pool.isTerminated();
    }

    @Override
    public void execute(Runnable r) {
        this.pool.execute(r);
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.pool.awaitTermination(timeout, unit);
    }

    @Override
    public JmxMonitoringConfig<ThreadPoolProbe> getMonitoringConfig() {
        return this.pool.getMonitoringConfig();
    }
}

