/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.mockito.cglib.transform.impl;

import io.hops.hadoop.shaded.org.mockito.asm.Type;
import io.hops.hadoop.shaded.org.mockito.cglib.core.CodeEmitter;
import io.hops.hadoop.shaded.org.mockito.cglib.core.Constants;
import io.hops.hadoop.shaded.org.mockito.cglib.core.EmitUtils;
import io.hops.hadoop.shaded.org.mockito.cglib.core.MethodInfo;
import io.hops.hadoop.shaded.org.mockito.cglib.core.ReflectUtils;
import io.hops.hadoop.shaded.org.mockito.cglib.core.TypeUtils;
import io.hops.hadoop.shaded.org.mockito.cglib.transform.ClassEmitterTransformer;
import java.lang.reflect.Method;

public class AddStaticInitTransformer
extends ClassEmitterTransformer {
    private MethodInfo info;

    public AddStaticInitTransformer(Method classInit) {
        this.info = ReflectUtils.getMethodInfo(classInit);
        if (!TypeUtils.isStatic(this.info.getModifiers())) {
            throw new IllegalArgumentException(classInit + " is not static");
        }
        Type[] types = this.info.getSignature().getArgumentTypes();
        if (types.length != 1 || !types[0].equals(Constants.TYPE_CLASS) || !this.info.getSignature().getReturnType().equals(Type.VOID_TYPE)) {
            throw new IllegalArgumentException(classInit + " illegal signature");
        }
    }

    protected void init() {
        if (!TypeUtils.isInterface(this.getAccess())) {
            CodeEmitter e = this.getStaticHook();
            EmitUtils.load_class_this(e);
            e.invoke(this.info);
        }
    }
}

