/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.mockito.internal.progress;

import io.hops.hadoop.shaded.org.hamcrest.Matcher;
import io.hops.hadoop.shaded.org.mockito.exceptions.Reporter;
import io.hops.hadoop.shaded.org.mockito.exceptions.misusing.InvalidUseOfMatchersException;
import io.hops.hadoop.shaded.org.mockito.internal.matchers.And;
import io.hops.hadoop.shaded.org.mockito.internal.matchers.LocalizedMatcher;
import io.hops.hadoop.shaded.org.mockito.internal.matchers.Not;
import io.hops.hadoop.shaded.org.mockito.internal.matchers.Or;
import io.hops.hadoop.shaded.org.mockito.internal.progress.ArgumentMatcherStorage;
import io.hops.hadoop.shaded.org.mockito.internal.progress.HandyReturnValues;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgumentMatcherStorageImpl
implements ArgumentMatcherStorage {
    private Stack<LocalizedMatcher> matcherStack = new Stack();

    @Override
    public HandyReturnValues reportMatcher(Matcher matcher) {
        this.matcherStack.push(new LocalizedMatcher(matcher));
        return new HandyReturnValues();
    }

    @Override
    public List<Matcher> pullMatchers() {
        if (this.matcherStack.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Matcher> matchers = new ArrayList<Matcher>(this.matcherStack);
        this.matcherStack.clear();
        return matchers;
    }

    @Override
    public HandyReturnValues reportAnd() {
        this.assertState(!this.matcherStack.isEmpty(), "No matchers found for And(?).");
        And and = new And(this.popLastArgumentMatchers(2));
        this.matcherStack.push(new LocalizedMatcher(and));
        return new HandyReturnValues();
    }

    @Override
    public HandyReturnValues reportNot() {
        this.assertState(!this.matcherStack.isEmpty(), "No matchers found for Not(?).");
        Not not = new Not(this.popLastArgumentMatchers(1).get(0));
        this.matcherStack.push(new LocalizedMatcher(not));
        return new HandyReturnValues();
    }

    private List<Matcher> popLastArgumentMatchers(int count) {
        this.assertState(!this.matcherStack.isEmpty(), "No matchers found.");
        this.assertState(this.matcherStack.size() >= count, "" + count + " matchers expected, " + this.matcherStack.size() + " recorded.");
        LinkedList<Matcher> result = new LinkedList<Matcher>();
        result.addAll(this.matcherStack.subList(this.matcherStack.size() - count, this.matcherStack.size()));
        for (int i = 0; i < count; ++i) {
            this.matcherStack.pop();
        }
        return result;
    }

    private void assertState(boolean toAssert, String message) {
        if (!toAssert) {
            this.matcherStack.clear();
            throw new InvalidUseOfMatchersException(message);
        }
    }

    @Override
    public HandyReturnValues reportOr() {
        this.assertState(!this.matcherStack.isEmpty(), "No matchers found.");
        Or or = new Or(this.popLastArgumentMatchers(2));
        this.matcherStack.push(new LocalizedMatcher(or));
        return new HandyReturnValues();
    }

    @Override
    public void validateState() {
        if (!this.matcherStack.isEmpty()) {
            LocalizedMatcher lastMatcher = (LocalizedMatcher)this.matcherStack.lastElement();
            this.matcherStack.clear();
            new Reporter().misplacedArgumentMatcher(lastMatcher.getLocation());
        }
    }

    @Override
    public void reset() {
        this.matcherStack.clear();
    }
}

