/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.nustaq.offheap.bytez.bytesource;

import io.hops.hadoop.shaded.org.nustaq.offheap.bytez.ByteSource;
import io.hops.hadoop.shaded.org.nustaq.serialization.util.FSTUtil;
import java.io.UnsupportedEncodingException;

public class UTFStringByteSource
implements ByteSource {
    byte[] bytes;

    public UTFStringByteSource(String key) {
        try {
            this.bytes = key.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            FSTUtil.rethrow(e);
        }
    }

    @Override
    public byte get(long index) {
        return this.bytes[(int)index];
    }

    @Override
    public long length() {
        return this.bytes.length;
    }

    public UTFStringByteSource padLeft(int keyLen) {
        if (this.bytes.length < keyLen) {
            byte[] newBytes = new byte[keyLen];
            System.arraycopy(this.bytes, 0, newBytes, keyLen - this.bytes.length, this.bytes.length);
            this.bytes = newBytes;
        }
        return this;
    }
}

