/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.context;

import io.hops.exception.StorageCallPreventedException;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.dal.InvalidateBlockDataAccess;
import io.hops.metadata.hdfs.entity.InvalidatedBlock;
import io.hops.transaction.context.BaseReplicaContext;
import io.hops.transaction.context.BlockPK;
import io.hops.transaction.lock.TransactionLocks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class InvalidatedBlockContext
extends BaseReplicaContext<BlockPK.ReplicaPK, InvalidatedBlock> {
    private final InvalidateBlockDataAccess<InvalidatedBlock> dataAccess;
    private boolean allInvBlocksRead = false;

    public InvalidatedBlockContext(InvalidateBlockDataAccess dataAccess) {
        this.dataAccess = dataAccess;
    }

    @Override
    public void update(InvalidatedBlock hopInvalidatedBlock) throws TransactionContextException {
        super.update(hopInvalidatedBlock);
        if (this.isLogTraceEnabled()) {
            this.log("added-invblock", new Object[]{"bid", hopInvalidatedBlock.getBlockId(), "sid", hopInvalidatedBlock.getStorageId()});
        }
    }

    @Override
    public void remove(InvalidatedBlock hopInvalidatedBlock) throws TransactionContextException {
        super.remove(hopInvalidatedBlock);
        if (this.isLogTraceEnabled()) {
            this.log("removed-invblock", new Object[]{"bid", hopInvalidatedBlock.getBlockId(), "sid", hopInvalidatedBlock.getStorageId()});
        }
    }

    public InvalidatedBlock find(FinderType<InvalidatedBlock> finder, Object ... params) throws TransactionContextException, StorageException {
        InvalidatedBlock.Finder iFinder = (InvalidatedBlock.Finder)finder;
        switch (iFinder) {
            case ByBlockIdSidAndINodeId: {
                return this.findByPrimaryKey(iFinder, params);
            }
        }
        throw new RuntimeException(UNSUPPORTED_FINDER);
    }

    public Collection<InvalidatedBlock> findList(FinderType<InvalidatedBlock> finder, Object ... params) throws TransactionContextException, StorageException {
        InvalidatedBlock.Finder iFinder = (InvalidatedBlock.Finder)finder;
        switch (iFinder) {
            case ByBlockIdAndINodeId: {
                return this.findByBlockId(iFinder, params);
            }
            case ByINodeId: {
                return this.findByINodeId(iFinder, params);
            }
            case All: {
                return this.findAll(iFinder);
            }
            case BySid: {
                return this.findBySid(iFinder, params);
            }
            case ByINodeIds: {
                return this.findByINodeIds(iFinder, params);
            }
        }
        throw new RuntimeException(UNSUPPORTED_FINDER);
    }

    public void prepare(TransactionLocks tlm) throws TransactionContextException, StorageException {
        this.dataAccess.prepare(this.getRemoved(), this.getAdded(), this.getModified());
    }

    @Override
    public void clear() throws TransactionContextException {
        super.clear();
        this.allInvBlocksRead = false;
    }

    @Override
    InvalidatedBlock cloneEntity(InvalidatedBlock hopInvalidatedBlock) {
        return this.cloneEntity(hopInvalidatedBlock, hopInvalidatedBlock.getInodeId());
    }

    @Override
    InvalidatedBlock cloneEntity(InvalidatedBlock hopInvalidatedBlock, long inodeId) {
        return new InvalidatedBlock(hopInvalidatedBlock.getStorageId(), hopInvalidatedBlock.getBlockId(), inodeId);
    }

    BlockPK.ReplicaPK getKey(InvalidatedBlock hopInvalidatedBlock) {
        return new BlockPK.ReplicaPK(hopInvalidatedBlock.getBlockId(), hopInvalidatedBlock.getInodeId(), hopInvalidatedBlock.getStorageId());
    }

    @Override
    protected boolean snapshotChanged() {
        return !this.getRemoved().isEmpty();
    }

    private InvalidatedBlock findByPrimaryKey(InvalidatedBlock.Finder iFinder, Object[] params) throws StorageCallPreventedException, StorageException {
        long blockId = (Long)params[0];
        int storageId = (Integer)params[1];
        long inodeId = (Long)params[2];
        BlockPK.ReplicaPK key = new BlockPK.ReplicaPK(blockId, inodeId, storageId);
        InvalidatedBlock result = null;
        if (this.contains(key) || this.containsByBlock(blockId) || this.containsByINode(inodeId)) {
            result = (InvalidatedBlock)this.get(key);
            this.hit((FinderType)iFinder, result, new Object[]{"bid", blockId, "sid", storageId, "inodeId", inodeId});
        } else {
            this.aboutToAccessStorage((FinderType)iFinder, params);
            result = (InvalidatedBlock)this.dataAccess.findInvBlockByPkey(blockId, storageId, inodeId);
            this.gotFromDB(key, result);
            this.miss((FinderType)iFinder, result, new Object[]{"bid", blockId, "sid", storageId, "inodeId", inodeId});
        }
        return result;
    }

    private List<InvalidatedBlock> findByBlockId(InvalidatedBlock.Finder iFinder, Object[] params) throws StorageCallPreventedException, StorageException {
        long blockId = (Long)params[0];
        long inodeId = (Long)params[1];
        List result = null;
        if (this.containsByBlock(blockId) || this.containsByINode(inodeId)) {
            result = this.getByBlock(blockId);
            this.hit((FinderType)iFinder, result, new Object[]{"bid", blockId, "inodeId", inodeId});
        } else {
            this.aboutToAccessStorage((FinderType)iFinder, params);
            result = this.dataAccess.findInvalidatedBlocksByBlockId(blockId, inodeId);
            Collections.sort(result);
            this.gotFromDB(new BlockPK(blockId, null), result);
            this.miss((FinderType)iFinder, result, new Object[]{"bid", blockId, "inodeId", inodeId});
        }
        return result;
    }

    private List<InvalidatedBlock> findByINodeId(InvalidatedBlock.Finder iFinder, Object[] params) throws StorageCallPreventedException, StorageException {
        long inodeId = (Long)params[0];
        List result = null;
        if (this.containsByINode(inodeId)) {
            result = this.getByINode(inodeId);
            this.hit((FinderType)iFinder, result, new Object[]{"inodeId", inodeId});
        } else {
            this.aboutToAccessStorage((FinderType)iFinder, params);
            result = this.dataAccess.findInvalidatedBlocksByINodeId(inodeId);
            this.gotFromDB(new BlockPK(null, inodeId), result);
            this.miss((FinderType)iFinder, result, new Object[]{"inodeId", inodeId});
        }
        return result;
    }

    private List<InvalidatedBlock> findAll(InvalidatedBlock.Finder iFinder) throws StorageCallPreventedException, StorageException {
        ArrayList<InvalidatedBlock> result = null;
        if (this.allInvBlocksRead) {
            result = new ArrayList(this.getAll());
            this.hit((FinderType)iFinder, result, new Object[0]);
        } else {
            this.aboutToAccessStorage((FinderType)iFinder);
            result = this.dataAccess.findAllInvalidatedBlocks();
            this.gotFromDB(result);
            this.allInvBlocksRead = true;
            this.miss((FinderType)iFinder, result, new Object[0]);
        }
        return result;
    }

    private List<InvalidatedBlock> findBySid(InvalidatedBlock.Finder iFinder, Object[] params) throws StorageCallPreventedException, StorageException {
        long[] blockIds = (long[])params[0];
        long[] inodeIds = (long[])params[1];
        int sid = (Integer)params[2];
        this.aboutToAccessStorage((FinderType)iFinder, params);
        List result = this.dataAccess.findInvalidatedBlockByStorageId(sid);
        this.gotFromDB(BlockPK.ReplicaPK.getKeys(blockIds, inodeIds, sid), result);
        this.miss((FinderType)iFinder, result, new Object[]{"bids", Arrays.toString(blockIds), "inodeIds", Arrays.toString(inodeIds), "sid", sid});
        return result;
    }

    private List<InvalidatedBlock> findByINodeIds(InvalidatedBlock.Finder iFinder, Object[] params) throws StorageCallPreventedException, StorageException {
        long[] inodeIds = (long[])params[0];
        this.aboutToAccessStorage((FinderType)iFinder, params);
        List result = this.dataAccess.findInvalidatedBlocksByINodeIds(inodeIds);
        this.gotFromDB(BlockPK.ReplicaPK.getKeys(inodeIds), result);
        this.miss((FinderType)iFinder, result, new Object[]{"inodeIds", Arrays.toString(inodeIds)});
        return result;
    }
}

