/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.context;

import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.hdfs.dal.INodeDataAccess;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.LightWeightRequestHandler;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.server.namenode.INode;

public class RootINodeCache {
    protected static final Log LOG = LogFactory.getLog(RootINodeCache.class);
    private static final int UPDATE_TIMER = 200;
    private static RootINodeCacheUpdaterThread rootCacheUpdater;
    private static INode rootINode;
    private static boolean running;
    private static RootINodeCache instance;
    private static final boolean ENABLE_CACHE = true;

    private RootINodeCache() {
    }

    public static RootINodeCache getInstance() {
        return instance;
    }

    public static void start() {
        if (!running) {
            rootCacheUpdater = new RootINodeCacheUpdaterThread();
            rootCacheUpdater.start();
        }
    }

    public static void stop() {
        try {
            if (running) {
                running = false;
                rootCacheUpdater.join();
                rootCacheUpdater = null;
            }
        }
        catch (InterruptedException e) {
            LOG.error((Object)e);
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static INode getRootINode() {
        if (rootCacheUpdater != null) {
            RootINodeCacheUpdaterThread rootINodeCacheUpdaterThread = rootCacheUpdater;
            synchronized (rootINodeCacheUpdaterThread) {
                return rootINode;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forceRefresh() {
        if (rootCacheUpdater != null) {
            RootINodeCacheUpdaterThread rootINodeCacheUpdaterThread = rootCacheUpdater;
            synchronized (rootINodeCacheUpdaterThread) {
                rootINode = null;
            }
        }
    }

    public static boolean isRootInCache() {
        return rootINode != null;
    }

    static {
        rootINode = null;
        running = false;
        instance = new RootINodeCache();
    }

    private static class RootINodeCacheUpdaterThread
    extends Thread {
        private RootINodeCacheUpdaterThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            running = true;
            LOG.debug((Object)"RootCache Started");
            final long rootPartitionId = INode.calculatePartitionId(0L, "", (short)0);
            LightWeightRequestHandler getRootINode = new LightWeightRequestHandler(HDFSOperationType.GET_ROOT){

                public Object performTask() throws IOException {
                    INodeDataAccess da = (INodeDataAccess)HdfsStorageFactory.getDataAccess(INodeDataAccess.class);
                    INode rootINode = (INode)da.findInodeByNameParentIdAndPartitionIdPK("", 0L, rootPartitionId);
                    return rootINode;
                }
            };
            while (running) {
                try {
                    Thread.sleep(200L);
                    INode rootInodeRet = (INode)getRootINode.handle();
                    if (rootInodeRet != null) {
                        RootINodeCacheUpdaterThread rootINodeCacheUpdaterThread = rootCacheUpdater;
                        synchronized (rootINodeCacheUpdaterThread) {
                            rootINode = rootInodeRet;
                            continue;
                        }
                    }
                    LOG.debug((Object)"RootCache: root does not exist.");
                }
                catch (InterruptedException e) {
                    LOG.warn((Object)e);
                    Thread.currentThread().interrupt();
                }
                catch (IOException e) {
                    LOG.warn((Object)e);
                }
            }
        }
    }
}

