/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs;

import io.hops.hadoop.shaded.org.fusesource.leveldbjni.JniDBFactory;
import io.hops.hadoop.shaded.org.fusesource.leveldbjni.internal.NativeDB;
import io.hops.hadoop.shaded.org.iq80.leveldb.DB;
import io.hops.hadoop.shaded.org.iq80.leveldb.DBException;
import io.hops.hadoop.shaded.org.iq80.leveldb.Options;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.mapreduce.v2.api.MRDelegationTokenIdentifier;
import org.apache.hadoop.mapreduce.v2.hs.HistoryServerStateStoreService;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.yarn.proto.YarnServerCommonProtos;
import org.apache.hadoop.yarn.server.records.Version;
import org.apache.hadoop.yarn.server.records.impl.pb.VersionPBImpl;
import org.apache.hadoop.yarn.server.utils.LeveldbIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HistoryServerLeveldbStateStoreService
extends HistoryServerStateStoreService {
    private static final String DB_NAME = "mr-jhs-state";
    private static final String DB_SCHEMA_VERSION_KEY = "jhs-schema-version";
    private static final String TOKEN_MASTER_KEY_KEY_PREFIX = "tokens/key_";
    private static final String TOKEN_STATE_KEY_PREFIX = "tokens/token_";
    private static final Version CURRENT_VERSION_INFO = Version.newInstance(1, 0);
    private DB db;
    public static final Logger LOG = LoggerFactory.getLogger(HistoryServerLeveldbStateStoreService.class);

    @Override
    protected void initStorage(Configuration conf) throws IOException {
    }

    @Override
    protected void startStorage() throws IOException {
        Path storeRoot = this.createStorageDir(this.getConfig());
        Options options = new Options();
        options.createIfMissing(false);
        LOG.info("Using state database at " + storeRoot + " for recovery");
        File dbfile = new File(storeRoot.toString());
        try {
            this.db = JniDBFactory.factory.open(dbfile, options);
        }
        catch (NativeDB.DBException e) {
            if (e.isNotFound() || e.getMessage().contains(" does not exist ")) {
                LOG.info("Creating state database at " + dbfile);
                options.createIfMissing(true);
                try {
                    this.db = JniDBFactory.factory.open(dbfile, options);
                    this.storeVersion();
                }
                catch (DBException dbErr) {
                    throw new IOException(dbErr.getMessage(), dbErr);
                }
            }
            throw e;
        }
        this.checkVersion();
    }

    @Override
    protected void closeStorage() throws IOException {
        if (this.db != null) {
            this.db.close();
            this.db = null;
        }
    }

    @Override
    public HistoryServerStateStoreService.HistoryServerState loadState() throws IOException {
        HistoryServerStateStoreService.HistoryServerState state = new HistoryServerStateStoreService.HistoryServerState();
        int numKeys = this.loadTokenMasterKeys(state);
        LOG.info("Recovered " + numKeys + " token master keys");
        int numTokens = this.loadTokens(state);
        LOG.info("Recovered " + numTokens + " tokens");
        return state;
    }

    private int loadTokenMasterKeys(HistoryServerStateStoreService.HistoryServerState state) throws IOException {
        int numKeys = 0;
        try (LeveldbIterator iter = null;){
            iter = new LeveldbIterator(this.db);
            iter.seek(JniDBFactory.bytes((String)TOKEN_MASTER_KEY_KEY_PREFIX));
            while (iter.hasNext()) {
                Object entry = iter.next();
                String key = JniDBFactory.asString((byte[])((byte[])entry.getKey()));
                if (!key.startsWith(TOKEN_MASTER_KEY_KEY_PREFIX)) {
                    break;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Loading master key from " + key);
                }
                try {
                    this.loadTokenMasterKey(state, (byte[])entry.getValue());
                }
                catch (IOException e) {
                    throw new IOException("Error loading token master key from " + key, e);
                }
                ++numKeys;
            }
        }
        return numKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTokenMasterKey(HistoryServerStateStoreService.HistoryServerState state, byte[] data) throws IOException {
        DelegationKey key = new DelegationKey();
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
        try {
            key.readFields((DataInput)in);
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{in});
            throw throwable;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{in});
        state.tokenMasterKeyState.add(key);
    }

    private int loadTokens(HistoryServerStateStoreService.HistoryServerState state) throws IOException {
        int numTokens = 0;
        try (LeveldbIterator iter = null;){
            iter = new LeveldbIterator(this.db);
            iter.seek(JniDBFactory.bytes((String)TOKEN_STATE_KEY_PREFIX));
            while (iter.hasNext()) {
                Object entry = iter.next();
                String key = JniDBFactory.asString((byte[])((byte[])entry.getKey()));
                if (!key.startsWith(TOKEN_STATE_KEY_PREFIX)) {
                    break;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Loading token from " + key);
                }
                try {
                    this.loadToken(state, (byte[])entry.getValue());
                }
                catch (IOException e) {
                    throw new IOException("Error loading token state from " + key, e);
                }
                ++numTokens;
            }
        }
        return numTokens;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadToken(HistoryServerStateStoreService.HistoryServerState state, byte[] data) throws IOException {
        long renewDate;
        MRDelegationTokenIdentifier tokenId = new MRDelegationTokenIdentifier();
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
        try {
            tokenId.readFields((DataInput)in);
            renewDate = in.readLong();
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{in});
            throw throwable;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{in});
        state.tokenState.put(tokenId, renewDate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeToken(MRDelegationTokenIdentifier tokenId, Long renewDate) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Storing token " + tokenId.getSequenceNumber());
        }
        ByteArrayOutputStream memStream = new ByteArrayOutputStream();
        DataOutputStream dataStream = new DataOutputStream(memStream);
        try {
            tokenId.write((DataOutput)dataStream);
            dataStream.writeLong(renewDate);
            dataStream.close();
            dataStream = null;
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{dataStream});
            throw throwable;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{dataStream});
        String dbKey = this.getTokenDatabaseKey(tokenId);
        try {
            this.db.put(JniDBFactory.bytes((String)dbKey), memStream.toByteArray());
        }
        catch (DBException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void updateToken(MRDelegationTokenIdentifier tokenId, Long renewDate) throws IOException {
        this.storeToken(tokenId, renewDate);
    }

    @Override
    public void removeToken(MRDelegationTokenIdentifier tokenId) throws IOException {
        String dbKey = this.getTokenDatabaseKey(tokenId);
        try {
            this.db.delete(JniDBFactory.bytes((String)dbKey));
        }
        catch (DBException e) {
            throw new IOException(e);
        }
    }

    private String getTokenDatabaseKey(MRDelegationTokenIdentifier tokenId) {
        return TOKEN_STATE_KEY_PREFIX + tokenId.getSequenceNumber();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeTokenMasterKey(DelegationKey masterKey) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Storing master key " + masterKey.getKeyId());
        }
        ByteArrayOutputStream memStream = new ByteArrayOutputStream();
        DataOutputStream dataStream = new DataOutputStream(memStream);
        try {
            masterKey.write((DataOutput)dataStream);
            dataStream.close();
            dataStream = null;
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{dataStream});
            throw throwable;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{dataStream});
        String dbKey = this.getTokenMasterKeyDatabaseKey(masterKey);
        try {
            this.db.put(JniDBFactory.bytes((String)dbKey), memStream.toByteArray());
        }
        catch (DBException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void removeTokenMasterKey(DelegationKey masterKey) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing master key " + masterKey.getKeyId());
        }
        String dbKey = this.getTokenMasterKeyDatabaseKey(masterKey);
        try {
            this.db.delete(JniDBFactory.bytes((String)dbKey));
        }
        catch (DBException e) {
            throw new IOException(e);
        }
    }

    private String getTokenMasterKeyDatabaseKey(DelegationKey masterKey) {
        return TOKEN_MASTER_KEY_KEY_PREFIX + masterKey.getKeyId();
    }

    private Path createStorageDir(Configuration conf) throws IOException {
        String confPath = conf.get("mapreduce.jobhistory.recovery.store.leveldb.path");
        if (confPath == null) {
            throw new IOException("No store location directory configured in mapreduce.jobhistory.recovery.store.leveldb.path");
        }
        Path root = new Path(confPath, DB_NAME);
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        fs.mkdirs(root, new FsPermission(448));
        return root;
    }

    Version loadVersion() throws IOException {
        byte[] data = this.db.get(JniDBFactory.bytes((String)DB_SCHEMA_VERSION_KEY));
        if (data == null || data.length == 0) {
            return Version.newInstance(1, 0);
        }
        VersionPBImpl version = new VersionPBImpl(YarnServerCommonProtos.VersionProto.parseFrom(data));
        return version;
    }

    private void storeVersion() throws IOException {
        this.dbStoreVersion(CURRENT_VERSION_INFO);
    }

    void dbStoreVersion(Version state) throws IOException {
        String key = DB_SCHEMA_VERSION_KEY;
        byte[] data = ((VersionPBImpl)state).getProto().toByteArray();
        try {
            this.db.put(JniDBFactory.bytes((String)key), data);
        }
        catch (DBException e) {
            throw new IOException(e);
        }
    }

    Version getCurrentVersion() {
        return CURRENT_VERSION_INFO;
    }

    private void checkVersion() throws IOException {
        Version loadedVersion = this.loadVersion();
        LOG.info("Loaded state version info " + loadedVersion);
        if (loadedVersion.equals(this.getCurrentVersion())) {
            return;
        }
        if (!loadedVersion.isCompatibleTo(this.getCurrentVersion())) {
            throw new IOException("Incompatible version for state: expecting state version " + this.getCurrentVersion() + ", but loading version " + loadedVersion);
        }
        LOG.info("Storing state version info " + this.getCurrentVersion());
        this.storeVersion();
    }
}

