/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server;

import io.hops.hadoop.shaded.com.google.protobuf.MessageOrBuilder;
import io.hops.hadoop.shaded.com.google.protobuf.TextFormat;
import io.hops.hadoop.shaded.org.apache.commons.io.IOUtils;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationAttemptIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.NodeIdPBImpl;
import org.apache.hadoop.yarn.proto.YarnSecurityTestTokenProtos;
import org.apache.hadoop.yarn.security.NMTokenIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NMTokenIdentifierNewForTest
extends NMTokenIdentifier {
    private static Logger LOG = LoggerFactory.getLogger(NMTokenIdentifierNewForTest.class);
    public static final Text KIND = new Text("NMToken");
    private YarnSecurityTestTokenProtos.NMTokenIdentifierNewProto proto;
    private YarnSecurityTestTokenProtos.NMTokenIdentifierNewProto.Builder builder;

    public NMTokenIdentifierNewForTest() {
        this.builder = YarnSecurityTestTokenProtos.NMTokenIdentifierNewProto.newBuilder();
    }

    public NMTokenIdentifierNewForTest(YarnSecurityTestTokenProtos.NMTokenIdentifierNewProto proto) {
        this.proto = proto;
    }

    public NMTokenIdentifierNewForTest(NMTokenIdentifier tokenIdentifier, String message) {
        this.builder = YarnSecurityTestTokenProtos.NMTokenIdentifierNewProto.newBuilder();
        this.builder.setAppAttemptId(tokenIdentifier.getProto().getAppAttemptId());
        this.builder.setNodeId(tokenIdentifier.getProto().getNodeId());
        this.builder.setAppSubmitter(tokenIdentifier.getApplicationSubmitter());
        this.builder.setKeyId(tokenIdentifier.getKeyId());
        this.builder.setMessage(message);
        this.proto = this.builder.build();
        this.builder = null;
    }

    public void write(DataOutput out) throws IOException {
        LOG.debug("Writing NMTokenIdentifierNewForTest to RPC layer: " + (Object)((Object)this));
        out.write(this.proto.toByteArray());
    }

    public void readFields(DataInput in) throws IOException {
        DataInputStream dis = (DataInputStream)in;
        byte[] buffer = IOUtils.toByteArray((InputStream)dis);
        this.proto = YarnSecurityTestTokenProtos.NMTokenIdentifierNewProto.parseFrom(buffer);
    }

    public Text getKind() {
        return KIND;
    }

    public UserGroupInformation getUser() {
        return null;
    }

    public String getMessage() {
        return this.proto.getMessage();
    }

    public void setMessage(String message) {
        this.builder.setMessage(message);
    }

    public YarnSecurityTestTokenProtos.NMTokenIdentifierNewProto getNewProto() {
        return this.proto;
    }

    public void build() {
        this.proto = this.builder.build();
        this.builder = null;
    }

    public ApplicationAttemptId getApplicationAttemptId() {
        return new ApplicationAttemptIdPBImpl(this.proto.getAppAttemptId());
    }

    public NodeId getNodeId() {
        return new NodeIdPBImpl(this.proto.getNodeId());
    }

    public String getApplicationSubmitter() {
        return this.proto.getAppSubmitter();
    }

    public int getKeyId() {
        return this.proto.getKeyId();
    }

    public int hashCode() {
        return this.proto.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(((Object)((Object)this)).getClass())) {
            return this.getNewProto().equals(((NMTokenIdentifierNewForTest)((Object)((Object)((Object)this)).getClass().cast(other))).getNewProto());
        }
        return false;
    }

    public String toString() {
        return TextFormat.shortDebugString((MessageOrBuilder)this.proto);
    }
}

