/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.nodelabels;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import io.hops.hadoop.shaded.org.apache.commons.lang3.EnumUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.TimerTask;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.NodeAttribute;
import org.apache.hadoop.yarn.api.records.NodeAttributeType;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.nodelabels.NodeLabelUtil;
import org.apache.hadoop.yarn.server.nodemanager.nodelabels.NodeAttributesProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationNodeAttributesProvider
extends NodeAttributesProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationNodeAttributesProvider.class);
    private static final String NODE_ATTRIBUTES_DELIMITER = ":";
    private static final String NODE_ATTRIBUTE_DELIMITER = ",";

    public ConfigurationNodeAttributesProvider() {
        super("Configuration Based Node Attributes Provider");
    }

    @Override
    protected void serviceInit(Configuration conf) throws Exception {
        long taskInterval = conf.getLong("yarn.nodemanager.node-attributes.provider.fetch-interval-ms", 600000L);
        this.setIntervalTime(taskInterval);
        super.serviceInit(conf);
    }

    private void updateNodeAttributesFromConfig(Configuration conf) throws IOException {
        String configuredNodeAttributes = conf.get("yarn.nodemanager.node-attributes.provider.configured-node-attributes", null);
        this.setDescriptors(this.parseAttributes(configuredNodeAttributes));
    }

    @VisibleForTesting
    public Set<NodeAttribute> parseAttributes(String config) throws IOException {
        String[] attributeStrs;
        if (Strings.isNullOrEmpty((String)config)) {
            return ImmutableSet.of();
        }
        HashSet<NodeAttribute> attributeSet = new HashSet<NodeAttribute>();
        for (String attributeStr : attributeStrs = config.split(NODE_ATTRIBUTES_DELIMITER)) {
            String[] fields = attributeStr.split(NODE_ATTRIBUTE_DELIMITER);
            if (fields.length != 3) {
                throw new IOException("Invalid value for yarn.nodemanager.node-attributes.provider.configured-node-attributes=" + config);
            }
            if (fields[0].contains("/")) {
                throw new IOException("Node attribute set in yarn.nodemanager.node-attributes.provider.configured-node-attributes should not contain any prefix.");
            }
            if (!EnumUtils.isValidEnum(NodeAttributeType.class, (String)fields[1])) {
                throw new IOException("Invalid node attribute type: " + fields[1] + ", valid values are " + Arrays.asList(NodeAttributeType.values()));
            }
            NodeAttribute na = NodeAttribute.newInstance((String)"nm.yarn.io", (String)fields[0], (NodeAttributeType)NodeAttributeType.valueOf((String)fields[1]), (String)fields[2]);
            if (attributeSet.add(na)) continue;
            throw new IOException("Ambiguous node attribute is found: " + na.toString() + ", a same attribute already exists");
        }
        try {
            NodeLabelUtil.validateNodeAttributes(attributeSet);
        }
        catch (IOException e) {
            throw new IOException("Node attributes set by configuration property: yarn.nodemanager.node-attributes.provider.configured-node-attributes is not valid. Detail message: " + e.getMessage());
        }
        return attributeSet;
    }

    @Override
    protected void cleanUp() throws Exception {
    }

    @Override
    public TimerTask createTimerTask() {
        return new ConfigurationMonitorTimerTask();
    }

    private class ConfigurationMonitorTimerTask
    extends TimerTask {
        private ConfigurationMonitorTimerTask() {
        }

        @Override
        public void run() {
            try {
                ConfigurationNodeAttributesProvider.this.updateNodeAttributesFromConfig((Configuration)new YarnConfiguration());
            }
            catch (Exception e) {
                LOG.error("Failed to update node attributes from yarn.nodemanager.node-attributes.provider.configured-node-attributes", (Throwable)e);
            }
        }
    }
}

