/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.webapp;

import io.hops.hadoop.shaded.com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.AuthenticationFilterInitializer;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.LocalDirsHandlerService;
import org.apache.hadoop.yarn.server.nodemanager.ResourceView;
import org.apache.hadoop.yarn.server.nodemanager.webapp.JAXBContextResolver;
import org.apache.hadoop.yarn.server.nodemanager.webapp.NMController;
import org.apache.hadoop.yarn.server.nodemanager.webapp.NMWebAppFilter;
import org.apache.hadoop.yarn.server.nodemanager.webapp.NMWebServices;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.WebApp;
import org.apache.hadoop.yarn.webapp.WebApps;
import org.apache.hadoop.yarn.webapp.YarnWebParams;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebServer
extends AbstractService {
    private static final Logger LOG = LoggerFactory.getLogger(WebServer.class);
    private final Context nmContext;
    private final NMWebApp nmWebApp;
    private WebApp webApp;
    private int port;

    public WebServer(Context nmContext, ResourceView resourceView, ApplicationACLsManager aclsManager, LocalDirsHandlerService dirsHandler) {
        super(WebServer.class.getName());
        this.nmContext = nmContext;
        this.nmWebApp = new NMWebApp(resourceView, aclsManager, dirsHandler);
    }

    protected void serviceStart() throws Exception {
        Configuration conf = this.getConfig();
        String bindAddress = WebAppUtils.getWebAppBindURL((Configuration)conf, (String)"yarn.nodemanager.bind-host", (String)WebAppUtils.getNMWebAppURLWithoutScheme((Configuration)conf));
        boolean enableCors = conf.getBoolean("yarn.nodemanager.webapp.cross-origin.enabled", false);
        if (enableCors) {
            this.getConfig().setBoolean("hadoop.http.cross-origin.enabled", true);
        }
        boolean hasHadoopAuthFilterInitializer = false;
        String filterInitializerConfKey = "hadoop.http.filter.initializers";
        Class[] initializersClasses = conf.getClasses(filterInitializerConfKey, new Class[0]);
        ArrayList<String> targets = new ArrayList<String>();
        if (initializersClasses != null) {
            for (Class initializer : initializersClasses) {
                if (initializer.getName().equals(AuthenticationFilterInitializer.class.getName())) {
                    hasHadoopAuthFilterInitializer = true;
                    break;
                }
                targets.add(initializer.getName());
            }
        }
        if (!hasHadoopAuthFilterInitializer) {
            targets.add(AuthenticationFilterInitializer.class.getName());
            conf.set(filterInitializerConfKey, StringUtils.join((CharSequence)",", targets));
        }
        LOG.info("Instantiating NMWebApp at " + bindAddress);
        try {
            this.webApp = WebApps.$for((String)"node", Context.class, (Object)this.nmContext, (String)"ws").at(bindAddress).with(conf).withHttpSpnegoPrincipalKey("yarn.nodemanager.webapp.spnego-principal").withHttpSpnegoKeytabKey("yarn.nodemanager.webapp.spnego-keytab-file").withCSRFProtection("yarn.nodemanager.webapp.rest-csrf.").withXFSProtection("yarn.nodemanager.webapp.xfs-filter.").start((WebApp)this.nmWebApp);
            this.port = this.webApp.httpServer().getConnectorAddress(0).getPort();
        }
        catch (Exception e) {
            String msg = "NMWebapps failed to start.";
            LOG.error(msg, (Throwable)e);
            throw new YarnRuntimeException(msg, (Throwable)e);
        }
        super.serviceStart();
    }

    public int getPort() {
        return this.port;
    }

    protected void serviceStop() throws Exception {
        if (this.webApp != null) {
            LOG.debug("Stopping webapp");
            this.webApp.stop();
        }
        super.serviceStop();
    }

    public static class NMWebApp
    extends WebApp
    implements YarnWebParams {
        private final ResourceView resourceView;
        private final ApplicationACLsManager aclsManager;
        private final LocalDirsHandlerService dirsHandler;

        public NMWebApp(ResourceView resourceView, ApplicationACLsManager aclsManager, LocalDirsHandlerService dirsHandler) {
            this.resourceView = resourceView;
            this.aclsManager = aclsManager;
            this.dirsHandler = dirsHandler;
        }

        public void setup() {
            this.bind(NMWebServices.class);
            this.bind(GenericExceptionHandler.class);
            this.bind(JAXBContextResolver.class);
            this.bind(ResourceView.class).toInstance(this.resourceView);
            this.bind(ApplicationACLsManager.class).toInstance(this.aclsManager);
            this.bind(LocalDirsHandlerService.class).toInstance(this.dirsHandler);
            this.route("/", NMController.class, "info");
            this.route("/node", NMController.class, "node");
            this.route("/allApplications", NMController.class, "allApplications");
            this.route("/allContainers", NMController.class, "allContainers");
            this.route(StringHelper.pajoin((Object[])new Object[]{"/application", "app.id"}), NMController.class, "application");
            this.route(StringHelper.pajoin((Object[])new Object[]{"/container", "container.id"}), NMController.class, "container");
            this.route(StringHelper.pajoin((Object[])new Object[]{"/containerlogs", "container.id", "app.owner", "log.type"}), NMController.class, "logs");
            this.route("/errors-and-warnings", NMController.class, "errorsAndWarnings");
        }

        protected Class<? extends GuiceContainer> getWebAppFilterClass() {
            return NMWebAppFilter.class;
        }
    }
}

