/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery;

import io.hops.hadoop.shaded.com.google.protobuf.InvalidProtocolBufferException;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.security.client.YARNDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.RMDelegationTokenIdentifierData;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class RMStateStoreUtils {
    public static final Log LOG = LogFactory.getLog(RMStateStoreUtils.class);

    public static RMDelegationTokenIdentifierData readRMDelegationTokenIdentifierData(DataInputStream fsIn) throws IOException {
        RMDelegationTokenIdentifierData identifierData = new RMDelegationTokenIdentifierData();
        try {
            identifierData.readFields(fsIn);
        }
        catch (InvalidProtocolBufferException e) {
            LOG.warn((Object)"Recovering old formatted token");
            fsIn.reset();
            RMDelegationTokenIdentifier identifier = new RMDelegationTokenIdentifier();
            identifier.readFieldsInOldFormat((DataInput)fsIn);
            identifierData.setIdentifier((YARNDelegationTokenIdentifier)identifier);
            identifierData.setRenewDate(fsIn.readLong());
        }
        return identifierData;
    }
}

