/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.security;

import com.google.common.annotations.VisibleForTesting;
import io.hops.hadoop.shaded.org.apache.commons.io.FileUtils;
import io.hops.hadoop.shaded.org.apache.commons.lang3.RandomStringUtils;
import io.hops.hadoop.shaded.org.apache.commons.math3.util.Pair;
import io.hops.hadoop.shaded.org.bouncycastle.asn1.x500.X500Name;
import io.hops.hadoop.shaded.org.bouncycastle.asn1.x500.X500NameBuilder;
import io.hops.hadoop.shaded.org.bouncycastle.asn1.x500.style.BCStyle;
import io.hops.hadoop.shaded.org.bouncycastle.operator.OperatorCreationException;
import io.hops.hadoop.shaded.org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import io.hops.hadoop.shaded.org.bouncycastle.pkcs.PKCS10CertificationRequest;
import io.hops.hadoop.shaded.org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import io.hops.security.CertificateLocalizationService;
import io.hops.security.HopsUtil;
import io.hops.security.SuperuserKeystoresLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.ssl.FileBasedKeyStoresFactory;
import org.apache.hadoop.security.ssl.SSLFactory;
import org.apache.hadoop.security.ssl.X509SecurityMaterial;
import org.apache.hadoop.util.BackOff;
import org.apache.hadoop.util.DateUtils;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppSecurityMaterialRenewedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppSecurityActions;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppSecurityHandler;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppSecurityManager;

public class X509SecurityHandler
implements RMAppSecurityHandler<X509SecurityManagerMaterial, X509MaterialParameter> {
    private static final Log LOG = LogFactory.getLog(X509SecurityHandler.class);
    private static final String SECURITY_PROVIDER = "BC";
    private static final String KEY_ALGORITHM = "RSA";
    private static final String SIGNATURE_ALGORITHM = "SHA256withRSA";
    private static final int REVOCATION_QUEUE_SIZE = 100;
    private final String TMP = System.getProperty("java.io.tmpdir");
    private final RMContext rmContext;
    private final RMAppSecurityManager rmAppSecurityManager;
    private final SecureRandom rng;
    private final EventHandler eventHandler;
    private SuperuserKeystoresLoader superuserKeystoresLoader;
    private CertificateLocalizationService certificateLocalizationService;
    private RMAppSecurityActions rmAppSecurityActions;
    private KeyPairGenerator keyPairGenerator;
    private boolean hopsTLSEnabled = false;
    private Configuration config;
    private Long amountOfTimeToSubstractFromExpiration = 2L;
    private TemporalUnit renewalUnitOfTime = ChronoUnit.DAYS;
    private final Map<ApplicationId, ScheduledFuture> renewalTasks;
    private ScheduledExecutorService renewalExecutorService;
    private Long revocationMonitorInterval = 10L;
    private TemporalUnit revocationUnitOfInterval = ChronoUnit.HOURS;
    private final BlockingQueue<CertificateRevocationEvent> revocationEvents;
    private Thread revocationEventsHandler;
    private Thread revocationMonitor;

    public X509SecurityHandler(RMContext rmContext, RMAppSecurityManager rmAppSecurityManager) {
        this.rmContext = rmContext;
        this.rmAppSecurityManager = rmAppSecurityManager;
        this.rng = new SecureRandom();
        this.eventHandler = rmContext.getDispatcher().getEventHandler();
        this.revocationEvents = new ArrayBlockingQueue<CertificateRevocationEvent>(100);
        this.renewalTasks = new ConcurrentHashMap<ApplicationId, ScheduledFuture>();
    }

    @VisibleForTesting
    protected RMContext getRmContext() {
        return this.rmContext;
    }

    @VisibleForTesting
    protected ScheduledExecutorService getRenewerScheduler() {
        return this.renewalExecutorService;
    }

    @Override
    public void init(Configuration config) throws Exception {
        LOG.info((Object)"Initializing X.509 Security Handler");
        this.config = config;
        this.hopsTLSEnabled = config.getBoolean("ipc.server.ssl.enabled", false);
        this.renewalExecutorService = this.rmAppSecurityManager.getRenewalExecutorService();
        String delayConfiguration = config.get(YarnConfiguration.RM_APP_CERTIFICATE_EXPIRATION_SAFETY_PERIOD, "2d");
        Pair<Long, TemporalUnit> delayIntervalUnit = this.rmAppSecurityManager.parseInterval(delayConfiguration, YarnConfiguration.RM_APP_CERTIFICATE_EXPIRATION_SAFETY_PERIOD);
        this.amountOfTimeToSubstractFromExpiration = (Long)delayIntervalUnit.getFirst();
        this.renewalUnitOfTime = (TemporalUnit)delayIntervalUnit.getSecond();
        String confMonitorInterval = config.get(YarnConfiguration.RM_APP_CERTIFICATE_REVOCATION_MONITOR_INTERVAL, "10h");
        Pair<Long, TemporalUnit> monitorIntervalUnit = this.rmAppSecurityManager.parseInterval(confMonitorInterval, YarnConfiguration.RM_APP_CERTIFICATE_REVOCATION_MONITOR_INTERVAL);
        this.revocationMonitorInterval = (Long)monitorIntervalUnit.getFirst();
        this.revocationUnitOfInterval = (TemporalUnit)monitorIntervalUnit.getSecond();
        int keySize = config.getInt(YarnConfiguration.RM_APP_CERTIFICATE_KEY_SIZE, 2048);
        if (this.isHopsTLSEnabled()) {
            this.superuserKeystoresLoader = new SuperuserKeystoresLoader(config);
            this.certificateLocalizationService = this.rmContext.getCertificateLocalizationService();
            this.rmAppSecurityActions = this.rmAppSecurityManager.getRmAppCertificateActions();
            this.keyPairGenerator = KeyPairGenerator.getInstance(KEY_ALGORITHM, SECURITY_PROVIDER);
            this.keyPairGenerator.initialize(keySize);
        }
    }

    @Override
    public void start() throws Exception {
        LOG.info((Object)"Starting X.509 Security Handler");
        if (this.isHopsTLSEnabled()) {
            this.revocationEventsHandler = new RevocationEventsHandler();
            this.revocationEventsHandler.setDaemon(false);
            this.revocationEventsHandler.setName("X509-RevocationEventsHandler");
            this.revocationEventsHandler.start();
            this.revocationMonitor = new CertificateRevocationMonitor();
            this.revocationMonitor.setDaemon(true);
            this.revocationMonitor.setName("X.509-RevocationMonitor");
            this.revocationMonitor.start();
        }
    }

    @Override
    public void stop() throws Exception {
        LOG.info((Object)"Stopping X.509 Security Handler");
        if (this.revocationMonitor != null) {
            this.revocationMonitor.interrupt();
        }
        if (this.revocationEventsHandler != null) {
            this.revocationEventsHandler.interrupt();
        }
    }

    @VisibleForTesting
    protected RMAppSecurityActions getRmAppSecurityActions() {
        return this.rmAppSecurityActions;
    }

    @VisibleForTesting
    protected Configuration getConfig() {
        return this.config;
    }

    @Override
    public X509SecurityManagerMaterial generateMaterial(X509MaterialParameter materialParameter) throws Exception {
        if (!this.isHopsTLSEnabled()) {
            return null;
        }
        ApplicationId appId = materialParameter.getApplicationId();
        String appUser = materialParameter.appUser;
        Integer cryptoMaterialVersion = materialParameter.cryptoMaterialVersion;
        KeyPair keyPair = this.generateKeyPair();
        PKCS10CertificationRequest csr = this.generateCSR(appId, appUser, keyPair, cryptoMaterialVersion);
        CertificateBundle certificateBundle = this.sendCSRAndGetSigned(csr);
        long expirationEpoch = certificateBundle.certificate.getNotAfter().getTime();
        KeyStoresWrapper keyStoresWrapper = this.createApplicationStores(certificateBundle, keyPair.getPrivate(), appUser, appId);
        byte[] rawProtectedKeyStore = keyStoresWrapper.getRawKeyStore(TYPE.KEYSTORE);
        byte[] rawTrustStore = keyStoresWrapper.getRawKeyStore(TYPE.TRUSTSTORE);
        this.certificateLocalizationService.materializeCertificates(appUser, appId.toString(), appUser, ByteBuffer.wrap(rawProtectedKeyStore), String.valueOf(keyStoresWrapper.keyStorePassword), ByteBuffer.wrap(rawTrustStore), String.valueOf(keyStoresWrapper.trustStorePassword));
        return new X509SecurityManagerMaterial(appId, rawProtectedKeyStore, keyStoresWrapper.keyStorePassword, rawTrustStore, keyStoresWrapper.trustStorePassword, expirationEpoch);
    }

    @Override
    public void registerRenewer(X509MaterialParameter parameter) {
        if (!this.isHopsTLSEnabled()) {
            return;
        }
        if (!this.renewalTasks.containsKey(parameter.getApplicationId())) {
            LocalDateTime now = DateUtils.getNow();
            LocalDateTime expirationDate = DateUtils.unixEpoch2LocalDateTime((long)parameter.getExpiration());
            Duration validityPeriod = Duration.between(now, expirationDate);
            Duration delay = validityPeriod.minus(this.amountOfTimeToSubstractFromExpiration, this.renewalUnitOfTime);
            ScheduledFuture<?> renewTask = this.renewalExecutorService.schedule(this.createCertificateRenewerTask(parameter.getApplicationId(), parameter.appUser, parameter.cryptoMaterialVersion), delay.getSeconds(), TimeUnit.SECONDS);
            this.renewalTasks.put(parameter.getApplicationId(), renewTask);
        }
    }

    public void deregisterFromCertificateRenewer(ApplicationId appId) {
        if (!this.isHopsTLSEnabled()) {
            return;
        }
        ScheduledFuture task = this.renewalTasks.remove(appId);
        if (task != null) {
            task.cancel(true);
        }
    }

    @VisibleForTesting
    protected Runnable createCertificateRenewerTask(ApplicationId appId, String appUser, Integer currentCryptoVersion) {
        return new X509Renewer(appId, appUser, currentCryptoVersion);
    }

    @Override
    public boolean revokeMaterial(X509MaterialParameter materialParameter, Boolean blocking) {
        if (!this.isHopsTLSEnabled()) {
            return true;
        }
        ApplicationId appId = materialParameter.getApplicationId();
        String appUser = materialParameter.appUser;
        Integer cryptoMaterialVersion = materialParameter.cryptoMaterialVersion;
        LOG.info((Object)("Revoking certificate for application: " + appId + " with version " + cryptoMaterialVersion));
        try {
            if (!materialParameter.isFromRenewal) {
                this.deregisterFromCertificateRenewer(appId);
                if (this.certificateLocalizationService != null) {
                    this.certificateLocalizationService.removeX509Material(appUser, appId.toString());
                }
            }
            if (blocking.booleanValue()) {
                return this.revokeInternal(X509SecurityHandler.getCertificateIdentifier(appId, appUser, cryptoMaterialVersion));
            }
            this.putToQueue(appId, appUser, cryptoMaterialVersion);
        }
        catch (InterruptedException ex) {
            LOG.warn((Object)("Shutting down while putting revocation event for user " + appUser + " and application " + appId), (Throwable)ex);
        }
        return false;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected void putToQueue(ApplicationId appId, String applicationUser, Integer cryptoMaterialVersion) throws InterruptedException {
        this.revocationEvents.put(new CertificateRevocationEvent(X509SecurityHandler.getCertificateIdentifier(appId, applicationUser, cryptoMaterialVersion)));
    }

    public static String getCertificateIdentifier(ApplicationId appId, String user, Integer cryptoMaterialVersion) {
        return user + "__" + appId.toString() + "__" + cryptoMaterialVersion;
    }

    public char[] generateRandomPassword() {
        return RandomStringUtils.random((int)20, (int)0, (int)0, (boolean)true, (boolean)true, null, (Random)this.rng).toCharArray();
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public KeyStore loadSystemTrustStore(Configuration conf) throws GeneralSecurityException, IOException {
        String sslConfName = conf.get("hadoop.ssl.server.conf", "ssl-server.xml");
        Configuration sslConf = new Configuration();
        sslConf.addResource(sslConfName);
        String trustStoreType = sslConf.get(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)SSLFactory.Mode.SERVER, (String)"ssl.{0}.truststore.type"), "jks");
        if (this.superuserKeystoresLoader == null) {
            throw new GeneralSecurityException("Tried to load system truststore but SuperuserKeystoreLoader has not been initialized");
        }
        X509SecurityMaterial x509Material = this.superuserKeystoresLoader.loadSuperUserMaterial();
        String truststorePassword = HopsUtil.readCryptoMaterialPassword((File)x509Material.getPasswdLocation().toFile());
        KeyStore truststore = KeyStore.getInstance(trustStoreType);
        try (FileInputStream fis = new FileInputStream(x509Material.getTrustStoreLocation().toFile());){
            truststore.load(fis, truststorePassword.toCharArray());
        }
        return truststore;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected KeyPair generateKeyPair() {
        return this.keyPairGenerator.genKeyPair();
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected PKCS10CertificationRequest generateCSR(ApplicationId appId, String applicationUser, KeyPair keyPair, Integer cryptoMaterialVersion) throws OperatorCreationException {
        LOG.info((Object)("Generating certificate for application: " + appId));
        X500Name subject = this.createX500Subject(appId, applicationUser, cryptoMaterialVersion);
        return this.createCSR(subject, keyPair);
    }

    private X500Name createX500Subject(ApplicationId appId, String applicationUser, Integer cryptoMaterialVersion) {
        if (appId == null || applicationUser == null) {
            throw new IllegalArgumentException("ApplicationID and application user cannot be null");
        }
        X500NameBuilder x500NameBuilder = new X500NameBuilder(BCStyle.INSTANCE);
        x500NameBuilder.addRDN(BCStyle.CN, applicationUser);
        x500NameBuilder.addRDN(BCStyle.O, appId.toString());
        x500NameBuilder.addRDN(BCStyle.OU, cryptoMaterialVersion.toString());
        return x500NameBuilder.build();
    }

    private PKCS10CertificationRequest createCSR(X500Name subject, KeyPair keyPair) throws OperatorCreationException {
        JcaPKCS10CertificationRequestBuilder csrBuilder = new JcaPKCS10CertificationRequestBuilder(subject, keyPair.getPublic());
        return csrBuilder.build(new JcaContentSignerBuilder(SIGNATURE_ALGORITHM).setProvider(SECURITY_PROVIDER).build(keyPair.getPrivate()));
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected CertificateBundle sendCSRAndGetSigned(PKCS10CertificationRequest csr) throws URISyntaxException, IOException, GeneralSecurityException {
        return this.rmAppSecurityActions.sign(csr);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected KeyStoresWrapper createApplicationStores(CertificateBundle certificateBundle, PrivateKey privateKey, String appUser, ApplicationId appId) throws GeneralSecurityException, IOException {
        char[] password = this.generateRandomPassword();
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null, null);
        Certificate[] chain = new X509Certificate[]{certificateBundle.certificate, certificateBundle.issuer};
        keyStore.setKeyEntry(appUser, privateKey, password, chain);
        KeyStore systemTrustStore = this.loadSystemTrustStore(this.config);
        KeyStore appTrustStore = KeyStore.getInstance("JKS");
        appTrustStore.load(null, null);
        Enumeration<String> aliases = systemTrustStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            X509Certificate cert = (X509Certificate)systemTrustStore.getCertificate(alias);
            appTrustStore.setCertificateEntry(alias, cert);
        }
        return new KeyStoresWrapper(keyStore, password, appTrustStore, password, appUser, appId);
    }

    private boolean revokeInternal(String certificateIdentifier) {
        if (this.isHopsTLSEnabled()) {
            try {
                this.rmAppSecurityActions.revoke(certificateIdentifier);
                return true;
            }
            catch (IOException | URISyntaxException | GeneralSecurityException ex) {
                LOG.error((Object)("Could not revoke certificate " + certificateIdentifier), (Throwable)ex);
                return false;
            }
        }
        return true;
    }

    @VisibleForTesting
    protected void waitForQueueToDrain() throws InterruptedException {
        if (this.revocationEventsHandler == null || !this.revocationEventsHandler.isAlive()) {
            return;
        }
        while (this.revocationEvents.peek() != null) {
            TimeUnit.MILLISECONDS.sleep(30L);
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public boolean isHopsTLSEnabled() {
        return this.hopsTLSEnabled;
    }

    @VisibleForTesting
    public Map<ApplicationId, ScheduledFuture> getRenewalTasks() {
        return this.renewalTasks;
    }

    private class RevocationEventsHandler
    extends Thread {
        private RevocationEventsHandler() {
        }

        private void drain() {
            ArrayList events = new ArrayList(X509SecurityHandler.this.revocationEvents.size());
            X509SecurityHandler.this.revocationEvents.drainTo(events);
            for (CertificateRevocationEvent event : events) {
                X509SecurityHandler.this.revokeInternal(event.identifier);
            }
        }

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    CertificateRevocationEvent event = (CertificateRevocationEvent)X509SecurityHandler.this.revocationEvents.take();
                    X509SecurityHandler.this.revokeInternal(event.identifier);
                }
                catch (InterruptedException ex) {
                    LOG.info((Object)"RevocationEventsHandler interrupted. Exiting...");
                    this.drain();
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private class CertificateRevocationEvent {
        private final String identifier;

        private CertificateRevocationEvent(String identifier) {
            this.identifier = identifier;
        }
    }

    protected class KeyStoresWrapper {
        private final KeyStore keystore;
        private final char[] keyStorePassword;
        private final KeyStore trustStore;
        private final char[] trustStorePassword;
        private final String appUser;
        private final ApplicationId appId;

        private KeyStoresWrapper(KeyStore keyStore, char[] keyStorePassword, KeyStore trustStore, char[] trustStorePassword, String appUser, ApplicationId appId) {
            this.keystore = keyStore;
            this.keyStorePassword = keyStorePassword;
            this.trustStore = trustStore;
            this.trustStorePassword = trustStorePassword;
            this.appUser = appUser;
            this.appId = appId;
        }

        protected KeyStore getKeystore() {
            return this.keystore;
        }

        protected char[] getKeyStorePassword() {
            return this.keyStorePassword;
        }

        protected KeyStore getTrustStore() {
            return this.trustStore;
        }

        protected char[] getTrustStorePassword() {
            return this.trustStorePassword;
        }

        protected byte[] getRawKeyStore(TYPE type) throws GeneralSecurityException, IOException {
            KeyStore keyStore;
            char[] password;
            File target;
            if (type.equals((Object)TYPE.KEYSTORE)) {
                target = Paths.get(X509SecurityHandler.this.TMP, this.appUser + "-" + this.appId.toString() + "_kstore.jks").toFile();
                password = this.keyStorePassword;
                keyStore = this.keystore;
            } else {
                target = Paths.get(X509SecurityHandler.this.TMP, this.appUser + "-" + this.appId.toString() + "_tstore.jks").toFile();
                password = this.trustStorePassword;
                keyStore = this.trustStore;
            }
            try (FileOutputStream fos = new FileOutputStream(target, false);){
                keyStore.store(fos, password);
            }
            byte[] rawKeyStore = Files.readAllBytes(target.toPath());
            FileUtils.deleteQuietly((File)target);
            return rawKeyStore;
        }
    }

    protected static class CertificateBundle {
        private final X509Certificate certificate;
        private final X509Certificate issuer;

        protected CertificateBundle(X509Certificate certificate, X509Certificate issuer) {
            this.certificate = certificate;
            this.issuer = issuer;
        }

        public X509Certificate getCertificate() {
            return this.certificate;
        }

        public X509Certificate getIssuer() {
            return this.issuer;
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected class X509Renewer
    implements Runnable {
        protected final ApplicationId appId;
        protected final String appUser;
        protected final BackOff backOff;
        protected Integer currentCryptoVersion;
        protected long backOffTime = 0L;

        public X509Renewer(ApplicationId appId, String appUser, Integer currentCryptoVersion) {
            this.appId = appId;
            this.appUser = appUser;
            this.currentCryptoVersion = currentCryptoVersion;
            this.backOff = X509SecurityHandler.this.rmAppSecurityManager.createBackOffPolicy();
        }

        @Override
        public void run() {
            try {
                LOG.debug((Object)("Renewing certificate for application " + this.appId));
                KeyPair keyPair = X509SecurityHandler.this.generateKeyPair();
                this.currentCryptoVersion = this.currentCryptoVersion + 1;
                PKCS10CertificationRequest csr = X509SecurityHandler.this.generateCSR(this.appId, this.appUser, keyPair, this.currentCryptoVersion);
                CertificateBundle certificateBundle = X509SecurityHandler.this.sendCSRAndGetSigned(csr);
                long expiration = certificateBundle.certificate.getNotAfter().getTime();
                KeyStoresWrapper keyStoresWrapper = X509SecurityHandler.this.createApplicationStores(certificateBundle, keyPair.getPrivate(), this.appUser, this.appId);
                byte[] rawProtectedKeyStore = keyStoresWrapper.getRawKeyStore(TYPE.KEYSTORE);
                byte[] rawTrustStore = keyStoresWrapper.getRawKeyStore(TYPE.TRUSTSTORE);
                X509SecurityHandler.this.rmContext.getCertificateLocalizationService().updateX509(this.appUser, this.appId.toString(), ByteBuffer.wrap(rawProtectedKeyStore), String.valueOf(keyStoresWrapper.keyStorePassword), ByteBuffer.wrap(rawTrustStore), String.valueOf(keyStoresWrapper.trustStorePassword));
                X509SecurityHandler.this.renewalTasks.remove(this.appId);
                X509SecurityManagerMaterial x509Material = new X509SecurityManagerMaterial(this.appId, rawProtectedKeyStore, keyStoresWrapper.keyStorePassword, rawTrustStore, keyStoresWrapper.trustStorePassword, expiration);
                X509SecurityHandler.this.eventHandler.handle(new RMAppSecurityMaterialRenewedEvent<X509SecurityManagerMaterial>(this.appId, x509Material));
                LOG.debug((Object)("Renewed certificate for application " + this.appId));
            }
            catch (Exception ex) {
                X509SecurityHandler.this.renewalTasks.remove(this.appId);
                this.backOffTime = this.backOff.getBackOffInMillis();
                if (this.backOffTime != -1L) {
                    LOG.warn((Object)("Failed to renew certificate for application " + this.appId + ". Retrying in " + this.backOffTime + " ms"));
                    ScheduledFuture<?> task = X509SecurityHandler.this.renewalExecutorService.schedule(this, this.backOffTime, TimeUnit.MILLISECONDS);
                    X509SecurityHandler.this.renewalTasks.put(this.appId, task);
                }
                LOG.error((Object)("Failed to renew certificate for application " + this.appId + ". Failed more than 4 times, giving up"), (Throwable)ex);
            }
        }
    }

    private class CertificateRevocationMonitor
    extends Thread {
        private final Map<ChronoUnit, TimeUnit> CHRONO_MAPPING = new HashMap<ChronoUnit, TimeUnit>();
        private final TimeUnit intervalForSleep;

        private CertificateRevocationMonitor() {
            this.CHRONO_MAPPING.put(ChronoUnit.MILLIS, TimeUnit.MILLISECONDS);
            this.CHRONO_MAPPING.put(ChronoUnit.SECONDS, TimeUnit.SECONDS);
            this.CHRONO_MAPPING.put(ChronoUnit.MINUTES, TimeUnit.MINUTES);
            this.CHRONO_MAPPING.put(ChronoUnit.HOURS, TimeUnit.HOURS);
            this.CHRONO_MAPPING.put(ChronoUnit.DAYS, TimeUnit.DAYS);
            this.intervalForSleep = this.CHRONO_MAPPING.get(X509SecurityHandler.this.revocationUnitOfInterval);
        }

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    LocalDateTime now = DateUtils.getNow();
                    for (Map.Entry entry : X509SecurityHandler.this.rmContext.getRMApps().entrySet()) {
                        RMApp app = (RMApp)entry.getValue();
                        if (!app.isAppRotatingCryptoMaterial() || !DateUtils.unixEpoch2LocalDateTime((long)app.getMaterialRotationStartTime()).minus(X509SecurityHandler.this.revocationMonitorInterval, X509SecurityHandler.this.revocationUnitOfInterval).isBefore(now)) continue;
                        Integer versionToRevoke = app.getCryptoMaterialVersion() - 1;
                        LOG.debug((Object)("Revoking certificate for app " + entry.getKey() + " with version " + versionToRevoke));
                        X509SecurityHandler.this.putToQueue(app.getApplicationId(), app.getUser(), versionToRevoke);
                        ((RMAppImpl)app).resetCryptoRotationMetrics();
                    }
                    this.intervalForSleep.sleep(X509SecurityHandler.this.revocationMonitorInterval);
                }
                catch (InterruptedException ex) {
                    LOG.info((Object)"Certificate revocation monitor stopping");
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    public static class X509MaterialParameter
    extends RMAppSecurityManager.SecurityManagerMaterial {
        private final String appUser;
        private final Integer cryptoMaterialVersion;
        private final boolean isFromRenewal;
        private Long expiration;

        public X509MaterialParameter(ApplicationId applicationId, String appUser, Integer cryptoMaterialVersion) {
            this(applicationId, appUser, cryptoMaterialVersion, false);
        }

        public X509MaterialParameter(ApplicationId applicationId, String appUser, Integer cryptoMaterialVersion, boolean isFromRenewal) {
            super(applicationId);
            this.appUser = appUser;
            this.cryptoMaterialVersion = cryptoMaterialVersion;
            this.isFromRenewal = isFromRenewal;
        }

        public String getAppUser() {
            return this.appUser;
        }

        public Integer getCryptoMaterialVersion() {
            return this.cryptoMaterialVersion;
        }

        public boolean isFromRenewal() {
            return this.isFromRenewal;
        }

        public Long getExpiration() {
            return this.expiration;
        }

        public void setExpiration(Long expiration) {
            this.expiration = expiration;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof X509MaterialParameter) {
                X509MaterialParameter x509Param = (X509MaterialParameter)other;
                return this.getApplicationId().equals((Object)x509Param.getApplicationId()) && this.appUser.equals(x509Param.appUser) && this.cryptoMaterialVersion.equals(x509Param.cryptoMaterialVersion) && this.isFromRenewal == x509Param.isFromRenewal;
            }
            return false;
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + this.getApplicationId().hashCode();
            result = 31 * result + this.appUser.hashCode();
            result = 31 * result + this.cryptoMaterialVersion.hashCode();
            result = 31 * result + (this.isFromRenewal ? 1 : 0);
            return result;
        }
    }

    public static class X509SecurityManagerMaterial
    extends RMAppSecurityManager.SecurityManagerMaterial {
        private final byte[] keyStore;
        private final char[] keyStorePassword;
        private final byte[] trustStore;
        private final char[] trustStorePassword;
        private final Long expirationEpoch;
        private Integer cryptoMaterialVersion;

        public X509SecurityManagerMaterial(ApplicationId applicationId, byte[] keyStore, char[] keyStorePassword, byte[] trustStore, char[] trustStorePassword, Long expirationEpoch) {
            super(applicationId);
            this.keyStore = keyStore;
            this.keyStorePassword = keyStorePassword;
            this.trustStore = trustStore;
            this.trustStorePassword = trustStorePassword;
            this.expirationEpoch = expirationEpoch;
        }

        public byte[] getKeyStore() {
            return this.keyStore;
        }

        public char[] getKeyStorePassword() {
            return this.keyStorePassword;
        }

        public byte[] getTrustStore() {
            return this.trustStore;
        }

        public char[] getTrustStorePassword() {
            return this.trustStorePassword;
        }

        public Long getExpirationEpoch() {
            return this.expirationEpoch;
        }

        public Integer getCryptoMaterialVersion() {
            return this.cryptoMaterialVersion;
        }

        public void setCryptoMaterialVersion(Integer cryptoMaterialVersion) {
            this.cryptoMaterialVersion = cryptoMaterialVersion;
        }
    }

    protected static enum TYPE {
        KEYSTORE,
        TRUSTSTORE;

    }
}

