/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.glassfish.grizzly.nio.transport;

import io.hops.hadoop.shaded.org.glassfish.grizzly.Buffer;
import io.hops.hadoop.shaded.org.glassfish.grizzly.CompletionHandler;
import io.hops.hadoop.shaded.org.glassfish.grizzly.Connection;
import io.hops.hadoop.shaded.org.glassfish.grizzly.Interceptor;
import io.hops.hadoop.shaded.org.glassfish.grizzly.ReadResult;
import io.hops.hadoop.shaded.org.glassfish.grizzly.Reader;
import io.hops.hadoop.shaded.org.glassfish.grizzly.Transport;
import io.hops.hadoop.shaded.org.glassfish.grizzly.streams.AbstractStreamReader;
import io.hops.hadoop.shaded.org.glassfish.grizzly.streams.BufferedInput;
import java.io.IOException;

public final class DefaultStreamReader
extends AbstractStreamReader {
    public DefaultStreamReader(Connection connection) {
        super(connection, new Input());
        ((Input)this.input).parentStreamReader = this;
    }

    public Input getSource() {
        return (Input)this.input;
    }

    public static final class Input
    extends BufferedInput {
        private DefaultStreamReader parentStreamReader;
        private InputInterceptor interceptor;

        @Override
        protected void onOpenInputSource() throws IOException {
            Connection connection = this.parentStreamReader.getConnection();
            Transport transport = connection.getTransport();
            Reader reader = transport.getReader(connection);
            this.interceptor = new InputInterceptor();
            reader.read(connection, null, null, this.interceptor);
        }

        @Override
        protected void onCloseInputSource() throws IOException {
            this.interceptor.isDone = true;
            this.interceptor = null;
        }

        @Override
        protected void notifyCompleted(CompletionHandler<Integer> completionHandler) {
            if (completionHandler != null) {
                completionHandler.completed(this.compositeBuffer.remaining());
            }
        }

        @Override
        protected void notifyFailure(CompletionHandler<Integer> completionHandler, Throwable failure) {
            if (completionHandler != null) {
                completionHandler.failed(failure);
            }
        }

        private class InputInterceptor
        implements Interceptor<ReadResult<Buffer, ?>> {
            boolean isDone = false;

            private InputInterceptor() {
            }

            @Override
            public int intercept(int event, Object context, ReadResult<Buffer, ?> result) {
                if (event == 1) {
                    Buffer buffer = result.getMessage();
                    result.setMessage(null);
                    if (buffer == null) {
                        return 2;
                    }
                    buffer.trim();
                    Input.this.append(buffer);
                    if (this.isDone) {
                        return 1;
                    }
                    return 6;
                }
                return 0;
            }
        }
    }
}

