/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocolPB;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Shorts;
import io.hops.hadoop.shaded.com.google.protobuf.ByteString;
import io.hops.hadoop.shaded.com.google.protobuf.CodedInputStream;
import io.hops.leader_election.node.ActiveNode;
import io.hops.leader_election.node.ActiveNodePBImpl;
import io.hops.leader_election.node.SortedActiveNodeList;
import io.hops.leader_election.node.SortedActiveNodeListPBImpl;
import io.hops.leader_election.proto.ActiveNodeProtos;
import io.hops.metadata.hdfs.entity.EncodingPolicy;
import io.hops.metadata.hdfs.entity.EncodingStatus;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.crypto.CipherOption;
import org.apache.hadoop.crypto.CipherSuite;
import org.apache.hadoop.crypto.CryptoProtocolVersion;
import org.apache.hadoop.fs.CacheFlag;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveEntry;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveStats;
import org.apache.hadoop.hdfs.protocol.CachePoolEntry;
import org.apache.hadoop.hdfs.protocol.CachePoolInfo;
import org.apache.hadoop.hdfs.protocol.CachePoolStats;
import org.apache.hadoop.hdfs.protocol.CorruptFileBlocks;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DatanodeLocalInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.EncryptionZone;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.FsPermissionExtension;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.HdfsLocatedFileStatus;
import org.apache.hadoop.hdfs.protocol.LastUpdatedContentSummary;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeInfo;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeStatus;
import org.apache.hadoop.hdfs.protocol.proto.AclProtos;
import org.apache.hadoop.hdfs.protocol.proto.ClientNamenodeProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.DataTransferProtos;
import org.apache.hadoop.hdfs.protocol.proto.DatanodeProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.EncryptionZonesProtos;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocol.proto.XAttrProtos;
import org.apache.hadoop.hdfs.security.token.block.BlockKey;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.block.DataEncryptionKey;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.protocol.BalancerBandwidthCommand;
import org.apache.hadoop.hdfs.server.protocol.BlockCommand;
import org.apache.hadoop.hdfs.server.protocol.BlockIdCommand;
import org.apache.hadoop.hdfs.server.protocol.BlockRecoveryCommand;
import org.apache.hadoop.hdfs.server.protocol.BlockReport;
import org.apache.hadoop.hdfs.server.protocol.BlockReportContext;
import org.apache.hadoop.hdfs.server.protocol.BlocksWithLocations;
import org.apache.hadoop.hdfs.server.protocol.Bucket;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorageReport;
import org.apache.hadoop.hdfs.server.protocol.FinalizeCommand;
import org.apache.hadoop.hdfs.server.protocol.HashesMismatchCommand;
import org.apache.hadoop.hdfs.server.protocol.KeyUpdateCommand;
import org.apache.hadoop.hdfs.server.protocol.NamenodeCommand;
import org.apache.hadoop.hdfs.server.protocol.NamenodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.ReceivedDeletedBlockInfo;
import org.apache.hadoop.hdfs.server.protocol.RegisterCommand;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.hdfs.server.protocol.VolumeFailureSummary;
import org.apache.hadoop.hdfs.shortcircuit.ShortCircuitShm;
import org.apache.hadoop.hdfs.util.ExactSizeInputStream;
import org.apache.hadoop.io.EnumSetWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.proto.SecurityProtos;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.DataChecksum;

public class PBHelper {
    private static final DatanodeProtocolProtos.RegisterCommandProto REG_CMD_PROTO = DatanodeProtocolProtos.RegisterCommandProto.newBuilder().build();
    private static final RegisterCommand REG_CMD = new RegisterCommand();
    private static final AclEntryScope[] ACL_ENTRY_SCOPE_VALUES = AclEntryScope.values();
    private static final AclEntryType[] ACL_ENTRY_TYPE_VALUES = AclEntryType.values();
    private static final FsAction[] FSACTION_VALUES = FsAction.values();
    private static final XAttr.NameSpace[] XATTR_NAMESPACE_VALUES = XAttr.NameSpace.values();

    private PBHelper() {
    }

    static <T extends Enum<T>, U extends Enum<U>> U castEnum(T from, U[] to) {
        return to[from.ordinal()];
    }

    public static ByteString getByteString(byte[] bytes) {
        return ByteString.copyFrom((byte[])bytes);
    }

    public static HdfsServerConstants.NamenodeRole convert(HdfsProtos.NamenodeRegistrationProto.NamenodeRoleProto role) {
        switch (role) {
            case NAMENODE: {
                return HdfsServerConstants.NamenodeRole.NAMENODE;
            }
            case BACKUP: {
                return HdfsServerConstants.NamenodeRole.BACKUP;
            }
            case CHECKPOINT: {
                return HdfsServerConstants.NamenodeRole.CHECKPOINT;
            }
        }
        return null;
    }

    public static HdfsProtos.NamenodeRegistrationProto.NamenodeRoleProto convert(HdfsServerConstants.NamenodeRole role) {
        switch (role) {
            case NAMENODE: {
                return HdfsProtos.NamenodeRegistrationProto.NamenodeRoleProto.NAMENODE;
            }
            case BACKUP: {
                return HdfsProtos.NamenodeRegistrationProto.NamenodeRoleProto.BACKUP;
            }
            case CHECKPOINT: {
                return HdfsProtos.NamenodeRegistrationProto.NamenodeRoleProto.CHECKPOINT;
            }
        }
        return null;
    }

    public static HdfsProtos.StorageInfoProto convert(StorageInfo info) {
        return HdfsProtos.StorageInfoProto.newBuilder().setClusterID(info.getClusterID()).setCTime(info.getCTime()).setLayoutVersion(info.getLayoutVersion()).setNamespaceID(info.getNamespaceID()).setBlockpoolID(info.getBlockPoolId()).setDEFAULTROWID(info.getDefaultRowId()).build();
    }

    public static StorageInfo convert(HdfsProtos.StorageInfoProto info, HdfsServerConstants.NodeType type) {
        return new StorageInfo(info.getLayoutVersion(), info.getNamespaceID(), info.getClusterID(), info.getCTime(), type, info.getBlockpoolID());
    }

    public static HdfsProtos.NamenodeRegistrationProto convert(NamenodeRegistration reg) {
        return HdfsProtos.NamenodeRegistrationProto.newBuilder().setHttpAddress(reg.getHttpAddress()).setRole(PBHelper.convert(reg.getRole())).setRpcAddress(reg.getAddress()).setStorageInfo(PBHelper.convert((StorageInfo)reg)).build();
    }

    public static NamenodeRegistration convert(HdfsProtos.NamenodeRegistrationProto reg) {
        StorageInfo si = PBHelper.convert(reg.getStorageInfo(), HdfsServerConstants.NodeType.NAME_NODE);
        return new NamenodeRegistration(reg.getRpcAddress(), reg.getHttpAddress(), si, PBHelper.convert(reg.getRole()));
    }

    public static DatanodeID convert(HdfsProtos.DatanodeIDProto dn) {
        return new DatanodeID(dn.getIpAddr(), dn.getHostName(), dn.getDatanodeUuid(), dn.getXferPort(), dn.getInfoPort(), dn.hasInfoSecurePort() ? dn.getInfoSecurePort() : 0, dn.getIpcPort());
    }

    public static HdfsProtos.DatanodeIDProto convert(DatanodeID dn) {
        return HdfsProtos.DatanodeIDProto.newBuilder().setIpAddr(dn.getIpAddr()).setHostName(dn.getHostName()).setDatanodeUuid(dn.getDatanodeUuid() != null ? dn.getDatanodeUuid() : "").setXferPort(dn.getXferPort()).setInfoPort(dn.getInfoPort()).setInfoSecurePort(dn.getInfoSecurePort()).setIpcPort(dn.getIpcPort()).build();
    }

    public static HdfsProtos.DatanodeIDProto[] convert(DatanodeID[] did) {
        if (did == null) {
            return null;
        }
        int len = did.length;
        HdfsProtos.DatanodeIDProto[] result = new HdfsProtos.DatanodeIDProto[len];
        for (int i = 0; i < len; ++i) {
            result[i] = PBHelper.convert(did[i]);
        }
        return result;
    }

    public static DatanodeID[] convert(HdfsProtos.DatanodeIDProto[] did) {
        if (did == null) {
            return null;
        }
        int len = did.length;
        DatanodeID[] result = new DatanodeID[len];
        for (int i = 0; i < len; ++i) {
            result[i] = PBHelper.convert(did[i]);
        }
        return result;
    }

    public static HdfsProtos.BlockProto convert(Block b) {
        return HdfsProtos.BlockProto.newBuilder().setBlockId(b.getBlockId()).setGenStamp(b.getGenerationStamp()).setNumBytes(b.getNumBytes()).build();
    }

    public static Block convert(HdfsProtos.BlockProto b) {
        return new Block(b.getBlockId(), b.getNumBytes(), b.getGenStamp());
    }

    public static HdfsProtos.BlockWithLocationsProto convert(BlocksWithLocations.BlockWithLocations blk) {
        return HdfsProtos.BlockWithLocationsProto.newBuilder().setBlock(PBHelper.convert(blk.getBlock())).addAllDatanodeUuids(Arrays.asList(blk.getDatanodeUuids())).addAllStorageUuids(Arrays.asList(blk.getStorageIDs())).addAllStorageTypes(PBHelper.convertStorageTypes(blk.getStorageTypes())).build();
    }

    public static BlocksWithLocations.BlockWithLocations convert(HdfsProtos.BlockWithLocationsProto b) {
        List<String> datanodeUuids = b.getDatanodeUuidsList();
        List<String> storageUuids = b.getStorageUuidsList();
        List<HdfsProtos.StorageTypeProto> storageTypes = b.getStorageTypesList();
        return new BlocksWithLocations.BlockWithLocations(PBHelper.convert(b.getBlock()), datanodeUuids.toArray(new String[datanodeUuids.size()]), storageUuids.toArray(new String[storageUuids.size()]), PBHelper.convertStorageTypes(storageTypes, storageUuids.size()));
    }

    public static HdfsProtos.BlocksWithLocationsProto convert(BlocksWithLocations blks) {
        HdfsProtos.BlocksWithLocationsProto.Builder builder = HdfsProtos.BlocksWithLocationsProto.newBuilder();
        for (BlocksWithLocations.BlockWithLocations b : blks.getBlocks()) {
            builder.addBlocks(PBHelper.convert(b));
        }
        return builder.build();
    }

    public static BlocksWithLocations convert(HdfsProtos.BlocksWithLocationsProto blocks) {
        List<HdfsProtos.BlockWithLocationsProto> b = blocks.getBlocksList();
        BlocksWithLocations.BlockWithLocations[] ret = new BlocksWithLocations.BlockWithLocations[b.size()];
        int i = 0;
        for (HdfsProtos.BlockWithLocationsProto entry : b) {
            ret[i++] = PBHelper.convert(entry);
        }
        return new BlocksWithLocations(ret);
    }

    public static HdfsProtos.BlockKeyProto convert(BlockKey key) {
        byte[] encodedKey = key.getEncodedKey();
        ByteString keyBytes = ByteString.copyFrom((byte[])(encodedKey == null ? new byte[]{} : encodedKey));
        return HdfsProtos.BlockKeyProto.newBuilder().setKeyId(key.getKeyId()).setKeyBytes(keyBytes).setExpiryDate(key.getExpiryDate()).build();
    }

    public static BlockKey convert(HdfsProtos.BlockKeyProto k) {
        return new BlockKey(k.getKeyId(), k.getExpiryDate(), k.getKeyBytes().toByteArray());
    }

    public static HdfsProtos.ExportedBlockKeysProto convert(ExportedBlockKeys keys) {
        HdfsProtos.ExportedBlockKeysProto.Builder builder = HdfsProtos.ExportedBlockKeysProto.newBuilder();
        builder.setIsBlockTokenEnabled(keys.isBlockTokenEnabled()).setKeyUpdateInterval(keys.getKeyUpdateInterval()).setTokenLifeTime(keys.getTokenLifetime()).setCurrentKey(PBHelper.convert(keys.getCurrentKey()));
        for (BlockKey k : keys.getAllKeys()) {
            builder.addAllKeys(PBHelper.convert(k));
        }
        return builder.build();
    }

    public static ExportedBlockKeys convert(HdfsProtos.ExportedBlockKeysProto keys) {
        return new ExportedBlockKeys(keys.getIsBlockTokenEnabled(), keys.getKeyUpdateInterval(), keys.getTokenLifeTime(), PBHelper.convert(keys.getCurrentKey()), PBHelper.convertBlockKeys(keys.getAllKeysList()));
    }

    public static HdfsProtos.NamenodeCommandProto convert(NamenodeCommand cmd) {
        return HdfsProtos.NamenodeCommandProto.newBuilder().setType(HdfsProtos.NamenodeCommandProto.Type.NamenodeCommand).setAction(cmd.getAction()).build();
    }

    public static BlockKey[] convertBlockKeys(List<HdfsProtos.BlockKeyProto> list) {
        BlockKey[] ret = new BlockKey[list.size()];
        int i = 0;
        for (HdfsProtos.BlockKeyProto k : list) {
            ret[i++] = PBHelper.convert(k);
        }
        return ret;
    }

    public static NamespaceInfo convert(HdfsProtos.NamespaceInfoProto info) {
        HdfsProtos.StorageInfoProto storage = info.getStorageInfo();
        return new NamespaceInfo(storage.getNamespaceID(), storage.getClusterID(), info.getBlockPoolID(), storage.getCTime(), info.getBuildVersion(), info.getSoftwareVersion(), info.getCapabilities());
    }

    public static NamenodeCommand convert(HdfsProtos.NamenodeCommandProto cmd) {
        if (cmd == null) {
            return null;
        }
        return new NamenodeCommand(cmd.getAction());
    }

    public static ExtendedBlock convert(HdfsProtos.ExtendedBlockProto eb) {
        if (eb == null) {
            return null;
        }
        return new ExtendedBlock(eb.getPoolId(), eb.getBlockId(), eb.getNumBytes(), eb.getGenerationStamp());
    }

    public static HdfsProtos.ExtendedBlockProto convert(ExtendedBlock b) {
        if (b == null) {
            return null;
        }
        return HdfsProtos.ExtendedBlockProto.newBuilder().setPoolId(b.getBlockPoolId()).setBlockId(b.getBlockId()).setNumBytes(b.getNumBytes()).setGenerationStamp(b.getGenerationStamp()).build();
    }

    public static HdfsProtos.RecoveringBlockProto convert(BlockRecoveryCommand.RecoveringBlock b) {
        if (b == null) {
            return null;
        }
        HdfsProtos.LocatedBlockProto lb = PBHelper.convert((LocatedBlock)b);
        HdfsProtos.RecoveringBlockProto.Builder builder = HdfsProtos.RecoveringBlockProto.newBuilder();
        builder.setBlock(lb).setNewGenStamp(b.getNewGenerationStamp());
        if (b.getNewBlock() != null) {
            builder.setTruncateBlock(PBHelper.convert(b.getNewBlock()));
        }
        return builder.build();
    }

    public static BlockRecoveryCommand.RecoveringBlock convert(HdfsProtos.RecoveringBlockProto b) {
        ExtendedBlock block = PBHelper.convert(b.getBlock().getB());
        DatanodeInfo[] locs = PBHelper.convert(b.getBlock().getLocsList());
        return b.hasTruncateBlock() ? new BlockRecoveryCommand.RecoveringBlock(block, locs, PBHelper.convert(b.getTruncateBlock())) : new BlockRecoveryCommand.RecoveringBlock(block, locs, b.getNewGenStamp());
    }

    public static HdfsProtos.DatanodeInfoProto.AdminState convert(DatanodeInfo.AdminStates inAs) {
        switch (inAs) {
            case NORMAL: {
                return HdfsProtos.DatanodeInfoProto.AdminState.NORMAL;
            }
            case DECOMMISSION_INPROGRESS: {
                return HdfsProtos.DatanodeInfoProto.AdminState.DECOMMISSION_INPROGRESS;
            }
            case DECOMMISSIONED: {
                return HdfsProtos.DatanodeInfoProto.AdminState.DECOMMISSIONED;
            }
        }
        return HdfsProtos.DatanodeInfoProto.AdminState.NORMAL;
    }

    public static DatanodeInfo convert(HdfsProtos.DatanodeInfoProto di) {
        if (di == null) {
            return null;
        }
        return new DatanodeInfo(PBHelper.convert(di.getId()), di.hasLocation() ? di.getLocation() : null, di.getCapacity(), di.getDfsUsed(), di.getRemaining(), di.getBlockPoolUsed(), di.getCacheCapacity(), di.getCacheUsed(), di.getLastUpdate(), di.getLastUpdateMonotonic(), di.getXceiverCount(), PBHelper.convert(di.getAdminState()));
    }

    public static HdfsProtos.DatanodeInfoProto convertDatanodeInfo(DatanodeInfo di) {
        if (di == null) {
            return null;
        }
        return PBHelper.convert(di);
    }

    public static DatanodeInfo[] convert(HdfsProtos.DatanodeInfoProto[] di) {
        if (di == null) {
            return null;
        }
        DatanodeInfo[] result = new DatanodeInfo[di.length];
        for (int i = 0; i < di.length; ++i) {
            result[i] = PBHelper.convert(di[i]);
        }
        return result;
    }

    public static List<? extends HdfsProtos.DatanodeInfoProto> convert(DatanodeInfo[] dnInfos) {
        return PBHelper.convert(dnInfos, 0);
    }

    public static List<? extends HdfsProtos.DatanodeInfoProto> convert(DatanodeInfo[] dnInfos, int startIdx) {
        if (dnInfos == null) {
            return null;
        }
        ArrayList protos = Lists.newArrayListWithCapacity((int)dnInfos.length);
        for (int i = startIdx; i < dnInfos.length; ++i) {
            protos.add(PBHelper.convert(dnInfos[i]));
        }
        return protos;
    }

    public static DatanodeInfo[] convert(List<HdfsProtos.DatanodeInfoProto> list) {
        DatanodeInfo[] info = new DatanodeInfo[list.size()];
        for (int i = 0; i < info.length; ++i) {
            info[i] = PBHelper.convert(list.get(i));
        }
        return info;
    }

    public static HdfsProtos.DatanodeInfoProto convert(DatanodeInfo info) {
        HdfsProtos.DatanodeInfoProto.Builder builder = HdfsProtos.DatanodeInfoProto.newBuilder();
        if (info.getNetworkLocation() != null) {
            builder.setLocation(info.getNetworkLocation());
        }
        builder.setId(PBHelper.convert((DatanodeID)info)).setCapacity(info.getCapacity()).setDfsUsed(info.getDfsUsed()).setRemaining(info.getRemaining()).setBlockPoolUsed(info.getBlockPoolUsed()).setCacheCapacity(info.getCacheCapacity()).setCacheUsed(info.getCacheUsed()).setLastUpdate(info.getLastUpdate()).setLastUpdateMonotonic(info.getLastUpdateMonotonic()).setXceiverCount(info.getXceiverCount()).setAdminState(PBHelper.convert(info.getAdminState())).build();
        return builder.build();
    }

    public static ClientNamenodeProtocolProtos.DatanodeStorageReportProto convertDatanodeStorageReport(DatanodeStorageReport report) {
        return ClientNamenodeProtocolProtos.DatanodeStorageReportProto.newBuilder().setDatanodeInfo(PBHelper.convert(report.getDatanodeInfo())).addAllStorageReports(PBHelper.convertStorageReports(report.getStorageReports())).build();
    }

    public static List<ClientNamenodeProtocolProtos.DatanodeStorageReportProto> convertDatanodeStorageReports(DatanodeStorageReport[] reports) {
        ArrayList<ClientNamenodeProtocolProtos.DatanodeStorageReportProto> protos = new ArrayList<ClientNamenodeProtocolProtos.DatanodeStorageReportProto>(reports.length);
        for (int i = 0; i < reports.length; ++i) {
            protos.add(PBHelper.convertDatanodeStorageReport(reports[i]));
        }
        return protos;
    }

    public static DatanodeStorageReport convertDatanodeStorageReport(ClientNamenodeProtocolProtos.DatanodeStorageReportProto proto) {
        return new DatanodeStorageReport(PBHelper.convert(proto.getDatanodeInfo()), PBHelper.convertStorageReports(proto.getStorageReportsList()));
    }

    public static DatanodeStorageReport[] convertDatanodeStorageReports(List<ClientNamenodeProtocolProtos.DatanodeStorageReportProto> protos) {
        DatanodeStorageReport[] reports = new DatanodeStorageReport[protos.size()];
        for (int i = 0; i < reports.length; ++i) {
            reports[i] = PBHelper.convertDatanodeStorageReport(protos.get(i));
        }
        return reports;
    }

    public static DatanodeInfo.AdminStates convert(HdfsProtos.DatanodeInfoProto.AdminState adminState) {
        switch (adminState) {
            case DECOMMISSION_INPROGRESS: {
                return DatanodeInfo.AdminStates.DECOMMISSION_INPROGRESS;
            }
            case DECOMMISSIONED: {
                return DatanodeInfo.AdminStates.DECOMMISSIONED;
            }
        }
        return DatanodeInfo.AdminStates.NORMAL;
    }

    public static HdfsProtos.LocatedBlockProto convert(LocatedBlock b) {
        String[] storageIDs;
        if (b == null) {
            return null;
        }
        HdfsProtos.LocatedBlockProto.Builder builder = HdfsProtos.LocatedBlockProto.newBuilder();
        DatanodeInfo[] locs = b.getLocations();
        LinkedList cachedLocs = Lists.newLinkedList(Arrays.asList(b.getCachedLocations()));
        for (int i = 0; i < locs.length; ++i) {
            DatanodeInfo loc = locs[i];
            builder.addLocs(i, PBHelper.convert(loc));
            boolean locIsCached = cachedLocs.contains(loc);
            builder.addIsCached(locIsCached);
            if (!locIsCached) continue;
            cachedLocs.remove(loc);
        }
        Preconditions.checkArgument((cachedLocs.size() == 0 ? 1 : 0) != 0, (Object)"Found additional cached replica locations that are not in the set of storage-backed locations!");
        StorageType[] storageTypes = b.getStorageTypes();
        if (storageTypes != null) {
            for (int i = 0; i < storageTypes.length; ++i) {
                builder.addStorageTypes(PBHelper.convertStorageType(storageTypes[i]));
            }
        }
        if ((storageIDs = b.getStorageIDs()) != null) {
            builder = builder.addAllStorageIDs(Arrays.asList(storageIDs));
        }
        builder = builder.setB(PBHelper.convert(b.getBlock())).setBlockToken(PBHelper.convert(b.getBlockToken())).setCorrupt(b.isCorrupt()).setOffset(b.getStartOffset());
        if (b.isPhantomBlock() && b.isDataSet()) {
            builder.setData(ByteString.copyFrom((byte[])b.getData()));
        }
        return builder.build();
    }

    public static LocatedBlock convert(HdfsProtos.LocatedBlockProto proto) {
        String[] storageIDs;
        if (proto == null) {
            return null;
        }
        List<HdfsProtos.DatanodeInfoProto> locs = proto.getLocsList();
        DatanodeInfo[] targets = new DatanodeInfo[locs.size()];
        for (int i = 0; i < locs.size(); ++i) {
            targets[i] = PBHelper.convert(locs.get(i));
        }
        StorageType[] storageTypes = PBHelper.convertStorageTypes(proto.getStorageTypesList(), locs.size());
        int storageIDsCount = proto.getStorageIDsCount();
        if (storageIDsCount == 0) {
            storageIDs = null;
        } else {
            assert (storageIDsCount == locs.size());
            storageIDs = proto.getStorageIDsList().toArray(new String[storageIDsCount]);
        }
        ArrayList<DatanodeInfo> cachedLocs = new ArrayList<DatanodeInfo>(locs.size());
        List<Boolean> isCachedList = proto.getIsCachedList();
        for (int i = 0; i < isCachedList.size(); ++i) {
            if (!isCachedList.get(i).booleanValue()) continue;
            cachedLocs.add(targets[i]);
        }
        LocatedBlock lb = new LocatedBlock(PBHelper.convert(proto.getB()), targets, storageIDs, storageTypes, proto.getOffset(), proto.getCorrupt(), cachedLocs.toArray(new DatanodeInfo[0]));
        lb.setBlockToken(PBHelper.convert(proto.getBlockToken()));
        if (proto.getData().size() > 0) {
            lb.setData(proto.getData().toByteArray());
        }
        return lb;
    }

    public static SecurityProtos.TokenProto convert(Token<?> tok) {
        return SecurityProtos.TokenProto.newBuilder().setIdentifier(ByteString.copyFrom((byte[])tok.getIdentifier())).setPassword(ByteString.copyFrom((byte[])tok.getPassword())).setKind(tok.getKind().toString()).setService(tok.getService().toString()).build();
    }

    public static Token<BlockTokenIdentifier> convert(SecurityProtos.TokenProto blockToken) {
        return new Token(blockToken.getIdentifier().toByteArray(), blockToken.getPassword().toByteArray(), new Text(blockToken.getKind()), new Text(blockToken.getService()));
    }

    public static Token<DelegationTokenIdentifier> convertDelegationToken(SecurityProtos.TokenProto blockToken) {
        return new Token(blockToken.getIdentifier().toByteArray(), blockToken.getPassword().toByteArray(), new Text(blockToken.getKind()), new Text(blockToken.getService()));
    }

    public static HdfsServerConstants.ReplicaState convert(HdfsProtos.ReplicaStateProto state) {
        switch (state) {
            case RBW: {
                return HdfsServerConstants.ReplicaState.RBW;
            }
            case RUR: {
                return HdfsServerConstants.ReplicaState.RUR;
            }
            case RWR: {
                return HdfsServerConstants.ReplicaState.RWR;
            }
            case TEMPORARY: {
                return HdfsServerConstants.ReplicaState.TEMPORARY;
            }
        }
        return HdfsServerConstants.ReplicaState.FINALIZED;
    }

    public static HdfsProtos.ReplicaStateProto convert(HdfsServerConstants.ReplicaState state) {
        switch (state) {
            case RBW: {
                return HdfsProtos.ReplicaStateProto.RBW;
            }
            case RUR: {
                return HdfsProtos.ReplicaStateProto.RUR;
            }
            case RWR: {
                return HdfsProtos.ReplicaStateProto.RWR;
            }
            case TEMPORARY: {
                return HdfsProtos.ReplicaStateProto.TEMPORARY;
            }
        }
        return HdfsProtos.ReplicaStateProto.FINALIZED;
    }

    public static DatanodeProtocolProtos.DatanodeRegistrationProto convert(DatanodeRegistration registration) {
        DatanodeProtocolProtos.DatanodeRegistrationProto.Builder builder = DatanodeProtocolProtos.DatanodeRegistrationProto.newBuilder();
        return builder.setDatanodeID(PBHelper.convert((DatanodeID)registration)).setStorageInfo(PBHelper.convert(registration.getStorageInfo())).setKeys(PBHelper.convert(registration.getExportedKeys())).setSoftwareVersion(registration.getSoftwareVersion()).build();
    }

    public static DatanodeRegistration convert(DatanodeProtocolProtos.DatanodeRegistrationProto proto) {
        StorageInfo si = PBHelper.convert(proto.getStorageInfo(), HdfsServerConstants.NodeType.DATA_NODE);
        return new DatanodeRegistration(PBHelper.convert(proto.getDatanodeID()), si, PBHelper.convert(proto.getKeys()), proto.getSoftwareVersion());
    }

    public static DatanodeCommand convert(DatanodeProtocolProtos.DatanodeCommandProto proto) {
        switch (proto.getCmdType()) {
            case BalancerBandwidthCommand: {
                return PBHelper.convert(proto.getBalancerCmd());
            }
            case BlockCommand: {
                return PBHelper.convert(proto.getBlkCmd());
            }
            case BlockRecoveryCommand: {
                return PBHelper.convert(proto.getRecoveryCmd());
            }
            case FinalizeCommand: {
                return PBHelper.convert(proto.getFinalizeCmd());
            }
            case KeyUpdateCommand: {
                return PBHelper.convert(proto.getKeyUpdateCmd());
            }
            case RegisterCommand: {
                return REG_CMD;
            }
            case BlockIdCommand: {
                return PBHelper.convert(proto.getBlkIdCmd());
            }
            case HashMismatchCommand: {
                return PBHelper.convert(proto.getMismatchHashesCmd());
            }
        }
        return null;
    }

    public static DatanodeProtocolProtos.BalancerBandwidthCommandProto convert(BalancerBandwidthCommand bbCmd) {
        return DatanodeProtocolProtos.BalancerBandwidthCommandProto.newBuilder().setBandwidth(bbCmd.getBalancerBandwidthValue()).build();
    }

    public static DatanodeProtocolProtos.KeyUpdateCommandProto convert(KeyUpdateCommand cmd) {
        return DatanodeProtocolProtos.KeyUpdateCommandProto.newBuilder().setKeys(PBHelper.convert(cmd.getExportedKeys())).build();
    }

    public static DatanodeProtocolProtos.BlockRecoveryCommandProto convert(BlockRecoveryCommand cmd) {
        DatanodeProtocolProtos.BlockRecoveryCommandProto.Builder builder = DatanodeProtocolProtos.BlockRecoveryCommandProto.newBuilder();
        for (BlockRecoveryCommand.RecoveringBlock b : cmd.getRecoveringBlocks()) {
            builder.addBlocks(PBHelper.convert(b));
        }
        return builder.build();
    }

    public static DatanodeProtocolProtos.FinalizeCommandProto convert(FinalizeCommand cmd) {
        return DatanodeProtocolProtos.FinalizeCommandProto.newBuilder().setBlockPoolId(cmd.getBlockPoolId()).build();
    }

    public static DatanodeProtocolProtos.BlockCommandProto convert(BlockCommand cmd) {
        Block[] blocks;
        DatanodeProtocolProtos.BlockCommandProto.Builder builder = DatanodeProtocolProtos.BlockCommandProto.newBuilder().setBlockPoolId(cmd.getBlockPoolId());
        switch (cmd.getAction()) {
            case 1: {
                builder.setAction(DatanodeProtocolProtos.BlockCommandProto.Action.TRANSFER);
                break;
            }
            case 2: {
                builder.setAction(DatanodeProtocolProtos.BlockCommandProto.Action.INVALIDATE);
                break;
            }
            case 3: {
                builder.setAction(DatanodeProtocolProtos.BlockCommandProto.Action.SHUTDOWN);
                break;
            }
            default: {
                throw new AssertionError((Object)"Invalid action");
            }
        }
        for (Block block : blocks = cmd.getBlocks()) {
            builder.addBlocks(PBHelper.convert(block));
        }
        builder.addAllTargets(PBHelper.convert(cmd.getTargets())).addAllTargetStorageUuids(PBHelper.convert(cmd.getTargetStorageIDs()));
        StorageType[][] types = cmd.getTargetStorageTypes();
        if (types != null) {
            builder.addAllTargetStorageTypes(PBHelper.convert(types));
        }
        return builder.build();
    }

    private static List<HdfsProtos.StorageTypesProto> convert(StorageType[][] types) {
        ArrayList list = Lists.newArrayList();
        if (types != null) {
            for (StorageType[] ts : types) {
                HdfsProtos.StorageTypesProto.Builder builder = HdfsProtos.StorageTypesProto.newBuilder();
                builder.addAllStorageTypes(PBHelper.convertStorageTypes(ts));
                list.add(builder.build());
            }
        }
        return list;
    }

    public static DatanodeProtocolProtos.HashMismatchCommandProto convert(HashesMismatchCommand cmd) {
        DatanodeProtocolProtos.HashMismatchCommandProto.Builder builder = DatanodeProtocolProtos.HashMismatchCommandProto.newBuilder();
        DatanodeProtocolProtos.AllStorageMismatchingHashes.Builder asmh = DatanodeProtocolProtos.AllStorageMismatchingHashes.newBuilder();
        for (String sid : cmd.getMissMatchingBuckets().keySet()) {
            List<Integer> buckets = cmd.getMissMatchingBuckets().get(sid);
            DatanodeProtocolProtos.StorageMismatchingHashes.Builder smh = DatanodeProtocolProtos.StorageMismatchingHashes.newBuilder();
            smh.addAllBucketIDs(buckets);
            smh.setStorageID(sid);
            asmh.addStorages(smh.build());
        }
        builder.setStorages(asmh.build());
        return builder.build();
    }

    public static DatanodeProtocolProtos.BlockIdCommandProto convert(BlockIdCommand cmd) {
        DatanodeProtocolProtos.BlockIdCommandProto.Builder builder = DatanodeProtocolProtos.BlockIdCommandProto.newBuilder().setBlockPoolId(cmd.getBlockPoolId());
        switch (cmd.getAction()) {
            case 9: {
                builder.setAction(DatanodeProtocolProtos.BlockIdCommandProto.Action.CACHE);
                break;
            }
            case 10: {
                builder.setAction(DatanodeProtocolProtos.BlockIdCommandProto.Action.UNCACHE);
                break;
            }
            default: {
                throw new AssertionError((Object)"Invalid action");
            }
        }
        long[] blockIds = cmd.getBlockIds();
        for (int i = 0; i < blockIds.length; ++i) {
            builder.addBlockIds(blockIds[i]);
        }
        return builder.build();
    }

    private static List<HdfsProtos.DatanodeInfosProto> convert(DatanodeInfo[][] targets) {
        HdfsProtos.DatanodeInfosProto[] ret = new HdfsProtos.DatanodeInfosProto[targets.length];
        for (int i = 0; i < targets.length; ++i) {
            ret[i] = HdfsProtos.DatanodeInfosProto.newBuilder().addAllDatanodes(PBHelper.convert(targets[i])).build();
        }
        return Arrays.asList(ret);
    }

    private static List<HdfsProtos.StorageUuidsProto> convert(String[][] targetStorageUuids) {
        HdfsProtos.StorageUuidsProto[] ret = new HdfsProtos.StorageUuidsProto[targetStorageUuids.length];
        for (int i = 0; i < targetStorageUuids.length; ++i) {
            ret[i] = HdfsProtos.StorageUuidsProto.newBuilder().addAllStorageUuids(Arrays.asList(targetStorageUuids[i])).build();
        }
        return Arrays.asList(ret);
    }

    public static DatanodeProtocolProtos.DatanodeCommandProto convert(DatanodeCommand datanodeCommand) {
        DatanodeProtocolProtos.DatanodeCommandProto.Builder builder = DatanodeProtocolProtos.DatanodeCommandProto.newBuilder();
        if (datanodeCommand == null) {
            return builder.setCmdType(DatanodeProtocolProtos.DatanodeCommandProto.Type.NullDatanodeCommand).build();
        }
        switch (datanodeCommand.getAction()) {
            case 8: {
                builder.setCmdType(DatanodeProtocolProtos.DatanodeCommandProto.Type.BalancerBandwidthCommand).setBalancerCmd(PBHelper.convert((BalancerBandwidthCommand)datanodeCommand));
                break;
            }
            case 7: {
                builder.setCmdType(DatanodeProtocolProtos.DatanodeCommandProto.Type.KeyUpdateCommand).setKeyUpdateCmd(PBHelper.convert((KeyUpdateCommand)datanodeCommand));
                break;
            }
            case 6: {
                builder.setCmdType(DatanodeProtocolProtos.DatanodeCommandProto.Type.BlockRecoveryCommand).setRecoveryCmd(PBHelper.convert((BlockRecoveryCommand)datanodeCommand));
                break;
            }
            case 5: {
                builder.setCmdType(DatanodeProtocolProtos.DatanodeCommandProto.Type.FinalizeCommand).setFinalizeCmd(PBHelper.convert((FinalizeCommand)datanodeCommand));
                break;
            }
            case 4: {
                builder.setCmdType(DatanodeProtocolProtos.DatanodeCommandProto.Type.RegisterCommand).setRegisterCmd(REG_CMD_PROTO);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                builder.setCmdType(DatanodeProtocolProtos.DatanodeCommandProto.Type.BlockCommand).setBlkCmd(PBHelper.convert((BlockCommand)datanodeCommand));
                break;
            }
            case 9: 
            case 10: {
                builder.setCmdType(DatanodeProtocolProtos.DatanodeCommandProto.Type.BlockIdCommand).setBlkIdCmd(PBHelper.convert((BlockIdCommand)datanodeCommand));
                break;
            }
            case 11: {
                builder.setCmdType(DatanodeProtocolProtos.DatanodeCommandProto.Type.HashMismatchCommand).setMismatchHashesCmd(PBHelper.convert((HashesMismatchCommand)datanodeCommand));
                break;
            }
            default: {
                builder.setCmdType(DatanodeProtocolProtos.DatanodeCommandProto.Type.NullDatanodeCommand);
            }
        }
        return builder.build();
    }

    public static KeyUpdateCommand convert(DatanodeProtocolProtos.KeyUpdateCommandProto keyUpdateCmd) {
        return new KeyUpdateCommand(PBHelper.convert(keyUpdateCmd.getKeys()));
    }

    public static FinalizeCommand convert(DatanodeProtocolProtos.FinalizeCommandProto finalizeCmd) {
        return new FinalizeCommand(finalizeCmd.getBlockPoolId());
    }

    public static BlockRecoveryCommand convert(DatanodeProtocolProtos.BlockRecoveryCommandProto recoveryCmd) {
        List<HdfsProtos.RecoveringBlockProto> list = recoveryCmd.getBlocksList();
        ArrayList<BlockRecoveryCommand.RecoveringBlock> recoveringBlocks = new ArrayList<BlockRecoveryCommand.RecoveringBlock>(list.size());
        for (HdfsProtos.RecoveringBlockProto rbp : list) {
            recoveringBlocks.add(PBHelper.convert(rbp));
        }
        return new BlockRecoveryCommand(recoveringBlocks);
    }

    public static BlockCommand convert(DatanodeProtocolProtos.BlockCommandProto blkCmd) {
        int i;
        List<HdfsProtos.BlockProto> blockProtoList = blkCmd.getBlocksList();
        Block[] blocks = new Block[blockProtoList.size()];
        for (int i2 = 0; i2 < blockProtoList.size(); ++i2) {
            blocks[i2] = PBHelper.convert(blockProtoList.get(i2));
        }
        List<HdfsProtos.DatanodeInfosProto> targetList = blkCmd.getTargetsList();
        DatanodeInfo[][] targets = new DatanodeInfo[targetList.size()][];
        for (int i3 = 0; i3 < targetList.size(); ++i3) {
            targets[i3] = PBHelper.convert(targetList.get(i3));
        }
        StorageType[][] targetStorageTypes = new StorageType[targetList.size()][];
        List<HdfsProtos.StorageTypesProto> targetStorageTypesList = blkCmd.getTargetStorageTypesList();
        if (targetStorageTypesList.isEmpty()) {
            for (i = 0; i < targetStorageTypes.length; ++i) {
                targetStorageTypes[i] = new StorageType[targets[i].length];
                Arrays.fill(targetStorageTypes[i], StorageType.DEFAULT);
            }
        } else {
            for (i = 0; i < targetStorageTypes.length; ++i) {
                List<HdfsProtos.StorageTypeProto> p = targetStorageTypesList.get(i).getStorageTypesList();
                targetStorageTypes[i] = PBHelper.convertStorageTypes(p, targets[i].length);
            }
        }
        List<HdfsProtos.StorageUuidsProto> targetStorageUuidsList = blkCmd.getTargetStorageUuidsList();
        String[][] targetStorageIDs = new String[targetStorageUuidsList.size()][];
        for (int i4 = 0; i4 < targetStorageIDs.length; ++i4) {
            List<String> storageIDs = targetStorageUuidsList.get(i4).getStorageUuidsList();
            targetStorageIDs[i4] = storageIDs.toArray(new String[storageIDs.size()]);
        }
        int action = 0;
        switch (blkCmd.getAction()) {
            case TRANSFER: {
                action = 1;
                break;
            }
            case INVALIDATE: {
                action = 2;
                break;
            }
            case SHUTDOWN: {
                action = 3;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown action type: " + (Object)((Object)blkCmd.getAction())));
            }
        }
        return new BlockCommand(action, blkCmd.getBlockPoolId(), blocks, targets, targetStorageTypes, targetStorageIDs);
    }

    public static HashesMismatchCommand convert(DatanodeProtocolProtos.HashMismatchCommandProto cmd) {
        HashesMismatchCommand hmcmd = new HashesMismatchCommand();
        DatanodeProtocolProtos.AllStorageMismatchingHashes asmh = cmd.getStorages();
        for (DatanodeProtocolProtos.StorageMismatchingHashes smh : asmh.getStoragesList()) {
            hmcmd.addStorageBuckets(smh.getStorageID(), smh.getBucketIDsList());
        }
        return hmcmd;
    }

    public static BlockIdCommand convert(DatanodeProtocolProtos.BlockIdCommandProto blkIdCmd) {
        int numBlockIds = blkIdCmd.getBlockIdsCount();
        long[] blockIds = new long[numBlockIds];
        for (int i = 0; i < numBlockIds; ++i) {
            blockIds[i] = blkIdCmd.getBlockIds(i);
        }
        int action = 0;
        switch (blkIdCmd.getAction()) {
            case CACHE: {
                action = 9;
                break;
            }
            case UNCACHE: {
                action = 10;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown action type: " + (Object)((Object)blkIdCmd.getAction())));
            }
        }
        return new BlockIdCommand(action, blkIdCmd.getBlockPoolId(), blockIds);
    }

    public static DatanodeInfo[] convert(HdfsProtos.DatanodeInfosProto datanodeInfosProto) {
        List<HdfsProtos.DatanodeInfoProto> proto = datanodeInfosProto.getDatanodesList();
        DatanodeInfo[] infos = new DatanodeInfo[proto.size()];
        for (int i = 0; i < infos.length; ++i) {
            infos[i] = PBHelper.convert(proto.get(i));
        }
        return infos;
    }

    public static BalancerBandwidthCommand convert(DatanodeProtocolProtos.BalancerBandwidthCommandProto balancerCmd) {
        return new BalancerBandwidthCommand(balancerCmd.getBandwidth());
    }

    public static DatanodeProtocolProtos.ReceivedDeletedBlockInfoProto convert(ReceivedDeletedBlockInfo receivedDeletedBlockInfo) {
        DatanodeProtocolProtos.ReceivedDeletedBlockInfoProto.BlockStatus status;
        DatanodeProtocolProtos.ReceivedDeletedBlockInfoProto.Builder builder = DatanodeProtocolProtos.ReceivedDeletedBlockInfoProto.newBuilder();
        switch (receivedDeletedBlockInfo.getStatus()) {
            case RECEIVING_BLOCK: {
                status = DatanodeProtocolProtos.ReceivedDeletedBlockInfoProto.BlockStatus.CREATING;
                break;
            }
            case APPENDING: {
                status = DatanodeProtocolProtos.ReceivedDeletedBlockInfoProto.BlockStatus.APPENDING;
                break;
            }
            case RECOVERING_APPEND: {
                status = DatanodeProtocolProtos.ReceivedDeletedBlockInfoProto.BlockStatus.RECOVERING_APPEND;
                break;
            }
            case RECEIVED_BLOCK: {
                status = DatanodeProtocolProtos.ReceivedDeletedBlockInfoProto.BlockStatus.RECEIVED;
                break;
            }
            case UPDATE_RECOVERED: {
                status = DatanodeProtocolProtos.ReceivedDeletedBlockInfoProto.BlockStatus.UPDATE_RECOVERED;
                break;
            }
            case DELETED_BLOCK: {
                status = DatanodeProtocolProtos.ReceivedDeletedBlockInfoProto.BlockStatus.DELETED;
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad status: " + (Object)((Object)receivedDeletedBlockInfo.getStatus()));
            }
        }
        builder.setStatus(status);
        if (receivedDeletedBlockInfo.getDelHints() != null) {
            builder.setDeleteHint(receivedDeletedBlockInfo.getDelHints());
        }
        return builder.setBlock(PBHelper.convert(receivedDeletedBlockInfo.getBlock())).build();
    }

    public static ReceivedDeletedBlockInfo convert(DatanodeProtocolProtos.ReceivedDeletedBlockInfoProto proto) {
        ReceivedDeletedBlockInfo.BlockStatus status = null;
        switch (proto.getStatus()) {
            case CREATING: {
                status = ReceivedDeletedBlockInfo.BlockStatus.RECEIVING_BLOCK;
                break;
            }
            case APPENDING: {
                status = ReceivedDeletedBlockInfo.BlockStatus.APPENDING;
                break;
            }
            case RECOVERING_APPEND: {
                status = ReceivedDeletedBlockInfo.BlockStatus.RECOVERING_APPEND;
                break;
            }
            case RECEIVED: {
                status = ReceivedDeletedBlockInfo.BlockStatus.RECEIVED_BLOCK;
                break;
            }
            case UPDATE_RECOVERED: {
                status = ReceivedDeletedBlockInfo.BlockStatus.UPDATE_RECOVERED;
                break;
            }
            case DELETED: {
                status = ReceivedDeletedBlockInfo.BlockStatus.DELETED_BLOCK;
            }
        }
        return new ReceivedDeletedBlockInfo(PBHelper.convert(proto.getBlock()), status, proto.hasDeleteHint() ? proto.getDeleteHint() : null);
    }

    public static HdfsProtos.NamespaceInfoProto convert(NamespaceInfo info) {
        return HdfsProtos.NamespaceInfoProto.newBuilder().setBlockPoolID(info.getBlockPoolID()).setBuildVersion(info.getBuildVersion()).setUnused(0).setStorageInfo(PBHelper.convert((StorageInfo)info)).setSoftwareVersion(info.getSoftwareVersion()).setCapabilities(info.getCapabilities()).build();
    }

    public static HdfsProtos.LocatedBlockProto[] convertLocatedBlock(LocatedBlock[] lb) {
        if (lb == null) {
            return null;
        }
        return PBHelper.convertLocatedBlock2(Arrays.asList(lb)).toArray(new HdfsProtos.LocatedBlockProto[lb.length]);
    }

    public static LocatedBlock[] convertLocatedBlock(HdfsProtos.LocatedBlockProto[] lb) {
        if (lb == null) {
            return null;
        }
        return PBHelper.convertLocatedBlock(Arrays.asList(lb)).toArray(new LocatedBlock[lb.length]);
    }

    public static List<LocatedBlock> convertLocatedBlock(List<HdfsProtos.LocatedBlockProto> lb) {
        if (lb == null) {
            return null;
        }
        int len = lb.size();
        ArrayList<LocatedBlock> result = new ArrayList<LocatedBlock>(len);
        for (HdfsProtos.LocatedBlockProto aLb : lb) {
            result.add(PBHelper.convert(aLb));
        }
        return result;
    }

    public static List<HdfsProtos.LocatedBlockProto> convertLocatedBlock2(List<LocatedBlock> lb) {
        if (lb == null) {
            return null;
        }
        int len = lb.size();
        ArrayList<HdfsProtos.LocatedBlockProto> result = new ArrayList<HdfsProtos.LocatedBlockProto>(len);
        for (LocatedBlock aLb : lb) {
            result.add(PBHelper.convert(aLb));
        }
        return result;
    }

    public static LocatedBlocks convert(HdfsProtos.LocatedBlocksProto lb) {
        return new LocatedBlocks(lb.getFileLength(), lb.getUnderConstruction(), PBHelper.convertLocatedBlock(lb.getBlocksList()), lb.hasLastBlock() ? PBHelper.convert(lb.getLastBlock()) : null, lb.getIsLastBlockComplete(), lb.hasFileEncryptionInfo() ? PBHelper.convert(lb.getFileEncryptionInfo()) : null);
    }

    public static HdfsProtos.LocatedBlocksProto convert(LocatedBlocks lb) {
        if (lb == null) {
            return null;
        }
        HdfsProtos.LocatedBlocksProto.Builder builder = HdfsProtos.LocatedBlocksProto.newBuilder();
        if (lb.getLastLocatedBlock() != null) {
            builder.setLastBlock(PBHelper.convert(lb.getLastLocatedBlock()));
        }
        if (lb.getFileEncryptionInfo() != null) {
            builder.setFileEncryptionInfo(PBHelper.convert(lb.getFileEncryptionInfo()));
        }
        return builder.setFileLength(lb.getFileLength()).setUnderConstruction(lb.isUnderConstruction()).addAllBlocks(PBHelper.convertLocatedBlock2(lb.getLocatedBlocks())).setIsLastBlockComplete(lb.isLastBlockComplete()).build();
    }

    public static DataEncryptionKey convert(HdfsProtos.DataEncryptionKeyProto bet) {
        String encryptionAlgorithm = bet.getEncryptionAlgorithm();
        return new DataEncryptionKey(bet.getKeyId(), bet.getBlockPoolId(), bet.getNonce().toByteArray(), bet.getEncryptionKey().toByteArray(), bet.getExpiryDate(), encryptionAlgorithm.isEmpty() ? null : encryptionAlgorithm);
    }

    public static HdfsProtos.DataEncryptionKeyProto convert(DataEncryptionKey bet) {
        HdfsProtos.DataEncryptionKeyProto.Builder b = HdfsProtos.DataEncryptionKeyProto.newBuilder().setKeyId(bet.keyId).setBlockPoolId(bet.blockPoolId).setNonce(ByteString.copyFrom((byte[])bet.nonce)).setEncryptionKey(ByteString.copyFrom((byte[])bet.encryptionKey)).setExpiryDate(bet.expiryDate);
        if (bet.encryptionAlgorithm != null) {
            b.setEncryptionAlgorithm(bet.encryptionAlgorithm);
        }
        return b.build();
    }

    public static FsServerDefaults convert(HdfsProtos.FsServerDefaultsProto fs) {
        if (fs == null) {
            return null;
        }
        return new FsServerDefaults(fs.getBlockSize(), fs.getBytesPerChecksum(), fs.getWritePacketSize(), (short)fs.getReplication(), fs.getFileBufferSize(), fs.getEncryptDataTransfer(), fs.getTrashInterval(), PBHelper.convert(fs.getChecksumType()), fs.getQuotaEnabled());
    }

    public static HdfsProtos.FsServerDefaultsProto convert(FsServerDefaults fs) {
        if (fs == null) {
            return null;
        }
        return HdfsProtos.FsServerDefaultsProto.newBuilder().setBlockSize(fs.getBlockSize()).setBytesPerChecksum(fs.getBytesPerChecksum()).setWritePacketSize(fs.getWritePacketSize()).setReplication(fs.getReplication()).setFileBufferSize(fs.getFileBufferSize()).setEncryptDataTransfer(fs.getEncryptDataTransfer()).setTrashInterval(fs.getTrashInterval()).setChecksumType(PBHelper.convert(fs.getChecksumType())).setQuotaEnabled(fs.getQuotaEnabled()).build();
    }

    public static HdfsProtos.FsPermissionProto convert(FsPermission p) {
        return HdfsProtos.FsPermissionProto.newBuilder().setPerm(p.toExtendedShort()).build();
    }

    public static FsPermission convert(HdfsProtos.FsPermissionProto p) {
        return new FsPermissionExtension((short)p.getPerm());
    }

    public static int convertCreateFlag(EnumSetWritable<CreateFlag> flag) {
        int value = 0;
        if (flag.contains((Object)CreateFlag.APPEND)) {
            value |= ClientNamenodeProtocolProtos.CreateFlagProto.APPEND.getNumber();
        }
        if (flag.contains((Object)CreateFlag.CREATE)) {
            value |= ClientNamenodeProtocolProtos.CreateFlagProto.CREATE.getNumber();
        }
        if (flag.contains((Object)CreateFlag.OVERWRITE)) {
            value |= ClientNamenodeProtocolProtos.CreateFlagProto.OVERWRITE.getNumber();
        }
        if (flag.contains((Object)CreateFlag.NEW_BLOCK)) {
            value |= ClientNamenodeProtocolProtos.CreateFlagProto.NEW_BLOCK.getNumber();
        }
        return value;
    }

    public static EnumSetWritable<CreateFlag> convertCreateFlag(int flag) {
        EnumSet<CreateFlag> result = EnumSet.noneOf(CreateFlag.class);
        if ((flag & 4) == 4) {
            result.add(CreateFlag.APPEND);
        }
        if ((flag & 1) == 1) {
            result.add(CreateFlag.CREATE);
        }
        if ((flag & 2) == 2) {
            result.add(CreateFlag.OVERWRITE);
        }
        if ((flag & 0x20) == 32) {
            result.add(CreateFlag.NEW_BLOCK);
        }
        return new EnumSetWritable(result, CreateFlag.class);
    }

    public static int convertCacheFlags(EnumSet<CacheFlag> flags) {
        int value = 0;
        if (flags.contains(CacheFlag.FORCE)) {
            value |= ClientNamenodeProtocolProtos.CacheFlagProto.FORCE.getNumber();
        }
        return value;
    }

    public static EnumSet<CacheFlag> convertCacheFlags(int flags) {
        EnumSet<CacheFlag> result = EnumSet.noneOf(CacheFlag.class);
        if ((flags & 1) == 1) {
            result.add(CacheFlag.FORCE);
        }
        return result;
    }

    public static HdfsFileStatus convert(HdfsProtos.HdfsFileStatusProto fs) throws IOException {
        if (fs == null) {
            return null;
        }
        return new HdfsLocatedFileStatus(fs.getLength(), fs.getFileType().equals((Object)HdfsProtos.HdfsFileStatusProto.FileType.IS_DIR), fs.getBlockReplication(), fs.getBlocksize(), fs.getModificationTime(), fs.getAccessTime(), PBHelper.convert(fs.getPermission()), fs.getOwner(), fs.getGroup(), fs.getFileType().equals((Object)HdfsProtos.HdfsFileStatusProto.FileType.IS_SYMLINK) ? fs.getSymlink().toByteArray() : null, fs.getPath().toByteArray(), fs.hasFileId() ? fs.getFileId() : 0L, fs.hasLocations() ? PBHelper.convert(fs.getLocations()) : null, fs.hasChildrenNum() ? fs.getChildrenNum() : -1, fs.hasFileEncryptionInfo() ? PBHelper.convert(fs.getFileEncryptionInfo()) : null, fs.hasStoragePolicy() ? (byte)fs.getStoragePolicy() : (byte)0);
    }

    public static HdfsProtos.HdfsFileStatusProto convert(HdfsFileStatus fs) {
        LocatedBlocks locations;
        if (fs == null) {
            return null;
        }
        HdfsProtos.HdfsFileStatusProto.FileType fType = HdfsProtos.HdfsFileStatusProto.FileType.IS_FILE;
        if (fs.isDir()) {
            fType = HdfsProtos.HdfsFileStatusProto.FileType.IS_DIR;
        } else if (fs.isSymlink()) {
            fType = HdfsProtos.HdfsFileStatusProto.FileType.IS_SYMLINK;
        }
        HdfsProtos.HdfsFileStatusProto.Builder builder = HdfsProtos.HdfsFileStatusProto.newBuilder().setFileId(fs.getFileId()).setLength(fs.getLen()).setFileType(fType).setBlockReplication(fs.getReplication()).setBlocksize(fs.getBlockSize()).setModificationTime(fs.getModificationTime()).setAccessTime(fs.getAccessTime()).setPermission(PBHelper.convert(fs.getPermission())).setOwner(fs.getOwner()).setGroup(fs.getGroup()).setFileId(fs.getFileId()).setChildrenNum(fs.getChildrenNum()).setPath(ByteString.copyFrom((byte[])fs.getLocalNameInBytes())).setStoragePolicy(fs.getStoragePolicy());
        if (fs.isSymlink()) {
            builder.setSymlink(ByteString.copyFrom((byte[])fs.getSymlinkInBytes()));
        }
        if (fs.getFileEncryptionInfo() != null) {
            builder.setFileEncryptionInfo(PBHelper.convert(fs.getFileEncryptionInfo()));
        }
        if (fs instanceof HdfsLocatedFileStatus && (locations = ((HdfsLocatedFileStatus)fs).getBlockLocations()) != null) {
            builder.setLocations(PBHelper.convert(locations));
        }
        return builder.build();
    }

    public static HdfsProtos.HdfsFileStatusProto[] convert(HdfsFileStatus[] fs) {
        if (fs == null) {
            return null;
        }
        int len = fs.length;
        HdfsProtos.HdfsFileStatusProto[] result = new HdfsProtos.HdfsFileStatusProto[len];
        for (int i = 0; i < len; ++i) {
            result[i] = PBHelper.convert(fs[i]);
        }
        return result;
    }

    public static HdfsFileStatus[] convert(HdfsProtos.HdfsFileStatusProto[] fs) throws IOException {
        if (fs == null) {
            return null;
        }
        int len = fs.length;
        HdfsFileStatus[] result = new HdfsFileStatus[len];
        for (int i = 0; i < len; ++i) {
            result[i] = PBHelper.convert(fs[i]);
        }
        return result;
    }

    public static DirectoryListing convert(HdfsProtos.DirectoryListingProto dl) throws IOException {
        if (dl == null) {
            return null;
        }
        List<HdfsProtos.HdfsFileStatusProto> partList = dl.getPartialListingList();
        return new DirectoryListing((HdfsFileStatus[])(partList.isEmpty() ? new HdfsLocatedFileStatus[]{} : PBHelper.convert(partList.toArray(new HdfsProtos.HdfsFileStatusProto[partList.size()]))), dl.getRemainingEntries());
    }

    public static HdfsProtos.DirectoryListingProto convert(DirectoryListing d) {
        if (d == null) {
            return null;
        }
        return HdfsProtos.DirectoryListingProto.newBuilder().addAllPartialListing(Arrays.asList(PBHelper.convert(d.getPartialListing()))).setRemainingEntries(d.getRemainingEntries()).build();
    }

    public static long[] convert(ClientNamenodeProtocolProtos.GetFsStatsResponseProto res) {
        long[] result = new long[]{res.getCapacity(), res.getUsed(), res.getRemaining(), res.getUnderReplicated(), res.getCorruptBlocks(), res.getMissingBlocks(), res.getMissingReplOneBlocks()};
        return result;
    }

    public static ClientNamenodeProtocolProtos.GetFsStatsResponseProto convert(long[] fsStats) {
        ClientNamenodeProtocolProtos.GetFsStatsResponseProto.Builder result = ClientNamenodeProtocolProtos.GetFsStatsResponseProto.newBuilder();
        if (fsStats.length >= 1) {
            result.setCapacity(fsStats[0]);
        }
        if (fsStats.length >= 2) {
            result.setUsed(fsStats[1]);
        }
        if (fsStats.length >= 3) {
            result.setRemaining(fsStats[2]);
        }
        if (fsStats.length >= 4) {
            result.setUnderReplicated(fsStats[3]);
        }
        if (fsStats.length >= 5) {
            result.setCorruptBlocks(fsStats[4]);
        }
        if (fsStats.length >= 6) {
            result.setMissingBlocks(fsStats[5]);
        }
        if (fsStats.length >= 7) {
            result.setMissingReplOneBlocks(fsStats[6]);
        }
        return result.build();
    }

    public static ClientNamenodeProtocolProtos.DatanodeReportTypeProto convert(HdfsConstants.DatanodeReportType t) {
        switch (t) {
            case ALL: {
                return ClientNamenodeProtocolProtos.DatanodeReportTypeProto.ALL;
            }
            case LIVE: {
                return ClientNamenodeProtocolProtos.DatanodeReportTypeProto.LIVE;
            }
            case DEAD: {
                return ClientNamenodeProtocolProtos.DatanodeReportTypeProto.DEAD;
            }
            case DECOMMISSIONING: {
                return ClientNamenodeProtocolProtos.DatanodeReportTypeProto.DECOMMISSIONING;
            }
        }
        throw new IllegalArgumentException("Unexpected data type report:" + (Object)((Object)t));
    }

    public static HdfsConstants.DatanodeReportType convert(ClientNamenodeProtocolProtos.DatanodeReportTypeProto t) {
        switch (t) {
            case ALL: {
                return HdfsConstants.DatanodeReportType.ALL;
            }
            case LIVE: {
                return HdfsConstants.DatanodeReportType.LIVE;
            }
            case DEAD: {
                return HdfsConstants.DatanodeReportType.DEAD;
            }
            case DECOMMISSIONING: {
                return HdfsConstants.DatanodeReportType.DECOMMISSIONING;
            }
        }
        throw new IllegalArgumentException("Unexpected data type report:" + (Object)((Object)t));
    }

    public static ClientNamenodeProtocolProtos.SafeModeActionProto convert(HdfsConstants.SafeModeAction a) {
        switch (a) {
            case SAFEMODE_LEAVE: {
                return ClientNamenodeProtocolProtos.SafeModeActionProto.SAFEMODE_LEAVE;
            }
            case SAFEMODE_ENTER: {
                return ClientNamenodeProtocolProtos.SafeModeActionProto.SAFEMODE_ENTER;
            }
            case SAFEMODE_GET: {
                return ClientNamenodeProtocolProtos.SafeModeActionProto.SAFEMODE_GET;
            }
        }
        throw new IllegalArgumentException("Unexpected SafeModeAction :" + (Object)((Object)a));
    }

    public static HdfsConstants.SafeModeAction convert(ClientNamenodeProtocolProtos.SafeModeActionProto a) {
        switch (a) {
            case SAFEMODE_LEAVE: {
                return HdfsConstants.SafeModeAction.SAFEMODE_LEAVE;
            }
            case SAFEMODE_ENTER: {
                return HdfsConstants.SafeModeAction.SAFEMODE_ENTER;
            }
            case SAFEMODE_GET: {
                return HdfsConstants.SafeModeAction.SAFEMODE_GET;
            }
        }
        throw new IllegalArgumentException("Unexpected SafeModeAction :" + (Object)((Object)a));
    }

    public static ClientNamenodeProtocolProtos.RollingUpgradeActionProto convert(HdfsConstants.RollingUpgradeAction a) {
        switch (a) {
            case QUERY: {
                return ClientNamenodeProtocolProtos.RollingUpgradeActionProto.QUERY;
            }
            case PREPARE: {
                return ClientNamenodeProtocolProtos.RollingUpgradeActionProto.START;
            }
            case FINALIZE: {
                return ClientNamenodeProtocolProtos.RollingUpgradeActionProto.FINALIZE;
            }
        }
        throw new IllegalArgumentException("Unexpected value: " + (Object)((Object)a));
    }

    public static HdfsConstants.RollingUpgradeAction convert(ClientNamenodeProtocolProtos.RollingUpgradeActionProto a) {
        switch (a) {
            case QUERY: {
                return HdfsConstants.RollingUpgradeAction.QUERY;
            }
            case START: {
                return HdfsConstants.RollingUpgradeAction.PREPARE;
            }
            case FINALIZE: {
                return HdfsConstants.RollingUpgradeAction.FINALIZE;
            }
        }
        throw new IllegalArgumentException("Unexpected value: " + (Object)((Object)a));
    }

    public static HdfsProtos.RollingUpgradeStatusProto convertRollingUpgradeStatus(RollingUpgradeStatus status) {
        return HdfsProtos.RollingUpgradeStatusProto.newBuilder().setBlockPoolId(status.getBlockPoolId()).build();
    }

    public static RollingUpgradeStatus convert(HdfsProtos.RollingUpgradeStatusProto proto) {
        return new RollingUpgradeStatus(proto.getBlockPoolId());
    }

    public static ClientNamenodeProtocolProtos.RollingUpgradeInfoProto convert(RollingUpgradeInfo info) {
        return ClientNamenodeProtocolProtos.RollingUpgradeInfoProto.newBuilder().setStatus(PBHelper.convertRollingUpgradeStatus((RollingUpgradeStatus)info)).setStartTime(info.getStartTime()).setFinalizeTime(info.getFinalizeTime()).build();
    }

    public static RollingUpgradeInfo convert(ClientNamenodeProtocolProtos.RollingUpgradeInfoProto proto) {
        HdfsProtos.RollingUpgradeStatusProto status = proto.getStatus();
        return new RollingUpgradeInfo(status.getBlockPoolId(), proto.getStartTime(), proto.getFinalizeTime());
    }

    public static CorruptFileBlocks convert(HdfsProtos.CorruptFileBlocksProto c) {
        if (c == null) {
            return null;
        }
        List<String> fileList = c.getFilesList();
        return new CorruptFileBlocks(fileList.toArray(new String[fileList.size()]), c.getCookie());
    }

    public static HdfsProtos.CorruptFileBlocksProto convert(CorruptFileBlocks c) {
        if (c == null) {
            return null;
        }
        return HdfsProtos.CorruptFileBlocksProto.newBuilder().addAllFiles(Arrays.asList(c.getFiles())).setCookie(c.getCookie()).build();
    }

    public static ContentSummary convert(HdfsProtos.ContentSummaryProto cs) {
        if (cs == null) {
            return null;
        }
        ContentSummary.Builder builder = new ContentSummary.Builder();
        builder.length(cs.getLength()).fileCount(cs.getFileCount()).directoryCount(cs.getDirectoryCount()).quota(cs.getQuota()).spaceConsumed(cs.getSpaceConsumed()).spaceQuota(cs.getSpaceQuota());
        if (cs.hasTypeQuotaInfos()) {
            for (HdfsProtos.StorageTypeQuotaInfoProto info : cs.getTypeQuotaInfos().getTypeQuotaInfoList()) {
                StorageType type = PBHelper.convertStorageType(info.getType());
                builder.typeConsumed(type, info.getConsumed());
                builder.typeQuota(type, info.getQuota());
            }
        }
        return builder.build();
    }

    public static HdfsProtos.ContentSummaryProto convert(ContentSummary cs) {
        if (cs == null) {
            return null;
        }
        HdfsProtos.ContentSummaryProto.Builder builder = HdfsProtos.ContentSummaryProto.newBuilder();
        builder.setLength(cs.getLength()).setFileCount(cs.getFileCount()).setDirectoryCount(cs.getDirectoryCount()).setQuota(cs.getQuota()).setSpaceConsumed(cs.getSpaceConsumed()).setSpaceQuota(cs.getSpaceQuota());
        if (cs.isTypeQuotaSet() || cs.isTypeConsumedAvailable()) {
            HdfsProtos.StorageTypeQuotaInfosProto.Builder isb = HdfsProtos.StorageTypeQuotaInfosProto.newBuilder();
            for (StorageType t : StorageType.getTypesSupportingQuota()) {
                HdfsProtos.StorageTypeQuotaInfoProto info = HdfsProtos.StorageTypeQuotaInfoProto.newBuilder().setType(PBHelper.convertStorageType(t)).setConsumed(cs.getTypeConsumed(t)).setQuota(cs.getTypeQuota(t)).build();
                isb.addTypeQuotaInfo(info);
            }
            builder.setTypeQuotaInfos(isb);
        }
        return builder.build();
    }

    public static HdfsProtos.DatanodeStorageProto convert(DatanodeStorage s) {
        return HdfsProtos.DatanodeStorageProto.newBuilder().setState(PBHelper.convertState(s.getState())).setStorageType(PBHelper.convertStorageType(s.getStorageType())).setStorageUuid(s.getStorageID()).build();
    }

    private static HdfsProtos.DatanodeStorageProto.StorageState convertState(DatanodeStorage.State state) {
        switch (state) {
            case READ_ONLY_SHARED: {
                return HdfsProtos.DatanodeStorageProto.StorageState.READ_ONLY_SHARED;
            }
        }
        return HdfsProtos.DatanodeStorageProto.StorageState.NORMAL;
    }

    public static List<HdfsProtos.StorageTypeProto> convertStorageTypes(StorageType[] types) {
        return PBHelper.convertStorageTypes(types, 0);
    }

    public static List<HdfsProtos.StorageTypeProto> convertStorageTypes(StorageType[] types, int startIdx) {
        if (types == null) {
            return null;
        }
        ArrayList<HdfsProtos.StorageTypeProto> protos = new ArrayList<HdfsProtos.StorageTypeProto>(types.length);
        for (int i = startIdx; i < types.length; ++i) {
            protos.add(PBHelper.convertStorageType(types[i]));
        }
        return protos;
    }

    public static HdfsProtos.StorageTypeProto convertStorageType(StorageType type) {
        switch (type) {
            case DISK: {
                return HdfsProtos.StorageTypeProto.DISK;
            }
            case SSD: {
                return HdfsProtos.StorageTypeProto.SSD;
            }
            case RAID5: {
                return HdfsProtos.StorageTypeProto.RAID5;
            }
            case ARCHIVE: {
                return HdfsProtos.StorageTypeProto.ARCHIVE;
            }
            case DB: {
                return HdfsProtos.StorageTypeProto.DB;
            }
            case PROVIDED: {
                return HdfsProtos.StorageTypeProto.PROVIDED;
            }
        }
        Preconditions.checkState((boolean)false, (Object)("Failed to update StorageTypeProto with new StorageType " + type.toString()));
        return HdfsProtos.StorageTypeProto.DISK;
    }

    public static StorageType convertStorageType(HdfsProtos.StorageTypeProto type) {
        switch (type) {
            case DISK: {
                return StorageType.DISK;
            }
            case SSD: {
                return StorageType.SSD;
            }
            case RAID5: {
                return StorageType.RAID5;
            }
            case ARCHIVE: {
                return StorageType.ARCHIVE;
            }
            case DB: {
                return StorageType.DB;
            }
            case PROVIDED: {
                return StorageType.PROVIDED;
            }
        }
        throw new IllegalStateException("BUG: StorageTypeProto not found, type=" + (Object)((Object)type));
    }

    public static StorageType[] convertStorageTypes(List<HdfsProtos.StorageTypeProto> storageTypesList, int expectedSize) {
        Object[] storageTypes = new StorageType[expectedSize];
        if (storageTypesList.size() != expectedSize) {
            Preconditions.checkState((boolean)storageTypesList.isEmpty());
            Arrays.fill(storageTypes, StorageType.DEFAULT);
        } else {
            for (int i = 0; i < storageTypes.length; ++i) {
                storageTypes[i] = PBHelper.convertStorageType(storageTypesList.get(i));
            }
        }
        return storageTypes;
    }

    public static DatanodeStorage convert(HdfsProtos.DatanodeStorageProto s) {
        return new DatanodeStorage(s.getStorageUuid(), PBHelper.convertState(s.getState()), PBHelper.convertStorageType(s.getStorageType()));
    }

    private static DatanodeStorage.State convertState(HdfsProtos.DatanodeStorageProto.StorageState state) {
        switch (state) {
            case READ_ONLY_SHARED: {
                return DatanodeStorage.State.READ_ONLY_SHARED;
            }
        }
        return DatanodeStorage.State.NORMAL;
    }

    public static HdfsProtos.StorageReportProto convert(StorageReport r) {
        HdfsProtos.StorageReportProto.Builder builder = HdfsProtos.StorageReportProto.newBuilder().setBlockPoolUsed(r.getBlockPoolUsed()).setCapacity(r.getCapacity()).setDfsUsed(r.getDfsUsed()).setRemaining(r.getRemaining()).setStorageUuid(r.getStorage().getStorageID()).setStorage(PBHelper.convert(r.getStorage()));
        return builder.build();
    }

    public static StorageReport convert(HdfsProtos.StorageReportProto p) {
        return new StorageReport(p.hasStorage() ? PBHelper.convert(p.getStorage()) : new DatanodeStorage(p.getStorageUuid()), p.getFailed(), p.getCapacity(), p.getDfsUsed(), p.getRemaining(), p.getBlockPoolUsed());
    }

    public static StorageReport[] convertStorageReports(List<HdfsProtos.StorageReportProto> list) {
        StorageReport[] report = new StorageReport[list.size()];
        for (int i = 0; i < report.length; ++i) {
            report[i] = PBHelper.convert(list.get(i));
        }
        return report;
    }

    public static List<HdfsProtos.StorageReportProto> convertStorageReports(StorageReport[] storages) {
        ArrayList<HdfsProtos.StorageReportProto> protos = new ArrayList<HdfsProtos.StorageReportProto>(storages.length);
        for (int i = 0; i < storages.length; ++i) {
            protos.add(PBHelper.convert(storages[i]));
        }
        return protos;
    }

    public static VolumeFailureSummary convertVolumeFailureSummary(DatanodeProtocolProtos.VolumeFailureSummaryProto proto) {
        List<String> failedStorageLocations = proto.getFailedStorageLocationsList();
        return new VolumeFailureSummary(failedStorageLocations.toArray(new String[failedStorageLocations.size()]), proto.getLastVolumeFailureDate(), proto.getEstimatedCapacityLostTotal());
    }

    public static DatanodeProtocolProtos.VolumeFailureSummaryProto convertVolumeFailureSummary(VolumeFailureSummary volumeFailureSummary) {
        DatanodeProtocolProtos.VolumeFailureSummaryProto.Builder builder = DatanodeProtocolProtos.VolumeFailureSummaryProto.newBuilder();
        for (String failedStorageLocation : volumeFailureSummary.getFailedStorageLocations()) {
            builder.addFailedStorageLocations(failedStorageLocation);
        }
        builder.setLastVolumeFailureDate(volumeFailureSummary.getLastVolumeFailureDate());
        builder.setEstimatedCapacityLostTotal(volumeFailureSummary.getEstimatedCapacityLostTotal());
        return builder.build();
    }

    public static DataChecksum.Type convert(HdfsProtos.ChecksumTypeProto type) {
        return DataChecksum.Type.valueOf((int)type.getNumber());
    }

    public static ClientNamenodeProtocolProtos.CacheDirectiveInfoProto convert(CacheDirectiveInfo info) {
        ClientNamenodeProtocolProtos.CacheDirectiveInfoProto.Builder builder = ClientNamenodeProtocolProtos.CacheDirectiveInfoProto.newBuilder();
        if (info.getId() != null) {
            builder.setId(info.getId());
        }
        if (info.getPath() != null) {
            builder.setPath(info.getPath().toUri().getPath());
        }
        if (info.getReplication() != null) {
            builder.setReplication(info.getReplication().shortValue());
        }
        if (info.getPool() != null) {
            builder.setPool(info.getPool());
        }
        if (info.getExpiration() != null) {
            builder.setExpiration(PBHelper.convert(info.getExpiration()));
        }
        return builder.build();
    }

    public static CacheDirectiveInfo convert(ClientNamenodeProtocolProtos.CacheDirectiveInfoProto proto) {
        CacheDirectiveInfo.Builder builder = new CacheDirectiveInfo.Builder();
        if (proto.hasId()) {
            builder.setId(proto.getId());
        }
        if (proto.hasPath()) {
            builder.setPath(new Path(proto.getPath()));
        }
        if (proto.hasReplication()) {
            builder.setReplication(Shorts.checkedCast((long)proto.getReplication()));
        }
        if (proto.hasPool()) {
            builder.setPool(proto.getPool());
        }
        if (proto.hasExpiration()) {
            builder.setExpiration(PBHelper.convert(proto.getExpiration()));
        }
        return builder.build();
    }

    public static ClientNamenodeProtocolProtos.CacheDirectiveInfoExpirationProto convert(CacheDirectiveInfo.Expiration expiration) {
        return ClientNamenodeProtocolProtos.CacheDirectiveInfoExpirationProto.newBuilder().setIsRelative(expiration.isRelative()).setMillis(expiration.getMillis()).build();
    }

    public static CacheDirectiveInfo.Expiration convert(ClientNamenodeProtocolProtos.CacheDirectiveInfoExpirationProto proto) {
        if (proto.getIsRelative()) {
            return CacheDirectiveInfo.Expiration.newRelative(proto.getMillis());
        }
        return CacheDirectiveInfo.Expiration.newAbsolute(proto.getMillis());
    }

    public static ClientNamenodeProtocolProtos.CacheDirectiveStatsProto convert(CacheDirectiveStats stats) {
        ClientNamenodeProtocolProtos.CacheDirectiveStatsProto.Builder builder = ClientNamenodeProtocolProtos.CacheDirectiveStatsProto.newBuilder();
        builder.setBytesNeeded(stats.getBytesNeeded());
        builder.setBytesCached(stats.getBytesCached());
        builder.setFilesNeeded(stats.getFilesNeeded());
        builder.setFilesCached(stats.getFilesCached());
        builder.setHasExpired(stats.hasExpired());
        return builder.build();
    }

    public static CacheDirectiveStats convert(ClientNamenodeProtocolProtos.CacheDirectiveStatsProto proto) {
        CacheDirectiveStats.Builder builder = new CacheDirectiveStats.Builder();
        builder.setBytesNeeded(proto.getBytesNeeded());
        builder.setBytesCached(proto.getBytesCached());
        builder.setFilesNeeded(proto.getFilesNeeded());
        builder.setFilesCached(proto.getFilesCached());
        builder.setHasExpired(proto.getHasExpired());
        return builder.build();
    }

    public static ClientNamenodeProtocolProtos.CacheDirectiveEntryProto convert(CacheDirectiveEntry entry) {
        ClientNamenodeProtocolProtos.CacheDirectiveEntryProto.Builder builder = ClientNamenodeProtocolProtos.CacheDirectiveEntryProto.newBuilder();
        builder.setInfo(PBHelper.convert(entry.getInfo()));
        builder.setStats(PBHelper.convert(entry.getStats()));
        return builder.build();
    }

    public static CacheDirectiveEntry convert(ClientNamenodeProtocolProtos.CacheDirectiveEntryProto proto) {
        CacheDirectiveInfo info = PBHelper.convert(proto.getInfo());
        CacheDirectiveStats stats = PBHelper.convert(proto.getStats());
        return new CacheDirectiveEntry(info, stats);
    }

    public static ClientNamenodeProtocolProtos.CachePoolInfoProto convert(CachePoolInfo info) {
        ClientNamenodeProtocolProtos.CachePoolInfoProto.Builder builder = ClientNamenodeProtocolProtos.CachePoolInfoProto.newBuilder();
        builder.setPoolName(info.getPoolName());
        if (info.getOwnerName() != null) {
            builder.setOwnerName(info.getOwnerName());
        }
        if (info.getGroupName() != null) {
            builder.setGroupName(info.getGroupName());
        }
        if (info.getMode() != null) {
            builder.setMode(info.getMode().toShort());
        }
        if (info.getLimit() != null) {
            builder.setLimit(info.getLimit());
        }
        if (info.getMaxRelativeExpiryMs() != null) {
            builder.setMaxRelativeExpiry(info.getMaxRelativeExpiryMs());
        }
        return builder.build();
    }

    public static CachePoolInfo convert(ClientNamenodeProtocolProtos.CachePoolInfoProto proto) {
        String poolName = (String)Preconditions.checkNotNull((Object)proto.getPoolName());
        CachePoolInfo info = new CachePoolInfo(poolName);
        if (proto.hasOwnerName()) {
            info.setOwnerName(proto.getOwnerName());
        }
        if (proto.hasGroupName()) {
            info.setGroupName(proto.getGroupName());
        }
        if (proto.hasMode()) {
            info.setMode(new FsPermission((short)proto.getMode()));
        }
        if (proto.hasLimit()) {
            info.setLimit(proto.getLimit());
        }
        if (proto.hasMaxRelativeExpiry()) {
            info.setMaxRelativeExpiryMs(proto.getMaxRelativeExpiry());
        }
        return info;
    }

    public static ClientNamenodeProtocolProtos.CachePoolStatsProto convert(CachePoolStats stats) {
        ClientNamenodeProtocolProtos.CachePoolStatsProto.Builder builder = ClientNamenodeProtocolProtos.CachePoolStatsProto.newBuilder();
        builder.setBytesNeeded(stats.getBytesNeeded());
        builder.setBytesCached(stats.getBytesCached());
        builder.setBytesOverlimit(stats.getBytesOverlimit());
        builder.setFilesNeeded(stats.getFilesNeeded());
        builder.setFilesCached(stats.getFilesCached());
        return builder.build();
    }

    public static CachePoolStats convert(ClientNamenodeProtocolProtos.CachePoolStatsProto proto) {
        CachePoolStats.Builder builder = new CachePoolStats.Builder();
        builder.setBytesNeeded(proto.getBytesNeeded());
        builder.setBytesCached(proto.getBytesCached());
        builder.setBytesOverlimit(proto.getBytesOverlimit());
        builder.setFilesNeeded(proto.getFilesNeeded());
        builder.setFilesCached(proto.getFilesCached());
        return builder.build();
    }

    public static ClientNamenodeProtocolProtos.CachePoolEntryProto convert(CachePoolEntry entry) {
        ClientNamenodeProtocolProtos.CachePoolEntryProto.Builder builder = ClientNamenodeProtocolProtos.CachePoolEntryProto.newBuilder();
        builder.setInfo(PBHelper.convert(entry.getInfo()));
        builder.setStats(PBHelper.convert(entry.getStats()));
        return builder.build();
    }

    public static CachePoolEntry convert(ClientNamenodeProtocolProtos.CachePoolEntryProto proto) {
        CachePoolInfo info = PBHelper.convert(proto.getInfo());
        CachePoolStats stats = PBHelper.convert(proto.getStats());
        return new CachePoolEntry(info, stats);
    }

    public static HdfsProtos.ChecksumTypeProto convert(DataChecksum.Type type) {
        return HdfsProtos.ChecksumTypeProto.valueOf(type.id);
    }

    public static HdfsProtos.DatanodeLocalInfoProto convert(DatanodeLocalInfo info) {
        HdfsProtos.DatanodeLocalInfoProto.Builder builder = HdfsProtos.DatanodeLocalInfoProto.newBuilder();
        builder.setSoftwareVersion(info.getSoftwareVersion());
        builder.setConfigVersion(info.getConfigVersion());
        builder.setUptime(info.getUptime());
        return builder.build();
    }

    public static DatanodeLocalInfo convert(HdfsProtos.DatanodeLocalInfoProto proto) {
        return new DatanodeLocalInfo(proto.getSoftwareVersion(), proto.getConfigVersion(), proto.getUptime());
    }

    public static InputStream vintPrefixed(InputStream input) throws IOException {
        int firstByte = input.read();
        if (firstByte == -1) {
            throw new EOFException("Premature EOF: no length prefix available");
        }
        int size = CodedInputStream.readRawVarint32((int)firstByte, (InputStream)input);
        assert (size >= 0);
        return new ExactSizeInputStream(input, size);
    }

    private static AclProtos.AclEntryProto.AclEntryScopeProto convert(AclEntryScope v) {
        return AclProtos.AclEntryProto.AclEntryScopeProto.valueOf(v.ordinal());
    }

    private static AclEntryScope convert(AclProtos.AclEntryProto.AclEntryScopeProto v) {
        return (AclEntryScope)PBHelper.castEnum((Enum)v, (Enum[])ACL_ENTRY_SCOPE_VALUES);
    }

    private static AclProtos.AclEntryProto.AclEntryTypeProto convert(AclEntryType e) {
        return AclProtos.AclEntryProto.AclEntryTypeProto.valueOf(e.ordinal());
    }

    private static AclEntryType convert(AclProtos.AclEntryProto.AclEntryTypeProto v) {
        return (AclEntryType)PBHelper.castEnum((Enum)v, (Enum[])ACL_ENTRY_TYPE_VALUES);
    }

    private static XAttrProtos.XAttrProto.XAttrNamespaceProto convert(XAttr.NameSpace v) {
        return XAttrProtos.XAttrProto.XAttrNamespaceProto.valueOf(v.ordinal());
    }

    private static XAttr.NameSpace convert(XAttrProtos.XAttrProto.XAttrNamespaceProto v) {
        return (XAttr.NameSpace)PBHelper.castEnum((Enum)v, (Enum[])XATTR_NAMESPACE_VALUES);
    }

    public static List<AclProtos.AclEntryProto> convertAclEntryProto(List<AclEntry> aclSpec) {
        ArrayList r = Lists.newArrayListWithCapacity((int)aclSpec.size());
        for (AclEntry e : aclSpec) {
            AclProtos.AclEntryProto.Builder builder = AclProtos.AclEntryProto.newBuilder();
            builder.setType(PBHelper.convert(e.getType()));
            builder.setScope(PBHelper.convert(e.getScope()));
            builder.setPermissions(PBHelper.convert(e.getPermission()));
            if (e.getName() != null) {
                builder.setName(e.getName());
            }
            r.add(builder.build());
        }
        return r;
    }

    public static List<AclEntry> convertAclEntry(List<AclProtos.AclEntryProto> aclSpec) {
        ArrayList r = Lists.newArrayListWithCapacity((int)aclSpec.size());
        for (AclProtos.AclEntryProto e : aclSpec) {
            AclEntry.Builder builder = new AclEntry.Builder();
            builder.setType(PBHelper.convert(e.getType()));
            builder.setScope(PBHelper.convert(e.getScope()));
            builder.setPermission(PBHelper.convert(e.getPermissions()));
            if (e.hasName()) {
                builder.setName(e.getName());
            }
            r.add(builder.build());
        }
        return r;
    }

    public static AclStatus convert(AclProtos.GetAclStatusResponseProto e) {
        AclProtos.AclStatusProto r = e.getResult();
        AclStatus.Builder builder = new AclStatus.Builder();
        builder.owner(r.getOwner()).group(r.getGroup()).stickyBit(r.getSticky()).addEntries(PBHelper.convertAclEntry(r.getEntriesList()));
        if (r.hasPermission()) {
            builder.setPermission(PBHelper.convert(r.getPermission()));
        }
        return builder.build();
    }

    public static AclProtos.GetAclStatusResponseProto convert(AclStatus e) {
        AclProtos.AclStatusProto.Builder builder = AclProtos.AclStatusProto.newBuilder();
        builder.setOwner(e.getOwner()).setGroup(e.getGroup()).setSticky(e.isStickyBit()).addAllEntries(PBHelper.convertAclEntryProto(e.getEntries()));
        if (e.getPermission() != null) {
            builder.setPermission(PBHelper.convert(e.getPermission()));
        }
        AclProtos.AclStatusProto r = builder.build();
        return AclProtos.GetAclStatusResponseProto.newBuilder().setResult(r).build();
    }

    public static XAttrProtos.XAttrProto convertXAttrProto(XAttr a) {
        XAttrProtos.XAttrProto.Builder builder = XAttrProtos.XAttrProto.newBuilder();
        builder.setNamespace(PBHelper.convert(a.getNameSpace()));
        if (a.getName() != null) {
            builder.setName(a.getName());
        }
        if (a.getValue() != null) {
            builder.setValue(PBHelper.getByteString(a.getValue()));
        }
        return builder.build();
    }

    public static List<XAttrProtos.XAttrProto> convertXAttrProto(List<XAttr> xAttrSpec) {
        if (xAttrSpec == null) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        ArrayList xAttrs = Lists.newArrayListWithCapacity((int)xAttrSpec.size());
        for (XAttr a : xAttrSpec) {
            XAttrProtos.XAttrProto.Builder builder = XAttrProtos.XAttrProto.newBuilder();
            builder.setNamespace(PBHelper.convert(a.getNameSpace()));
            if (a.getName() != null) {
                builder.setName(a.getName());
            }
            if (a.getValue() != null) {
                builder.setValue(PBHelper.getByteString(a.getValue()));
            }
            xAttrs.add(builder.build());
        }
        return xAttrs;
    }

    public static int convert(EnumSet<XAttrSetFlag> flag) {
        int value = 0;
        if (flag.contains(XAttrSetFlag.CREATE)) {
            value |= XAttrProtos.XAttrSetFlagProto.XATTR_CREATE.getNumber();
        }
        if (flag.contains(XAttrSetFlag.REPLACE)) {
            value |= XAttrProtos.XAttrSetFlagProto.XATTR_REPLACE.getNumber();
        }
        return value;
    }

    public static EnumSet<XAttrSetFlag> convert(int flag) {
        EnumSet<XAttrSetFlag> result = EnumSet.noneOf(XAttrSetFlag.class);
        if ((flag & 1) == 1) {
            result.add(XAttrSetFlag.CREATE);
        }
        if ((flag & 2) == 2) {
            result.add(XAttrSetFlag.REPLACE);
        }
        return result;
    }

    public static XAttr convertXAttr(XAttrProtos.XAttrProto a) {
        XAttr.Builder builder = new XAttr.Builder();
        builder.setNameSpace(PBHelper.convert(a.getNamespace()));
        if (a.hasName()) {
            builder.setName(a.getName());
        }
        if (a.hasValue()) {
            builder.setValue(a.getValue().toByteArray());
        }
        return builder.build();
    }

    public static List<XAttr> convertXAttrs(List<XAttrProtos.XAttrProto> xAttrSpec) {
        ArrayList xAttrs = Lists.newArrayListWithCapacity((int)xAttrSpec.size());
        for (XAttrProtos.XAttrProto a : xAttrSpec) {
            XAttr.Builder builder = new XAttr.Builder();
            builder.setNameSpace(PBHelper.convert(a.getNamespace()));
            if (a.hasName()) {
                builder.setName(a.getName());
            }
            if (a.hasValue()) {
                builder.setValue(a.getValue().toByteArray());
            }
            xAttrs.add(builder.build());
        }
        return xAttrs;
    }

    public static List<XAttr> convert(XAttrProtos.GetXAttrsResponseProto a) {
        List<XAttrProtos.XAttrProto> xAttrs = a.getXAttrsList();
        return PBHelper.convertXAttrs(xAttrs);
    }

    public static XAttrProtos.GetXAttrsResponseProto convertXAttrsResponse(List<XAttr> xAttrs) {
        XAttrProtos.GetXAttrsResponseProto.Builder builder = XAttrProtos.GetXAttrsResponseProto.newBuilder();
        if (xAttrs != null) {
            builder.addAllXAttrs(PBHelper.convertXAttrProto(xAttrs));
        }
        return builder.build();
    }

    public static List<XAttr> convert(XAttrProtos.ListXAttrsResponseProto a) {
        List<XAttrProtos.XAttrProto> xAttrs = a.getXAttrsList();
        return PBHelper.convertXAttrs(xAttrs);
    }

    public static XAttrProtos.ListXAttrsResponseProto convertListXAttrsResponse(List<XAttr> names) {
        XAttrProtos.ListXAttrsResponseProto.Builder builder = XAttrProtos.ListXAttrsResponseProto.newBuilder();
        if (names != null) {
            builder.addAllXAttrs(PBHelper.convertXAttrProto(names));
        }
        return builder.build();
    }

    public static EncryptionZonesProtos.EncryptionZoneProto convert(EncryptionZone zone) {
        return EncryptionZonesProtos.EncryptionZoneProto.newBuilder().setId(zone.getId()).setPath(zone.getPath()).setSuite(PBHelper.convert(zone.getSuite())).setCryptoProtocolVersion(PBHelper.convert(zone.getVersion())).setKeyName(zone.getKeyName()).build();
    }

    public static EncryptionZone convert(EncryptionZonesProtos.EncryptionZoneProto proto) {
        return new EncryptionZone(proto.getId(), proto.getPath(), PBHelper.convert(proto.getSuite()), PBHelper.convert(proto.getCryptoProtocolVersion()), proto.getKeyName());
    }

    public static DataTransferProtos.ShortCircuitShmSlotProto convert(ShortCircuitShm.SlotId slotId) {
        return DataTransferProtos.ShortCircuitShmSlotProto.newBuilder().setShmId(PBHelper.convert(slotId.getShmId())).setSlotIdx(slotId.getSlotIdx()).build();
    }

    public static DataTransferProtos.ShortCircuitShmIdProto convert(ShortCircuitShm.ShmId shmId) {
        return DataTransferProtos.ShortCircuitShmIdProto.newBuilder().setHi(shmId.getHi()).setLo(shmId.getLo()).build();
    }

    public static ShortCircuitShm.SlotId convert(DataTransferProtos.ShortCircuitShmSlotProto slotId) {
        return new ShortCircuitShm.SlotId(PBHelper.convert(slotId.getShmId()), slotId.getSlotIdx());
    }

    public static ShortCircuitShm.ShmId convert(DataTransferProtos.ShortCircuitShmIdProto shmId) {
        return new ShortCircuitShm.ShmId(shmId.getHi(), shmId.getLo());
    }

    public static HdfsProtos.CipherSuiteProto convert(CipherSuite suite) {
        switch (suite) {
            case UNKNOWN: {
                return HdfsProtos.CipherSuiteProto.UNKNOWN;
            }
            case AES_CTR_NOPADDING: {
                return HdfsProtos.CipherSuiteProto.AES_CTR_NOPADDING;
            }
        }
        return null;
    }

    public static CipherSuite convert(HdfsProtos.CipherSuiteProto proto) {
        switch (proto) {
            case AES_CTR_NOPADDING: {
                return CipherSuite.AES_CTR_NOPADDING;
            }
        }
        CipherSuite suite = CipherSuite.UNKNOWN;
        suite.setUnknownValue(proto.getNumber());
        return suite;
    }

    public static List<HdfsProtos.CryptoProtocolVersionProto> convert(CryptoProtocolVersion[] versions) {
        ArrayList protos = Lists.newArrayListWithCapacity((int)versions.length);
        for (CryptoProtocolVersion v : versions) {
            protos.add(PBHelper.convert(v));
        }
        return protos;
    }

    public static CryptoProtocolVersion[] convertCryptoProtocolVersions(List<HdfsProtos.CryptoProtocolVersionProto> protos) {
        ArrayList versions = Lists.newArrayListWithCapacity((int)protos.size());
        for (HdfsProtos.CryptoProtocolVersionProto p : protos) {
            versions.add(PBHelper.convert(p));
        }
        return versions.toArray(new CryptoProtocolVersion[0]);
    }

    public static CryptoProtocolVersion convert(HdfsProtos.CryptoProtocolVersionProto proto) {
        switch (proto) {
            case ENCRYPTION_ZONES: {
                return CryptoProtocolVersion.ENCRYPTION_ZONES;
            }
        }
        CryptoProtocolVersion version = CryptoProtocolVersion.UNKNOWN;
        version.setUnknownValue(proto.getNumber());
        return version;
    }

    public static HdfsProtos.CryptoProtocolVersionProto convert(CryptoProtocolVersion version) {
        switch (version) {
            case UNKNOWN: {
                return HdfsProtos.CryptoProtocolVersionProto.UNKNOWN_PROTOCOL_VERSION;
            }
            case ENCRYPTION_ZONES: {
                return HdfsProtos.CryptoProtocolVersionProto.ENCRYPTION_ZONES;
            }
        }
        return null;
    }

    public static HdfsProtos.FileEncryptionInfoProto convert(FileEncryptionInfo info) {
        if (info == null) {
            return null;
        }
        return HdfsProtos.FileEncryptionInfoProto.newBuilder().setSuite(PBHelper.convert(info.getCipherSuite())).setCryptoProtocolVersion(PBHelper.convert(info.getCryptoProtocolVersion())).setKey(PBHelper.getByteString(info.getEncryptedDataEncryptionKey())).setIv(PBHelper.getByteString(info.getIV())).setEzKeyVersionName(info.getEzKeyVersionName()).setKeyName(info.getKeyName()).build();
    }

    public static HdfsProtos.PerFileEncryptionInfoProto convertPerFileEncInfo(FileEncryptionInfo info) {
        if (info == null) {
            return null;
        }
        return HdfsProtos.PerFileEncryptionInfoProto.newBuilder().setKey(PBHelper.getByteString(info.getEncryptedDataEncryptionKey())).setIv(PBHelper.getByteString(info.getIV())).setEzKeyVersionName(info.getEzKeyVersionName()).build();
    }

    public static HdfsProtos.ZoneEncryptionInfoProto convert(CipherSuite suite, CryptoProtocolVersion version, String keyName) {
        if (suite == null || version == null || keyName == null) {
            return null;
        }
        return HdfsProtos.ZoneEncryptionInfoProto.newBuilder().setSuite(PBHelper.convert(suite)).setCryptoProtocolVersion(PBHelper.convert(version)).setKeyName(keyName).build();
    }

    public static FileEncryptionInfo convert(HdfsProtos.FileEncryptionInfoProto proto) {
        if (proto == null) {
            return null;
        }
        CipherSuite suite = PBHelper.convert(proto.getSuite());
        CryptoProtocolVersion version = PBHelper.convert(proto.getCryptoProtocolVersion());
        byte[] key = proto.getKey().toByteArray();
        byte[] iv = proto.getIv().toByteArray();
        String ezKeyVersionName = proto.getEzKeyVersionName();
        String keyName = proto.getKeyName();
        return new FileEncryptionInfo(suite, version, key, iv, keyName, ezKeyVersionName);
    }

    public static FileEncryptionInfo convert(HdfsProtos.PerFileEncryptionInfoProto fileProto, CipherSuite suite, CryptoProtocolVersion version, String keyName) {
        if (fileProto == null || suite == null || version == null || keyName == null) {
            return null;
        }
        byte[] key = fileProto.getKey().toByteArray();
        byte[] iv = fileProto.getIv().toByteArray();
        String ezKeyVersionName = fileProto.getEzKeyVersionName();
        return new FileEncryptionInfo(suite, version, key, iv, keyName, ezKeyVersionName);
    }

    public static SortedActiveNodeList convert(DatanodeProtocolProtos.ActiveNamenodeListResponseProto p) {
        ArrayList<ActiveNode> anl = new ArrayList<ActiveNode>();
        List<ActiveNodeProtos.ActiveNodeProto> anlp = p.getNamenodesList();
        for (ActiveNodeProtos.ActiveNodeProto anAnlp : anlp) {
            ActiveNode an = PBHelper.convert(anAnlp);
            anl.add(an);
        }
        return new SortedActiveNodeListPBImpl(anl);
    }

    public static ActiveNode convert(ActiveNodeProtos.ActiveNodeProto p) {
        ActiveNodePBImpl an = new ActiveNodePBImpl(p.getId(), p.getRpcHostname(), p.getRpcIpAddress(), p.getRpcPort(), p.getHttpAddress(), p.getServiceIpAddress(), p.getServicePort(), p.getLocationDomainId());
        return an;
    }

    public static ActiveNodeProtos.ActiveNodeProto convert(ActiveNode p) {
        ActiveNodeProtos.ActiveNodeProto.Builder anp = ActiveNodeProtos.ActiveNodeProto.newBuilder();
        anp.setId(p.getId());
        anp.setRpcHostname(p.getHostname());
        anp.setRpcIpAddress(p.getRpcServerIpAddress());
        anp.setRpcPort(p.getRpcServerPort());
        anp.setHttpAddress(p.getHttpAddress());
        anp.setServiceIpAddress(p.getServiceRpcIpAddress());
        anp.setServicePort(p.getServiceRpcPort());
        return anp.build();
    }

    public static DatanodeProtocolProtos.ActiveNamenodeListResponseProto convert(SortedActiveNodeList anlWrapper) {
        List anl = anlWrapper.getActiveNodes();
        DatanodeProtocolProtos.ActiveNamenodeListResponseProto.Builder anlrpb = DatanodeProtocolProtos.ActiveNamenodeListResponseProto.newBuilder();
        for (ActiveNode anAnl : anl) {
            ActiveNodeProtos.ActiveNodeProto anp = PBHelper.convert(anAnl);
            anlrpb.addNamenodes(anp);
        }
        return anlrpb.build();
    }

    public static EncodingStatus convert(ClientNamenodeProtocolProtos.EncodingStatusProto encodingStatusProto) {
        EncodingStatus status = new EncodingStatus();
        if (encodingStatusProto.hasInodeId()) {
            status.setInodeId(Long.valueOf(encodingStatusProto.getInodeId()));
        }
        if (encodingStatusProto.hasParityInodeId()) {
            status.setParityInodeId(Long.valueOf(encodingStatusProto.getParityInodeId()));
        }
        status.setStatus(EncodingStatus.Status.values()[encodingStatusProto.getStatus()]);
        if (encodingStatusProto.hasParityStatus()) {
            status.setParityStatus(EncodingStatus.ParityStatus.values()[encodingStatusProto.getParityStatus()]);
        }
        if (encodingStatusProto.hasPolicy()) {
            status.setEncodingPolicy(PBHelper.convert(encodingStatusProto.getPolicy()));
        }
        if (encodingStatusProto.hasStatusModificationTime()) {
            status.setStatusModificationTime(Long.valueOf(encodingStatusProto.getStatusModificationTime()));
        }
        if (encodingStatusProto.hasParityStatusModificationTime()) {
            status.setParityStatusModificationTime(Long.valueOf(encodingStatusProto.getParityStatusModificationTime()));
        }
        if (encodingStatusProto.hasParityFileName()) {
            status.setParityFileName(encodingStatusProto.getParityFileName());
        }
        if (encodingStatusProto.hasLostBlocks()) {
            status.setLostBlocks(Integer.valueOf(encodingStatusProto.getLostBlocks()));
        }
        if (encodingStatusProto.hasLostParityBlocks()) {
            status.setLostParityBlocks(Integer.valueOf(encodingStatusProto.getLostParityBlocks()));
        }
        if (encodingStatusProto.hasRevoked()) {
            status.setRevoked(Boolean.valueOf(encodingStatusProto.getRevoked()));
        }
        return status;
    }

    public static ClientNamenodeProtocolProtos.EncodingStatusProto convert(EncodingStatus encodingStatus) {
        ClientNamenodeProtocolProtos.EncodingStatusProto.Builder builder = ClientNamenodeProtocolProtos.EncodingStatusProto.newBuilder();
        if (encodingStatus.getInodeId() != null) {
            builder.setInodeId(encodingStatus.getInodeId());
        }
        if (encodingStatus.getParityInodeId() != null) {
            builder.setParityInodeId(encodingStatus.getParityInodeId());
        }
        builder.setStatus(encodingStatus.getStatus().ordinal());
        if (encodingStatus.getParityStatus() != null) {
            builder.setParityStatus(encodingStatus.getParityStatus().ordinal());
        }
        if (encodingStatus.getEncodingPolicy() != null) {
            builder.setPolicy(PBHelper.convert(encodingStatus.getEncodingPolicy()));
        }
        if (encodingStatus.getStatusModificationTime() != null) {
            builder.setStatusModificationTime(encodingStatus.getStatusModificationTime());
        }
        if (encodingStatus.getParityStatusModificationTime() != null) {
            builder.setParityStatusModificationTime(encodingStatus.getParityStatusModificationTime());
        }
        if (encodingStatus.getParityFileName() != null) {
            builder.setParityFileName(encodingStatus.getParityFileName());
        }
        if (encodingStatus.getLostBlocks() != null) {
            builder.setLostBlocks(encodingStatus.getLostBlocks());
        }
        if (encodingStatus.getLostParityBlocks() != null) {
            builder.setLostParityBlocks(encodingStatus.getLostParityBlocks());
        }
        if (encodingStatus.getRevoked() != null) {
            builder.setRevoked(encodingStatus.getRevoked());
        }
        return builder.build();
    }

    public static ClientNamenodeProtocolProtos.EncodingPolicyProto convert(EncodingPolicy encodingPolicy) {
        ClientNamenodeProtocolProtos.EncodingPolicyProto.Builder builder = ClientNamenodeProtocolProtos.EncodingPolicyProto.newBuilder();
        builder.setCodec(encodingPolicy.getCodec());
        builder.setTargetReplication(encodingPolicy.getTargetReplication());
        return builder.build();
    }

    public static EncodingPolicy convert(ClientNamenodeProtocolProtos.EncodingPolicyProto encodingPolicyProto) {
        return new EncodingPolicy(encodingPolicyProto.getCodec(), (short)encodingPolicyProto.getTargetReplication());
    }

    public static byte[] convert(DatanodeProtocolProtos.SmallFileDataResponseProto response) {
        return response.getData().toByteArray();
    }

    public static DatanodeProtocolProtos.SmallFileDataResponseProto convert(byte[] data) {
        DatanodeProtocolProtos.SmallFileDataResponseProto.Builder responseProto = DatanodeProtocolProtos.SmallFileDataResponseProto.newBuilder();
        responseProto.setData(ByteString.copyFrom((byte[])data));
        return responseProto.build();
    }

    public static DatanodeProtocolProtos.BlockReportProto convert(BlockReport report, boolean useBlocksBuffer) {
        ArrayList<DatanodeProtocolProtos.BlockReportBucketProto> bucketProtos = new ArrayList<DatanodeProtocolProtos.BlockReportBucketProto>();
        for (Bucket bucket : report.getBuckets()) {
            DatanodeProtocolProtos.BlockReportBucketProto.Builder bucketBuilder = DatanodeProtocolProtos.BlockReportBucketProto.newBuilder();
            bucketBuilder.setHash(ByteString.copyFrom((byte[])bucket.getHash()));
            bucketBuilder.setSkip(bucket.isSkip());
            BlockListAsLongs blocks = bucket.getBlocks();
            if (useBlocksBuffer) {
                bucketBuilder.setNumberOfBlocks(blocks.getNumberOfBlocks());
                bucketBuilder.addAllBlocksBuffers(blocks.getBlocksBuffers());
            } else {
                for (long value : blocks.getBlockListAsLongs()) {
                    bucketBuilder.addBlocks(value);
                }
            }
            bucketProtos.add(bucketBuilder.build());
        }
        return DatanodeProtocolProtos.BlockReportProto.newBuilder().addAllBuckets(bucketProtos).build();
    }

    public static BlockReport convert(DatanodeProtocolProtos.BlockReportProto blockReportProto) {
        int numBuckets = blockReportProto.getBucketsCount();
        Bucket[] buckets = new Bucket[numBuckets];
        long[] hashes = new long[numBuckets];
        int numBlocks = 0;
        for (int i = 0; i < numBuckets; ++i) {
            BlockListAsLongs blocks;
            DatanodeProtocolProtos.BlockReportBucketProto bucketProto = blockReportProto.getBuckets(i);
            if (bucketProto.hasNumberOfBlocks()) {
                int num = (int)bucketProto.getNumberOfBlocks();
                Preconditions.checkState((bucketProto.getBlocksCount() == 0 ? 1 : 0) != 0, (Object)"cannot send both blocks list and buffers");
                numBlocks += num;
                blocks = BlockListAsLongs.decodeBuffers(num, bucketProto.getBlocksBuffersList());
            } else {
                blocks = BlockListAsLongs.decodeLongs(bucketProto.getBlocksList());
                numBlocks += blocks.getNumberOfBlocks();
            }
            Bucket bucket = new Bucket();
            bucket.setBlocks(blocks);
            bucket.setHash(bucketProto.getHash().toByteArray());
            bucket.setSkip(bucketProto.getSkip());
            buckets[i] = bucket;
        }
        return new BlockReport(buckets, numBlocks);
    }

    public static HdfsProtos.CipherOptionProto convert(CipherOption option) {
        if (option != null) {
            HdfsProtos.CipherOptionProto.Builder builder = HdfsProtos.CipherOptionProto.newBuilder();
            if (option.getCipherSuite() != null) {
                builder.setSuite(PBHelper.convert(option.getCipherSuite()));
            }
            if (option.getInKey() != null) {
                builder.setInKey(ByteString.copyFrom((byte[])option.getInKey()));
            }
            if (option.getInIv() != null) {
                builder.setInIv(ByteString.copyFrom((byte[])option.getInIv()));
            }
            if (option.getOutKey() != null) {
                builder.setOutKey(ByteString.copyFrom((byte[])option.getOutKey()));
            }
            if (option.getOutIv() != null) {
                builder.setOutIv(ByteString.copyFrom((byte[])option.getOutIv()));
            }
            return builder.build();
        }
        return null;
    }

    public static CipherOption convert(HdfsProtos.CipherOptionProto proto) {
        if (proto != null) {
            CipherSuite suite = null;
            if (proto.getSuite() != null) {
                suite = PBHelper.convert(proto.getSuite());
            }
            byte[] inKey = null;
            if (proto.getInKey() != null) {
                inKey = proto.getInKey().toByteArray();
            }
            byte[] inIv = null;
            if (proto.getInIv() != null) {
                inIv = proto.getInIv().toByteArray();
            }
            byte[] outKey = null;
            if (proto.getOutKey() != null) {
                outKey = proto.getOutKey().toByteArray();
            }
            byte[] outIv = null;
            if (proto.getOutIv() != null) {
                outIv = proto.getOutIv().toByteArray();
            }
            return new CipherOption(suite, inKey, inIv, outKey, outIv);
        }
        return null;
    }

    public static List<HdfsProtos.CipherOptionProto> convertCipherOptions(List<CipherOption> options) {
        if (options != null) {
            ArrayList protos = Lists.newArrayListWithCapacity((int)options.size());
            for (CipherOption option : options) {
                protos.add(PBHelper.convert(option));
            }
            return protos;
        }
        return null;
    }

    public static List<CipherOption> convertCipherOptionProtos(List<HdfsProtos.CipherOptionProto> protos) {
        if (protos != null) {
            ArrayList options = Lists.newArrayListWithCapacity((int)protos.size());
            for (HdfsProtos.CipherOptionProto proto : protos) {
                options.add(PBHelper.convert(proto));
            }
            return options;
        }
        return null;
    }

    public static AclProtos.AclEntryProto.FsActionProto convert(FsAction v) {
        return AclProtos.AclEntryProto.FsActionProto.valueOf(v != null ? v.ordinal() : 0);
    }

    public static FsAction convert(AclProtos.AclEntryProto.FsActionProto v) {
        return (FsAction)PBHelper.castEnum((Enum)v, (Enum[])FSACTION_VALUES);
    }

    public static LastUpdatedContentSummary convert(ClientNamenodeProtocolProtos.LastUpdatedContentSummaryProto cs) {
        if (cs == null) {
            return null;
        }
        LastUpdatedContentSummary.Builder builder = new LastUpdatedContentSummary.Builder();
        builder.fileAndDirectoryCount(cs.getFileandDirCount()).spaceConsumed(cs.getSpaceConsumed()).quota(cs.getNsQuota()).spaceQuota(cs.getDsQuota());
        if (cs.hasTypeQuotaInfos()) {
            for (HdfsProtos.StorageTypeQuotaInfoProto info : cs.getTypeQuotaInfos().getTypeQuotaInfoList()) {
                StorageType type = PBHelper.convertStorageType(info.getType());
                builder.typeConsumed(type, info.getConsumed());
                builder.typeQuota(type, info.getQuota());
            }
        }
        return builder.build();
    }

    public static ClientNamenodeProtocolProtos.LastUpdatedContentSummaryProto convert(LastUpdatedContentSummary cs) {
        if (cs == null) {
            return null;
        }
        ClientNamenodeProtocolProtos.LastUpdatedContentSummaryProto.Builder builder = ClientNamenodeProtocolProtos.LastUpdatedContentSummaryProto.newBuilder();
        builder.setFileandDirCount(cs.getFileAndDirCount()).setNsQuota(cs.getNsQuota()).setSpaceConsumed(cs.getSpaceConsumed()).setDsQuota(cs.getDsQuota());
        if (cs.isTypeQuotaSet() || cs.isTypeConsumedAvailable()) {
            HdfsProtos.StorageTypeQuotaInfosProto.Builder isb = HdfsProtos.StorageTypeQuotaInfosProto.newBuilder();
            for (StorageType t : StorageType.getTypesSupportingQuota()) {
                HdfsProtos.StorageTypeQuotaInfoProto info = HdfsProtos.StorageTypeQuotaInfoProto.newBuilder().setType(PBHelper.convertStorageType(t)).setConsumed(cs.getTypeConsumed(t)).setQuota(cs.getTypeQuota(t)).build();
                isb.addTypeQuotaInfo(info);
            }
            builder.setTypeQuotaInfos(isb);
        }
        return builder.build();
    }

    public static BlockStoragePolicy[] convertStoragePolicies(List<HdfsProtos.BlockStoragePolicyProto> policyProtos) {
        if (policyProtos == null || policyProtos.size() == 0) {
            return new BlockStoragePolicy[0];
        }
        BlockStoragePolicy[] policies = new BlockStoragePolicy[policyProtos.size()];
        int i = 0;
        for (HdfsProtos.BlockStoragePolicyProto proto : policyProtos) {
            policies[i++] = PBHelper.convert(proto);
        }
        return policies;
    }

    public static BlockStoragePolicy convert(HdfsProtos.BlockStoragePolicyProto proto) {
        List<HdfsProtos.StorageTypeProto> cList = proto.getCreationPolicy().getStorageTypesList();
        StorageType[] creationTypes = PBHelper.convertStorageTypes(cList, cList.size());
        List<HdfsProtos.StorageTypeProto> cfList = proto.hasCreationFallbackPolicy() ? proto.getCreationFallbackPolicy().getStorageTypesList() : null;
        StorageType[] creationFallbackTypes = cfList == null ? StorageType.EMPTY_ARRAY : PBHelper.convertStorageTypes(cfList, cfList.size());
        List<HdfsProtos.StorageTypeProto> rfList = proto.hasReplicationFallbackPolicy() ? proto.getReplicationFallbackPolicy().getStorageTypesList() : null;
        StorageType[] replicationFallbackTypes = rfList == null ? StorageType.EMPTY_ARRAY : PBHelper.convertStorageTypes(rfList, rfList.size());
        return new BlockStoragePolicy((byte)proto.getPolicyId(), proto.getName(), creationTypes, creationFallbackTypes, replicationFallbackTypes);
    }

    public static HdfsProtos.BlockStoragePolicyProto convert(BlockStoragePolicy policy) {
        HdfsProtos.StorageTypesProto replicationFallbackProto;
        HdfsProtos.BlockStoragePolicyProto.Builder builder = HdfsProtos.BlockStoragePolicyProto.newBuilder().setPolicyId(policy.getId()).setName(policy.getName());
        HdfsProtos.StorageTypesProto creationProto = PBHelper.convert(policy.getStorageTypes());
        Preconditions.checkArgument((creationProto != null ? 1 : 0) != 0);
        builder.setCreationPolicy(creationProto);
        HdfsProtos.StorageTypesProto creationFallbackProto = PBHelper.convert(policy.getCreationFallbacks());
        if (creationFallbackProto != null) {
            builder.setCreationFallbackPolicy(creationFallbackProto);
        }
        if ((replicationFallbackProto = PBHelper.convert(policy.getReplicationFallbacks())) != null) {
            builder.setReplicationFallbackPolicy(replicationFallbackProto);
        }
        return builder.build();
    }

    public static HdfsProtos.StorageTypesProto convert(StorageType[] types) {
        if (types == null || types.length == 0) {
            return null;
        }
        List<HdfsProtos.StorageTypeProto> list = PBHelper.convertStorageTypes(types);
        return HdfsProtos.StorageTypesProto.newBuilder().addAllStorageTypes(list).build();
    }

    public static byte[] longToBytes(Long x) {
        if (x == null) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(x);
        return buffer.array();
    }

    public static Long bytesToLong(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.put(bytes);
        buffer.flip();
        return buffer.getLong();
    }

    public static List<Boolean> convert(boolean[] targetPinnings, int idx) {
        ArrayList<Boolean> pinnings = new ArrayList<Boolean>();
        if (targetPinnings == null) {
            pinnings.add(Boolean.FALSE);
        } else {
            while (idx < targetPinnings.length) {
                pinnings.add(targetPinnings[idx]);
                ++idx;
            }
        }
        return pinnings;
    }

    public static boolean[] convertBooleanList(List<Boolean> targetPinningsList) {
        boolean[] targetPinnings = new boolean[targetPinningsList.size()];
        for (int i = 0; i < targetPinningsList.size(); ++i) {
            targetPinnings[i] = targetPinningsList.get(i);
        }
        return targetPinnings;
    }

    public static BlockReportContext convert(DatanodeProtocolProtos.BlockReportContextProto proto) {
        return new BlockReportContext(proto.getTotalRpcs(), proto.getCurRpc(), proto.getId());
    }

    public static DatanodeProtocolProtos.BlockReportContextProto convert(BlockReportContext context) {
        return DatanodeProtocolProtos.BlockReportContextProto.newBuilder().setTotalRpcs(context.getTotalRpcs()).setCurRpc(context.getCurRpc()).setId(context.getReportId()).build();
    }
}

