/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.terracotta.statistics.extended;

import io.hops.hadoop.shaded.org.terracotta.statistics.ValueStatistic;
import io.hops.hadoop.shaded.org.terracotta.statistics.archive.Timestamped;
import io.hops.hadoop.shaded.org.terracotta.statistics.extended.SampledStatistic;
import io.hops.hadoop.shaded.org.terracotta.statistics.extended.StatisticHistory;
import io.hops.hadoop.shaded.org.terracotta.statistics.extended.StatisticType;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

abstract class AbstractSampledStatistic<T extends Number>
implements SampledStatistic<T> {
    private final ValueStatistic<T> source;
    private final StatisticHistory<T> history;
    private final StatisticType type;

    AbstractSampledStatistic(ValueStatistic<T> source, ScheduledExecutorService executor, int historySize, long historyPeriod, TimeUnit historyTimeUnit, StatisticType type) {
        this.source = source;
        this.type = type;
        this.history = new StatisticHistory<T>(source, executor, historySize, historyPeriod, historyTimeUnit);
    }

    @Override
    public T value() {
        return this.source.value();
    }

    @Override
    public List<Timestamped<T>> history() {
        return this.history.history();
    }

    @Override
    public List<Timestamped<T>> history(long since) {
        return this.history.history(since);
    }

    @Override
    public StatisticType type() {
        return this.type;
    }

    final void startSampling() {
        this.history.startSampling();
    }

    final void stopSampling() {
        this.history.stopSampling();
    }

    final void setHistory(int historySize, long historyPeriod, TimeUnit historyTimeUnit) {
        this.history.adjust(historySize, historyPeriod, historyTimeUnit);
    }
}

