/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.gpu;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.gpu.GpuDevice;
import org.apache.hadoop.yarn.server.nodemanager.webapp.dao.gpu.GpuDeviceInformation;
import org.apache.hadoop.yarn.server.nodemanager.webapp.dao.gpu.GpuDeviceInformationParser;
import org.apache.hadoop.yarn.server.nodemanager.webapp.dao.gpu.PerGpuDeviceInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class GpuDiscoverer {
    public static final Logger LOG = LoggerFactory.getLogger(GpuDiscoverer.class);
    @VisibleForTesting
    protected static final String DEFAULT_BINARY_NAME = "nvidia-smi";
    private static final Set<String> DEFAULT_BINARY_SEARCH_DIRS = ImmutableSet.of((Object)"/usr/bin", (Object)"/bin", (Object)"/usr/local/nvidia/bin");
    private static final int MAX_EXEC_TIMEOUT_MS = 10000;
    private static final int MAX_REPEATED_ERROR_ALLOWED = 10;
    private static GpuDiscoverer instance = new GpuDiscoverer();
    private Configuration conf = null;
    private String pathOfGpuBinary = null;
    private Map<String, String> environment = new HashMap<String, String>();
    private GpuDeviceInformationParser parser = new GpuDeviceInformationParser();
    private int numOfErrorExecutionSinceLastSucceed = 0;
    GpuDeviceInformation lastDiscoveredGpuInformation = null;

    private void validateConfOrThrowException() throws YarnException {
        if (this.conf == null) {
            throw new YarnException("Please initialize (call initialize) before use " + GpuDiscoverer.class.getSimpleName());
        }
    }

    public synchronized GpuDeviceInformation getGpuDeviceInformation() throws YarnException {
        this.validateConfOrThrowException();
        if (null == this.pathOfGpuBinary) {
            throw new YarnException("Failed to find GPU discovery executable, please double check yarn.nodemanager.resource-plugins.gpu.path-to-discovery-executables setting.");
        }
        if (this.numOfErrorExecutionSinceLastSucceed == 10) {
            String msg = "Failed to execute GPU device information detection script for 10 times, skip following executions.";
            LOG.error(msg);
            throw new YarnException(msg);
        }
        try {
            String output = Shell.execCommand(this.environment, (String[])new String[]{this.pathOfGpuBinary, "-x", "-q"}, (long)10000L);
            GpuDeviceInformation info = this.parser.parseXml(output);
            this.numOfErrorExecutionSinceLastSucceed = 0;
            this.lastDiscoveredGpuInformation = info;
            return info;
        }
        catch (IOException e) {
            ++this.numOfErrorExecutionSinceLastSucceed;
            String msg = "Failed to execute " + this.pathOfGpuBinary + " exception message:" + e.getMessage() + ", continue ...";
            if (LOG.isDebugEnabled()) {
                LOG.debug(msg);
            }
            throw new YarnException((Throwable)e);
        }
        catch (YarnException e) {
            ++this.numOfErrorExecutionSinceLastSucceed;
            String msg = "Failed to parse xml output" + e.getMessage();
            if (LOG.isDebugEnabled()) {
                LOG.warn(msg, (Throwable)e);
            }
            throw e;
        }
    }

    public synchronized List<GpuDevice> getGpusUsableByYarn() throws YarnException {
        this.validateConfOrThrowException();
        String allowedDevicesStr = this.conf.get("yarn.nodemanager.resource-plugins.gpu.allowed-gpu-devices", "auto");
        ArrayList<GpuDevice> gpuDevices = new ArrayList<GpuDevice>();
        if (allowedDevicesStr.equals("auto")) {
            if (null == this.lastDiscoveredGpuInformation) {
                String msg = "yarn.nodemanager.resource-plugins.gpu.allowed-gpu-devices is set to auto, however automatically discovering GPU information failed, please check NodeManager log for more details, as an alternative, admin can specify yarn.nodemanager.resource-plugins.gpu.allowed-gpu-devices manually to enable GPU isolation.";
                LOG.error(msg);
                throw new YarnException(msg);
            }
            if (this.lastDiscoveredGpuInformation.getGpus() != null) {
                for (int i = 0; i < this.lastDiscoveredGpuInformation.getGpus().size(); ++i) {
                    List<PerGpuDeviceInformation> gpuInfos = this.lastDiscoveredGpuInformation.getGpus();
                    gpuDevices.add(new GpuDevice(i, gpuInfos.get(i).getMinorNumber()));
                }
            }
        } else {
            for (String s : allowedDevicesStr.split(",")) {
                if (s.trim().length() <= 0) continue;
                String[] kv = s.trim().split(":");
                if (kv.length != 2) {
                    throw new YarnException("Illegal format, it should be index:minor_number format, now it=" + s);
                }
                gpuDevices.add(new GpuDevice(Integer.parseInt(kv[0]), Integer.parseInt(kv[1])));
            }
            LOG.info("Allowed GPU devices:" + gpuDevices);
        }
        return gpuDevices;
    }

    public synchronized void initialize(Configuration conf) throws YarnException {
        File binaryPath;
        this.conf = conf;
        this.numOfErrorExecutionSinceLastSucceed = 0;
        String pathToExecutable = conf.get("yarn.nodemanager.resource-plugins.gpu.path-to-discovery-executables", "");
        if (pathToExecutable.isEmpty()) {
            pathToExecutable = DEFAULT_BINARY_NAME;
        }
        if (!(binaryPath = new File(pathToExecutable)).exists()) {
            boolean found = false;
            for (String dir : DEFAULT_BINARY_SEARCH_DIRS) {
                binaryPath = new File(dir, DEFAULT_BINARY_NAME);
                if (!binaryPath.exists()) continue;
                found = true;
                this.pathOfGpuBinary = binaryPath.getAbsolutePath();
                break;
            }
            if (!found) {
                LOG.warn("Failed to locate binary at:" + binaryPath.getAbsolutePath() + ", please double check [" + "yarn.nodemanager.resource-plugins.gpu.path-to-discovery-executables" + "] setting. Now use default binary:" + DEFAULT_BINARY_NAME);
            }
        } else {
            if (binaryPath.isDirectory()) {
                binaryPath = new File(binaryPath, DEFAULT_BINARY_NAME);
                LOG.warn("Specified path is a directory, use nvidia-smi under the directory, updated path-to-executable:" + binaryPath.getAbsolutePath());
            }
            this.pathOfGpuBinary = binaryPath.getAbsolutePath();
        }
        try {
            LOG.info("Trying to discover GPU information ...");
            GpuDeviceInformation info = this.getGpuDeviceInformation();
            LOG.info(info.toString());
        }
        catch (YarnException e) {
            String msg = "Failed to discover GPU information from system, exception message:" + e.getMessage() + " continue...";
            LOG.warn(msg);
        }
    }

    @VisibleForTesting
    protected Map<String, String> getEnvironmentToRunCommand() {
        return this.environment;
    }

    @VisibleForTesting
    protected String getPathOfGpuBinary() {
        return this.pathOfGpuBinary;
    }

    public static GpuDiscoverer getInstance() {
        return instance;
    }
}

