/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper;

import io.hops.hadoop.shaded.org.apache.yetus.audience.InterfaceAudience;
import io.hops.hadoop.shaded.org.apache.zookeeper.Watcher;
import io.hops.hadoop.shaded.org.apache.zookeeper.proto.WatcherEvent;

@InterfaceAudience.Public
public class WatchedEvent {
    private final Watcher.Event.KeeperState keeperState;
    private final Watcher.Event.EventType eventType;
    private String path;

    public WatchedEvent(Watcher.Event.EventType eventType, Watcher.Event.KeeperState keeperState, String path) {
        this.keeperState = keeperState;
        this.eventType = eventType;
        this.path = path;
    }

    public WatchedEvent(WatcherEvent eventMessage) {
        this.keeperState = Watcher.Event.KeeperState.fromInt(eventMessage.getState());
        this.eventType = Watcher.Event.EventType.fromInt(eventMessage.getType());
        this.path = eventMessage.getPath();
    }

    public Watcher.Event.KeeperState getState() {
        return this.keeperState;
    }

    public Watcher.Event.EventType getType() {
        return this.eventType;
    }

    public String getPath() {
        return this.path;
    }

    public String toString() {
        return "WatchedEvent state:" + (Object)((Object)this.keeperState) + " type:" + (Object)((Object)this.eventType) + " path:" + this.path;
    }

    public WatcherEvent getWrapper() {
        return new WatcherEvent(this.eventType.getIntValue(), this.keeperState.getIntValue(), this.path);
    }
}

