/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.test;

import io.hops.hadoop.shaded.org.apache.zookeeper.PortAssignment;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.Election;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPeer;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.util.OSMXBean;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.JMXEnv;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuorumUtil {
    private static final Logger LOG = LoggerFactory.getLogger(QuorumUtil.class);
    private final Map<Long, QuorumPeer.QuorumServer> peersView = new HashMap<Long, QuorumPeer.QuorumServer>();
    private final Map<Integer, PeerStruct> peers = new HashMap<Integer, PeerStruct>();
    public final int N;
    public final int ALL;
    private String hostPort;
    private int tickTime;
    private int initLimit;
    private int syncLimit;
    private int electionAlg;

    public QuorumUtil(int n, int syncLimit) throws RuntimeException {
        try {
            PeerStruct ps;
            int i;
            ClientBase.setupTestEnv();
            JMXEnv.setUp();
            this.N = n;
            this.ALL = 2 * this.N + 1;
            this.tickTime = 2000;
            this.initLimit = 3;
            this.syncLimit = syncLimit;
            this.electionAlg = 3;
            this.hostPort = "";
            for (i = 1; i <= this.ALL; ++i) {
                ps = new PeerStruct();
                ps.id = i;
                ps.dataDir = ClientBase.createTmpDir();
                ps.clientPort = PortAssignment.unique();
                this.peers.put(i, ps);
                this.peersView.put(Long.valueOf(i), new QuorumPeer.QuorumServer(i, "127.0.0.1", ps.clientPort + 1000, PortAssignment.unique() + 1000, QuorumPeer.LearnerType.PARTICIPANT));
                this.hostPort = this.hostPort + "127.0.0.1:" + ps.clientPort + (i == this.ALL ? "" : ",");
            }
            for (i = 1; i <= this.ALL; ++i) {
                ps = this.peers.get(i);
                LOG.info("Creating QuorumPeer " + i + "; public port " + ps.clientPort);
                ps.peer = new QuorumPeer(this.peersView, ps.dataDir, ps.dataDir, ps.clientPort, this.electionAlg, (long)ps.id, this.tickTime, this.initLimit, syncLimit);
                Assert.assertEquals((long)ps.clientPort, (long)ps.peer.getClientPort());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public QuorumUtil(int n) throws RuntimeException {
        this(n, 3);
    }

    public PeerStruct getPeer(int id) {
        return this.peers.get(id);
    }

    public void startAll() throws IOException {
        this.shutdownAll();
        for (int i = 1; i <= this.ALL; ++i) {
            this.start(i);
            LOG.info("Started QuorumPeer " + i);
        }
        LOG.info("Checking ports " + this.hostPort);
        for (String hp : this.hostPort.split(",")) {
            Assert.assertTrue((String)"waiting for server up", (boolean)ClientBase.waitForServerUp(hp, ClientBase.CONNECTION_TIMEOUT));
            LOG.info(hp + " is accepting client connections");
        }
        try {
            int i;
            JMXEnv.dump();
            LinkedHashSet<String> ensureNames = new LinkedHashSet<String>();
            for (i = 1; i <= this.ALL; ++i) {
                ensureNames.add("InMemoryDataTree");
            }
            for (i = 1; i <= this.ALL; ++i) {
                ensureNames.add("name0=ReplicatedServer_id" + i + ",name1=replica." + i + ",name2=");
            }
            for (i = 1; i <= this.ALL; ++i) {
                for (int j = 1; j <= this.ALL; ++j) {
                    ensureNames.add("name0=ReplicatedServer_id" + i + ",name1=replica." + j);
                }
            }
            for (i = 1; i <= this.ALL; ++i) {
                ensureNames.add("name0=ReplicatedServer_id" + i);
            }
            JMXEnv.ensureAll(ensureNames.toArray(new String[ensureNames.size()]));
        }
        catch (IOException e) {
            LOG.warn("IOException during JMXEnv operation", (Throwable)e);
        }
        catch (InterruptedException e) {
            LOG.warn("InterruptedException during JMXEnv operation", (Throwable)e);
        }
    }

    public void startQuorum() throws IOException {
        int i;
        this.shutdownAll();
        for (i = 1; i <= this.N + 1; ++i) {
            this.start(i);
        }
        for (i = 1; i <= this.N + 1; ++i) {
            Assert.assertTrue((String)"Waiting for server up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.getPeer((int)i).clientPort, ClientBase.CONNECTION_TIMEOUT));
        }
    }

    public void start(int id) throws IOException {
        PeerStruct ps = this.getPeer(id);
        LOG.info("Creating QuorumPeer " + ps.id + "; public port " + ps.clientPort);
        ps.peer = new QuorumPeer(this.peersView, ps.dataDir, ps.dataDir, ps.clientPort, this.electionAlg, (long)ps.id, this.tickTime, this.initLimit, this.syncLimit);
        Assert.assertEquals((long)ps.clientPort, (long)ps.peer.getClientPort());
        ps.peer.start();
    }

    public void restart(int id) throws IOException {
        this.start(id);
        Assert.assertTrue((String)"Waiting for server up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.getPeer((int)id).clientPort, ClientBase.CONNECTION_TIMEOUT));
    }

    public void startThenShutdown(int id) throws IOException {
        PeerStruct ps = this.getPeer(id);
        LOG.info("Creating QuorumPeer " + ps.id + "; public port " + ps.clientPort);
        ps.peer = new QuorumPeer(this.peersView, ps.dataDir, ps.dataDir, ps.clientPort, this.electionAlg, (long)ps.id, this.tickTime, this.initLimit, this.syncLimit);
        Assert.assertEquals((long)ps.clientPort, (long)ps.peer.getClientPort());
        ps.peer.start();
        Assert.assertTrue((String)"Waiting for server up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.getPeer((int)id).clientPort, ClientBase.CONNECTION_TIMEOUT));
        this.shutdown(id);
    }

    public void shutdownAll() {
        for (int i = 1; i <= this.ALL; ++i) {
            this.shutdown(i);
        }
        for (String hp : this.hostPort.split(",")) {
            Assert.assertTrue((String)"Waiting for server down", (boolean)ClientBase.waitForServerDown(hp, ClientBase.CONNECTION_TIMEOUT));
            LOG.info(hp + " is no longer accepting client connections");
        }
    }

    public void shutdown(int id) {
        QuorumPeer qp = this.getPeer((int)id).peer;
        try {
            LOG.info("Shutting down quorum peer " + qp.getName());
            qp.shutdown();
            Election e = qp.getElectionAlg();
            if (e != null) {
                LOG.info("Shutting down leader election " + qp.getName());
                e.shutdown();
            } else {
                LOG.info("No election available to shutdown " + qp.getName());
            }
            LOG.info("Waiting for " + qp.getName() + " to exit thread");
            qp.join(30000L);
            if (qp.isAlive()) {
                Assert.fail((String)("QP failed to shutdown in 30 seconds: " + qp.getName()));
            }
        }
        catch (InterruptedException e) {
            LOG.debug("QP interrupted: " + qp.getName(), (Throwable)e);
        }
    }

    public String getConnString() {
        return this.hostPort;
    }

    public void tearDown() throws Exception {
        LOG.info("TearDown started");
        OSMXBean osMbean = new OSMXBean();
        if (osMbean.getUnix()) {
            LOG.info("fdcount after test is: " + osMbean.getOpenFileDescriptorCount());
        }
        this.shutdownAll();
        JMXEnv.tearDown();
    }

    public class PeerStruct {
        public int id;
        public QuorumPeer peer;
        public File dataDir;
        public int clientPort;
    }
}

