/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.test;

import io.hops.hadoop.shaded.org.apache.zookeeper.CreateMode;
import io.hops.hadoop.shaded.org.apache.zookeeper.TestableZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooDefs;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public class SaslAuthFailTest
extends ClientBase {
    @Test
    public void testAuthFail() throws Exception {
        TestableZooKeeper zk = this.createClient();
        try {
            zk.create("/path1", null, ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT);
            Assert.fail((String)"Should have gotten exception.");
        }
        catch (Exception e) {
            LOG.info("Got exception as expected: " + e);
        }
        finally {
            zk.close();
        }
    }

    static {
        System.setProperty("zookeeper.authProvider.1", "io.hops.hadoop.shaded.org.apache.zookeeper.server.auth.SASLAuthenticationProvider");
        System.setProperty("zookeeper.allowSaslFailedClients", "true");
        try {
            File tmpDir = SaslAuthFailTest.createTmpDir();
            File saslConfFile = new File(tmpDir, "jaas.conf");
            FileWriter fwriter = new FileWriter(saslConfFile);
            fwriter.write("Server {\n          org.apache.zookeeper.server.auth.DigestLoginModule required\n          user_super=\"test\";\n};\nClient {\n       org.apache.zookeeper.server.auth.DigestLoginModule required\n       username=\"super\"\n       password=\"test1\";\n};\n");
            fwriter.close();
            System.setProperty("java.security.auth.login.config", saslConfFile.getAbsolutePath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

