/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.test.system;

import io.hops.hadoop.shaded.org.apache.zookeeper.CreateMode;
import io.hops.hadoop.shaded.org.apache.zookeeper.KeeperException;
import io.hops.hadoop.shaded.org.apache.zookeeper.WatchedEvent;
import io.hops.hadoop.shaded.org.apache.zookeeper.Watcher;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooDefs;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.data.Stat;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.system.BaseSysTest;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.system.SimpleClient;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSysTest
extends BaseSysTest
implements Watcher {
    int maxTries = 10;
    boolean connected;
    private static final Logger LOG = LoggerFactory.getLogger(SimpleSysTest.class);

    private synchronized boolean waitForConnect(ZooKeeper zk, long timeout) throws InterruptedException {
        this.connected = zk.getState() == ZooKeeper.States.CONNECTED;
        long end = System.currentTimeMillis() + timeout;
        while (!this.connected && end > System.currentTimeMillis()) {
            this.wait(timeout);
            this.connected = zk.getState() == ZooKeeper.States.CONNECTED;
        }
        return this.connected;
    }

    @Test
    public void testSimpleCase() throws Exception {
        int i;
        int j;
        int i2;
        this.configureServers(this.serverCount);
        this.configureClients(this.clientCount, SimpleClient.class, this.getHostPort());
        Stat stat = new Stat();
        this.startServers();
        LOG.debug("Connecting to " + this.getHostPort());
        ZooKeeper zk = new ZooKeeper(this.getHostPort(), 15000, this);
        this.waitForConnect(zk, 10000L);
        zk.create("/simpleCase", "orig".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.startClients();
        for (i2 = 0; i2 < this.getClientCount(); ++i2) {
            for (j = 0; j < this.maxTries; ++j) {
                try {
                    byte[] b = zk.getData("/simpleCase/" + i2, false, stat);
                    SimpleSysTest.assertEquals((String)"orig", (String)new String(b));
                    continue;
                }
                catch (KeeperException.NoNodeException e) {
                    if (j + 1 == this.maxTries) {
                        SimpleSysTest.fail((String)("Max tries exceeded on client " + i2));
                    }
                    Thread.sleep(1000L);
                }
            }
        }
        for (i2 = 0; i2 < this.getServerCount(); ++i2) {
            this.stopServer(i2);
            if (i2 + 1 > this.getServerCount() / 2) {
                this.startServer(i2);
                continue;
            }
            if (i2 + 1 != this.getServerCount() / 2) continue;
            SimpleSysTest.assertTrue((String)"Connection didn't recover", (boolean)this.waitForConnect(zk, 10000L));
            try {
                zk.setData("/simpleCase", "new".getBytes(), -1);
            }
            catch (KeeperException.ConnectionLossException e) {
                SimpleSysTest.assertTrue((String)"Connection didn't recover", (boolean)this.waitForConnect(zk, 10000L));
                zk.setData("/simpleCase", "new".getBytes(), -1);
            }
            for (j = 0; j < i2; ++j) {
                LOG.info("Starting server " + j);
                this.startServer(i2);
            }
        }
        Thread.sleep(100L);
        SimpleSysTest.assertTrue((String)"Servers didn't bounce", (boolean)this.waitForConnect(zk, 15000L));
        try {
            zk.getData("/simpleCase", false, stat);
        }
        catch (KeeperException.ConnectionLossException e) {
            SimpleSysTest.assertTrue((String)"Servers didn't bounce", (boolean)this.waitForConnect(zk, 15000L));
        }
        for (i = 0; i < this.getClientCount(); ++i) {
            byte[] data;
            for (j = 0; j < this.maxTries && !new String(data = zk.getData("/simpleCase/" + i, false, stat)).equals("new"); ++j) {
                if (j + 1 == this.maxTries) {
                    SimpleSysTest.fail((String)("max tries exceeded for " + i));
                }
                Thread.sleep(1000L);
            }
        }
        zk.setData("/simpleCase", "die".getBytes(), -1);
        for (i = 0; i < this.getClientCount(); ++i) {
            try {
                for (int j2 = 0; j2 < this.maxTries; ++j2) {
                    zk.getData("/simpleCase/" + i, false, stat);
                    if (j2 + 1 == this.maxTries) {
                        SimpleSysTest.fail((String)("max tries exceeded waiting for child " + i + " to die"));
                    }
                    Thread.sleep(200L);
                }
                continue;
            }
            catch (KeeperException.NoNodeException noNodeException) {
                // empty catch block
            }
        }
        this.stopClients();
        this.stopServers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(WatchedEvent event) {
        if (event.getState() == Watcher.Event.KeeperState.SyncConnected) {
            SimpleSysTest simpleSysTest = this;
            synchronized (simpleSysTest) {
                this.connected = true;
                this.notifyAll();
            }
        }
        if (event.getState() == Watcher.Event.KeeperState.Disconnected) {
            SimpleSysTest simpleSysTest = this;
            synchronized (simpleSysTest) {
                this.connected = false;
                this.notifyAll();
            }
        }
    }
}

