/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.ehcache.impl.internal.statistics;

import io.hops.hadoop.shaded.org.ehcache.Cache;
import io.hops.hadoop.shaded.org.ehcache.core.statistics.StoreOperationOutcomes;
import io.hops.hadoop.shaded.org.ehcache.core.statistics.TierOperationOutcomes;
import io.hops.hadoop.shaded.org.ehcache.core.statistics.TierStatistics;
import io.hops.hadoop.shaded.org.ehcache.core.statistics.TypedValueStatistic;
import io.hops.hadoop.shaded.org.ehcache.impl.internal.statistics.StatsUtils;
import io.hops.hadoop.shaded.org.ehcache.impl.internal.statistics.ZeroOperationStatistic;
import io.hops.hadoop.shaded.org.terracotta.statistics.ConstantValueStatistic;
import io.hops.hadoop.shaded.org.terracotta.statistics.OperationStatistic;
import io.hops.hadoop.shaded.org.terracotta.statistics.ValueStatistic;
import io.hops.hadoop.shaded.org.terracotta.statistics.extended.StatisticType;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

class DefaultTierStatistics
implements TierStatistics {
    private static final ValueStatistic<Long> NOT_AVAILABLE = ConstantValueStatistic.instance(-1L);
    private volatile CompensatingCounters compensatingCounters = CompensatingCounters.empty();
    private final String tierName;
    private final Map<String, TypedValueStatistic> knownStatistics;
    private final OperationStatistic<TierOperationOutcomes.GetOutcome> get;
    private final OperationStatistic<StoreOperationOutcomes.PutOutcome> put;
    private final OperationStatistic<StoreOperationOutcomes.PutIfAbsentOutcome> putIfAbsent;
    private final OperationStatistic<StoreOperationOutcomes.ReplaceOutcome> replace;
    private final OperationStatistic<StoreOperationOutcomes.ConditionalReplaceOutcome> conditionalReplace;
    private final OperationStatistic<StoreOperationOutcomes.RemoveOutcome> remove;
    private final OperationStatistic<StoreOperationOutcomes.ConditionalRemoveOutcome> conditionalRemove;
    private final OperationStatistic<TierOperationOutcomes.EvictionOutcome> eviction;
    private final OperationStatistic<StoreOperationOutcomes.ExpirationOutcome> expiration;
    private final OperationStatistic<StoreOperationOutcomes.ComputeOutcome> compute;
    private final OperationStatistic<StoreOperationOutcomes.ComputeIfAbsentOutcome> computeIfAbsent;
    private final ValueStatistic<Long> mapping;
    private final ValueStatistic<Long> maxMapping;
    private final ValueStatistic<Long> allocatedMemory;
    private final ValueStatistic<Long> occupiedMemory;

    public DefaultTierStatistics(Cache<?, ?> cache, String tierName) {
        this.tierName = tierName;
        this.get = this.findOperationStatistic(cache, tierName, "tier", "get");
        this.put = this.findOperationStatistic(cache, tierName, "put");
        this.putIfAbsent = this.findOperationStatistic(cache, tierName, "putIfAbsent");
        this.replace = this.findOperationStatistic(cache, tierName, "replace");
        this.conditionalReplace = this.findOperationStatistic(cache, tierName, "conditionalReplace");
        this.remove = this.findOperationStatistic(cache, tierName, "remove");
        this.conditionalRemove = this.findOperationStatistic(cache, tierName, "conditionalRemove");
        this.eviction = this.findOperationStatistic(cache, tierName, "tier", "eviction");
        this.expiration = this.findOperationStatistic(cache, tierName, "expiration");
        this.compute = this.findOperationStatistic(cache, tierName, "compute");
        this.computeIfAbsent = this.findOperationStatistic(cache, tierName, "computeIfAbsent");
        this.mapping = this.findValueStatistics(cache, tierName, "mappings");
        this.maxMapping = this.findValueStatistics(cache, tierName, "maxMappings");
        this.allocatedMemory = this.findValueStatistics(cache, tierName, "allocatedMemory");
        this.occupiedMemory = this.findValueStatistics(cache, tierName, "occupiedMemory");
        Map<String, TypedValueStatistic> knownStatistics = this.createKnownStatistics(tierName);
        this.knownStatistics = Collections.unmodifiableMap(knownStatistics);
    }

    private Map<String, TypedValueStatistic> createKnownStatistics(String tierName) {
        HashMap<String, TypedValueStatistic> knownStatistics = new HashMap<String, TypedValueStatistic>(7);
        DefaultTierStatistics.addKnownStatistic(knownStatistics, tierName, "HitCount", this.get, new TypedValueStatistic(StatisticType.COUNTER){

            @Override
            public Number value() {
                return DefaultTierStatistics.this.getHits();
            }
        });
        DefaultTierStatistics.addKnownStatistic(knownStatistics, tierName, "MissCount", this.get, new TypedValueStatistic(StatisticType.COUNTER){

            @Override
            public Number value() {
                return DefaultTierStatistics.this.getMisses();
            }
        });
        DefaultTierStatistics.addKnownStatistic(knownStatistics, tierName, "PutCount", this.get, new TypedValueStatistic(StatisticType.COUNTER){

            @Override
            public Number value() {
                return DefaultTierStatistics.this.getPuts();
            }
        });
        DefaultTierStatistics.addKnownStatistic(knownStatistics, tierName, "UpdateCount", this.get, new TypedValueStatistic(StatisticType.COUNTER){

            @Override
            public Number value() {
                return DefaultTierStatistics.this.getUpdates();
            }
        });
        DefaultTierStatistics.addKnownStatistic(knownStatistics, tierName, "RemovalCount", this.get, new TypedValueStatistic(StatisticType.COUNTER){

            @Override
            public Number value() {
                return DefaultTierStatistics.this.getRemovals();
            }
        });
        DefaultTierStatistics.addKnownStatistic(knownStatistics, tierName, "EvictionCount", this.get, new TypedValueStatistic(StatisticType.COUNTER){

            @Override
            public Number value() {
                return DefaultTierStatistics.this.getEvictions();
            }
        });
        DefaultTierStatistics.addKnownStatistic(knownStatistics, tierName, "ExpirationCount", this.get, new TypedValueStatistic(StatisticType.COUNTER){

            @Override
            public Number value() {
                return DefaultTierStatistics.this.getExpirations();
            }
        });
        DefaultTierStatistics.addKnownStatistic(knownStatistics, tierName, "MappingCount", this.mapping, new TypedValueStatistic(StatisticType.COUNTER){

            @Override
            public Number value() {
                return DefaultTierStatistics.this.getMappings();
            }
        });
        DefaultTierStatistics.addKnownStatistic(knownStatistics, tierName, "MaxMappingCount", this.maxMapping, new TypedValueStatistic(StatisticType.COUNTER){

            @Override
            public Number value() {
                return DefaultTierStatistics.this.getMaxMappings();
            }
        });
        DefaultTierStatistics.addKnownStatistic(knownStatistics, tierName, "AllocatedByteSize", this.allocatedMemory, new TypedValueStatistic(StatisticType.SIZE){

            @Override
            public Number value() {
                return DefaultTierStatistics.this.getAllocatedByteSize();
            }
        });
        DefaultTierStatistics.addKnownStatistic(knownStatistics, tierName, "OccupiedByteSize", this.occupiedMemory, new TypedValueStatistic(StatisticType.SIZE){

            @Override
            public Number value() {
                return DefaultTierStatistics.this.getOccupiedByteSize();
            }
        });
        return knownStatistics;
    }

    @Override
    public Map<String, TypedValueStatistic> getKnownStatistics() {
        return this.knownStatistics;
    }

    private static void addKnownStatistic(Map<String, TypedValueStatistic> knownStatistics, String tierName, String name, Object stat, TypedValueStatistic statistic) {
        if (stat != NOT_AVAILABLE) {
            knownStatistics.put(tierName + ":" + name, statistic);
        }
    }

    private <T extends Enum<T>> OperationStatistic<T> findOperationStatistic(Cache<?, ?> cache, String tierName, String tag, String stat) {
        OperationStatistic s = (OperationStatistic)StatsUtils.findStatisticOnDescendants(cache, tierName, tag, stat);
        if (s == null) {
            return ZeroOperationStatistic.get();
        }
        return s;
    }

    private <T extends Enum<T>> OperationStatistic<T> findOperationStatistic(Cache<?, ?> cache, String tierName, String stat) {
        OperationStatistic s = (OperationStatistic)StatsUtils.findStatisticOnDescendants(cache, tierName, stat);
        if (s == null) {
            return ZeroOperationStatistic.get();
        }
        return s;
    }

    private ValueStatistic<Long> findValueStatistics(Cache<?, ?> cache, String tierName, String statName) {
        ValueStatistic stat = (ValueStatistic)StatsUtils.findStatisticOnDescendants(cache, tierName, statName);
        if (stat == null) {
            return NOT_AVAILABLE;
        }
        return stat;
    }

    @Override
    public void clear() {
        this.compensatingCounters = this.compensatingCounters.snapshot(this);
    }

    @Override
    public long getHits() {
        return this.get.sum(EnumSet.of(TierOperationOutcomes.GetOutcome.HIT)) + this.putIfAbsent.sum(EnumSet.of(StoreOperationOutcomes.PutIfAbsentOutcome.HIT)) + this.replace.sum(EnumSet.of(StoreOperationOutcomes.ReplaceOutcome.REPLACED)) + this.compute.sum(EnumSet.of(StoreOperationOutcomes.ComputeOutcome.HIT)) + this.computeIfAbsent.sum(EnumSet.of(StoreOperationOutcomes.ComputeIfAbsentOutcome.HIT)) + this.conditionalReplace.sum(EnumSet.of(StoreOperationOutcomes.ConditionalReplaceOutcome.REPLACED)) + this.conditionalRemove.sum(EnumSet.of(StoreOperationOutcomes.ConditionalRemoveOutcome.REMOVED)) - this.compensatingCounters.hits;
    }

    @Override
    public long getMisses() {
        return this.get.sum(EnumSet.of(TierOperationOutcomes.GetOutcome.MISS)) + this.putIfAbsent.sum(EnumSet.of(StoreOperationOutcomes.PutIfAbsentOutcome.PUT)) + this.replace.sum(EnumSet.of(StoreOperationOutcomes.ReplaceOutcome.MISS)) + this.computeIfAbsent.sum(EnumSet.of(StoreOperationOutcomes.ComputeIfAbsentOutcome.NOOP)) + this.conditionalReplace.sum(EnumSet.of(StoreOperationOutcomes.ConditionalReplaceOutcome.MISS)) + this.conditionalRemove.sum(EnumSet.of(StoreOperationOutcomes.ConditionalRemoveOutcome.MISS)) - this.compensatingCounters.misses;
    }

    @Override
    public long getPuts() {
        return this.put.sum(EnumSet.of(StoreOperationOutcomes.PutOutcome.PUT)) + this.putIfAbsent.sum(EnumSet.of(StoreOperationOutcomes.PutIfAbsentOutcome.PUT)) + this.put.sum(EnumSet.of(StoreOperationOutcomes.PutOutcome.REPLACED)) + this.compute.sum(EnumSet.of(StoreOperationOutcomes.ComputeOutcome.PUT)) + this.computeIfAbsent.sum(EnumSet.of(StoreOperationOutcomes.ComputeIfAbsentOutcome.PUT)) + this.replace.sum(EnumSet.of(StoreOperationOutcomes.ReplaceOutcome.REPLACED)) + this.conditionalReplace.sum(EnumSet.of(StoreOperationOutcomes.ConditionalReplaceOutcome.REPLACED)) - this.compensatingCounters.puts;
    }

    @Override
    public long getUpdates() {
        return this.put.sum(EnumSet.of(StoreOperationOutcomes.PutOutcome.REPLACED)) + this.replace.sum(EnumSet.of(StoreOperationOutcomes.ReplaceOutcome.REPLACED)) + this.conditionalReplace.sum(EnumSet.of(StoreOperationOutcomes.ConditionalReplaceOutcome.REPLACED)) - this.compensatingCounters.updates;
    }

    @Override
    public long getRemovals() {
        return this.remove.sum(EnumSet.of(StoreOperationOutcomes.RemoveOutcome.REMOVED)) + this.compute.sum(EnumSet.of(StoreOperationOutcomes.ComputeOutcome.REMOVED)) + this.conditionalRemove.sum(EnumSet.of(StoreOperationOutcomes.ConditionalRemoveOutcome.REMOVED)) - this.compensatingCounters.removals;
    }

    @Override
    public long getEvictions() {
        return this.eviction.sum(EnumSet.of(TierOperationOutcomes.EvictionOutcome.SUCCESS)) - this.compensatingCounters.evictions;
    }

    @Override
    public long getExpirations() {
        return this.expiration.sum() - this.compensatingCounters.expirations;
    }

    @Override
    public long getMappings() {
        return this.mapping.value();
    }

    @Override
    public long getMaxMappings() {
        return this.maxMapping.value();
    }

    @Override
    public long getAllocatedByteSize() {
        return this.allocatedMemory.value();
    }

    @Override
    public long getOccupiedByteSize() {
        return this.occupiedMemory.value();
    }

    private static class CompensatingCounters {
        final long hits;
        final long misses;
        final long puts;
        final long updates;
        final long removals;
        final long evictions;
        final long expirations;

        private CompensatingCounters(long hits, long misses, long puts, long updates, long removals, long evictions, long expirations) {
            this.hits = hits;
            this.misses = misses;
            this.puts = puts;
            this.updates = updates;
            this.removals = removals;
            this.evictions = evictions;
            this.expirations = expirations;
        }

        static CompensatingCounters empty() {
            return new CompensatingCounters(0L, 0L, 0L, 0L, 0L, 0L, 0L);
        }

        CompensatingCounters snapshot(DefaultTierStatistics statistics) {
            return new CompensatingCounters(statistics.getHits() + this.hits, statistics.getMisses() + this.misses, statistics.getPuts() + this.puts, statistics.getUpdates() + this.updates, statistics.getRemovals() + this.removals, statistics.getEvictions() + this.evictions, statistics.getExpirations() + this.expirations);
        }
    }
}

