/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.ehcache.impl.persistence;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.hops.hadoop.shaded.org.ehcache.CachePersistenceException;
import java.io.File;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FileUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtils.class);
    private static final Charset UTF8 = Charset.forName("UTF8");
    private static final int DEL = 127;
    private static final char ESCAPE = '%';
    private static final Set<Character> ILLEGALS = new HashSet<Character>();

    FileUtils() {
    }

    static void createLocationIfRequiredAndVerify(File rootDirectory) {
        if (!rootDirectory.exists()) {
            if (!rootDirectory.mkdirs()) {
                throw new IllegalArgumentException("Directory couldn't be created: " + rootDirectory.getAbsolutePath());
            }
        } else if (!rootDirectory.isDirectory()) {
            throw new IllegalArgumentException("Location is not a directory: " + rootDirectory.getAbsolutePath());
        }
        if (!rootDirectory.canWrite()) {
            throw new IllegalArgumentException("Location isn't writable: " + rootDirectory.getAbsolutePath());
        }
    }

    static File createSubDirectory(File mainDirectory, String name) throws CachePersistenceException {
        FileUtils.validateName(name);
        File subDirectory = new File(mainDirectory, name);
        FileUtils.create(subDirectory);
        return subDirectory;
    }

    static void validateName(String name) {
        if (!name.matches("[a-zA-Z0-9\\-_]+")) {
            throw new IllegalArgumentException("Name is invalid for persistence context: " + name);
        }
    }

    static void create(File directory) throws CachePersistenceException {
        if (directory.isDirectory()) {
            LOGGER.debug("Reusing {}", (Object)directory.getAbsolutePath());
        } else if (directory.mkdir()) {
            LOGGER.debug("Created {}", (Object)directory.getAbsolutePath());
        } else if (directory.isDirectory()) {
            LOGGER.debug("Reusing {}", (Object)directory.getAbsolutePath());
        } else {
            throw new CachePersistenceException("Unable to create or reuse directory: " + directory.getAbsolutePath());
        }
    }

    static boolean recursiveDeleteDirectoryContent(File file) {
        File[] contents = file.listFiles();
        if (contents == null) {
            throw new IllegalArgumentException("File " + file.getAbsolutePath() + " is not a directory");
        }
        boolean deleteSuccessful = true;
        for (File f : contents) {
            deleteSuccessful &= FileUtils.tryRecursiveDelete(f);
        }
        return deleteSuccessful;
    }

    private static boolean recursiveDelete(File file) {
        ArrayDeque<File> toDelete = new ArrayDeque<File>();
        toDelete.push(file);
        while (!toDelete.isEmpty()) {
            File target = (File)toDelete.pop();
            File[] contents = target.listFiles();
            if (contents == null || contents.length == 0) {
                if (!target.exists() || target.delete()) continue;
                return false;
            }
            toDelete.push(target);
            for (File f : contents) {
                toDelete.push(f);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"DM_GC"})
    static boolean tryRecursiveDelete(File file) {
        boolean interrupted = false;
        try {
            for (int i = 0; i < 5; ++i) {
                if (FileUtils.recursiveDelete(file) || !FileUtils.isWindows()) {
                    boolean bl = true;
                    return bl;
                }
                System.gc();
                System.runFinalization();
                try {
                    Thread.sleep(50L);
                    continue;
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        return false;
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows");
    }

    static String safeIdentifier(String name) {
        return FileUtils.safeIdentifier(name, true);
    }

    static String safeIdentifier(String name, boolean withSha1) {
        int len = name.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = name.charAt(i);
            if (c <= ' ' || c >= '\u007f' || ILLEGALS.contains(Character.valueOf(c)) || c == '%') {
                sb.append('%');
                sb.append(String.format("%04x", c));
                continue;
            }
            sb.append(c);
        }
        if (withSha1) {
            sb.append("_").append(FileUtils.sha1(name));
        }
        return sb.toString();
    }

    private static String sha1(String input) {
        StringBuilder sb = new StringBuilder();
        for (byte b : FileUtils.getSha1Digest().digest(input.getBytes(UTF8))) {
            sb.append(Integer.toHexString((b & 0xF0) >>> 4));
            sb.append(Integer.toHexString(b & 0xF));
        }
        return sb.toString();
    }

    private static MessageDigest getSha1Digest() {
        try {
            return MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)"All JDKs must have SHA-1");
        }
    }

    static {
        ILLEGALS.add(Character.valueOf('/'));
        ILLEGALS.add(Character.valueOf('\\'));
        ILLEGALS.add(Character.valueOf('<'));
        ILLEGALS.add(Character.valueOf('>'));
        ILLEGALS.add(Character.valueOf(':'));
        ILLEGALS.add(Character.valueOf('\"'));
        ILLEGALS.add(Character.valueOf('|'));
        ILLEGALS.add(Character.valueOf('?'));
        ILLEGALS.add(Character.valueOf('*'));
        ILLEGALS.add(Character.valueOf('.'));
    }
}

