/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.glassfish.grizzly.nio.transport;

import io.hops.hadoop.shaded.org.glassfish.grizzly.Buffer;
import io.hops.hadoop.shaded.org.glassfish.grizzly.CompletionHandler;
import io.hops.hadoop.shaded.org.glassfish.grizzly.Connection;
import io.hops.hadoop.shaded.org.glassfish.grizzly.IOEvent;
import io.hops.hadoop.shaded.org.glassfish.grizzly.Interceptor;
import io.hops.hadoop.shaded.org.glassfish.grizzly.ReadResult;
import io.hops.hadoop.shaded.org.glassfish.grizzly.asyncqueue.AsyncReadQueueRecord;
import io.hops.hadoop.shaded.org.glassfish.grizzly.nio.AbstractNIOAsyncQueueReader;
import io.hops.hadoop.shaded.org.glassfish.grizzly.nio.NIOConnection;
import io.hops.hadoop.shaded.org.glassfish.grizzly.nio.NIOTransport;
import io.hops.hadoop.shaded.org.glassfish.grizzly.nio.transport.TCPNIOConnection;
import io.hops.hadoop.shaded.org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import java.io.IOException;
import java.net.SocketAddress;

public final class TCPNIOAsyncQueueReader
extends AbstractNIOAsyncQueueReader {
    public TCPNIOAsyncQueueReader(NIOTransport transport) {
        super(transport);
    }

    @Override
    protected int read0(Connection connection, Buffer buffer, ReadResult<Buffer, SocketAddress> currentResult) throws IOException {
        int oldPosition = buffer != null ? buffer.position() : 0;
        if ((buffer = ((TCPNIOTransport)this.transport).read(connection, buffer)) != null) {
            int readBytes = buffer.position() - oldPosition;
            currentResult.setMessage(buffer);
            currentResult.setReadSize(currentResult.getReadSize() + readBytes);
            currentResult.setSrcAddress((SocketAddress)connection.getPeerAddress());
            return readBytes;
        }
        return 0;
    }

    protected void addRecord(Connection connection, Buffer buffer, CompletionHandler completionHandler, Interceptor<ReadResult> interceptor) {
        AsyncReadQueueRecord record = AsyncReadQueueRecord.create(connection, buffer, ReadResult.create(connection), completionHandler, interceptor);
        ((TCPNIOConnection)connection).getAsyncReadQueue().offer(record);
    }

    @Override
    protected final void onReadyToRead(Connection connection) throws IOException {
        NIOConnection nioConnection = (NIOConnection)connection;
        nioConnection.enableIOEvent(IOEvent.READ);
    }
}

