/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.glassfish.grizzly.nio.transport;

import io.hops.hadoop.shaded.org.glassfish.grizzly.AbstractBindingHandler;
import io.hops.hadoop.shaded.org.glassfish.grizzly.nio.NIOConnection;
import io.hops.hadoop.shaded.org.glassfish.grizzly.nio.transport.TCPNIOConnection;
import io.hops.hadoop.shaded.org.glassfish.grizzly.nio.transport.TCPNIOServerConnection;
import io.hops.hadoop.shaded.org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import io.hops.hadoop.shaded.org.glassfish.grizzly.utils.Exceptions;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class TCPNIOBindingHandler
extends AbstractBindingHandler<TCPNIOServerConnection> {
    private final TCPNIOTransport tcpTransport;

    TCPNIOBindingHandler(TCPNIOTransport tcpTransport) {
        super(tcpTransport);
        this.tcpTransport = tcpTransport;
    }

    @Override
    public TCPNIOServerConnection bind(SocketAddress socketAddress) throws IOException {
        return this.bind(socketAddress, this.tcpTransport.getServerConnectionBackLog());
    }

    @Override
    public TCPNIOServerConnection bind(SocketAddress socketAddress, int backlog) throws IOException {
        return this.bindToChannelAndAddress(this.tcpTransport.getSelectorProvider().openServerSocketChannel(), socketAddress, backlog);
    }

    @Override
    public TCPNIOServerConnection bindToInherited() throws IOException {
        return this.bindToChannelAndAddress((ServerSocketChannel)this.getSystemInheritedChannel(ServerSocketChannel.class), null, -1);
    }

    @Override
    public void unbind(TCPNIOServerConnection connection) throws IOException {
        this.tcpTransport.unbind(connection);
    }

    public static Builder builder(TCPNIOTransport transport) {
        return new Builder(transport);
    }

    private TCPNIOServerConnection bindToChannelAndAddress(ServerSocketChannel serverSocketChannel, SocketAddress socketAddress, int backlog) throws IOException {
        NIOConnection serverConnection = null;
        ReentrantReadWriteLock.WriteLock lock = this.tcpTransport.getState().getStateLocker().writeLock();
        lock.lock();
        try {
            ServerSocket serverSocket = serverSocketChannel.socket();
            serverSocket.setReuseAddress(this.tcpTransport.reuseAddress);
            serverSocket.setSoTimeout(this.tcpTransport.serverSocketSoTimeout);
            if (socketAddress != null) {
                serverSocket.bind(socketAddress, backlog);
            }
            serverSocketChannel.configureBlocking(false);
            serverConnection = this.tcpTransport.obtainServerNIOConnection(serverSocketChannel);
            serverConnection.setProcessor(this.getProcessor());
            serverConnection.setProcessorSelector(this.getProcessorSelector());
            this.tcpTransport.serverConnections.add((TCPNIOServerConnection)serverConnection);
            ((TCPNIOConnection)serverConnection).resetProperties();
            if (!this.tcpTransport.isStopped()) {
                this.tcpTransport.listenServerConnection((TCPNIOServerConnection)serverConnection);
            }
            NIOConnection nIOConnection = serverConnection;
            return nIOConnection;
        }
        catch (Exception e) {
            if (serverConnection != null) {
                this.tcpTransport.serverConnections.remove(serverConnection);
                serverConnection.closeSilently();
            } else {
                try {
                    serverSocketChannel.close();
                }
                catch (IOException ignored) {
                    // empty catch block
                }
            }
            throw Exceptions.makeIOException(e);
        }
        finally {
            lock.unlock();
        }
    }

    public static class Builder
    extends AbstractBindingHandler.Builder<Builder> {
        public Builder(TCPNIOTransport transport) {
            super(new TCPNIOBindingHandler(transport));
        }

        public TCPNIOBindingHandler build() {
            return (TCPNIOBindingHandler)this.bindingHandler;
        }
    }
}

