/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.glassfish.grizzly.servlet;

import io.hops.hadoop.shaded.javax.servlet.Filter;
import io.hops.hadoop.shaded.javax.servlet.FilterConfig;
import io.hops.hadoop.shaded.javax.servlet.RequestDispatcher;
import io.hops.hadoop.shaded.javax.servlet.Servlet;
import io.hops.hadoop.shaded.javax.servlet.ServletConfig;
import io.hops.hadoop.shaded.javax.servlet.ServletContext;
import io.hops.hadoop.shaded.javax.servlet.ServletContextAttributeEvent;
import io.hops.hadoop.shaded.javax.servlet.ServletContextAttributeListener;
import io.hops.hadoop.shaded.javax.servlet.ServletContextEvent;
import io.hops.hadoop.shaded.javax.servlet.ServletContextListener;
import io.hops.hadoop.shaded.javax.servlet.ServletException;
import io.hops.hadoop.shaded.javax.servlet.SingleThreadModel;
import io.hops.hadoop.shaded.org.glassfish.grizzly.Grizzly;
import io.hops.hadoop.shaded.org.glassfish.grizzly.http.server.HttpHandler;
import io.hops.hadoop.shaded.org.glassfish.grizzly.http.server.HttpServer;
import io.hops.hadoop.shaded.org.glassfish.grizzly.http.server.ServerConfiguration;
import io.hops.hadoop.shaded.org.glassfish.grizzly.http.server.StaticHttpHandler;
import io.hops.hadoop.shaded.org.glassfish.grizzly.http.server.util.ClassLoaderUtil;
import io.hops.hadoop.shaded.org.glassfish.grizzly.http.server.util.DispatcherHelper;
import io.hops.hadoop.shaded.org.glassfish.grizzly.http.server.util.Enumerator;
import io.hops.hadoop.shaded.org.glassfish.grizzly.http.server.util.Mapper;
import io.hops.hadoop.shaded.org.glassfish.grizzly.http.server.util.MappingData;
import io.hops.hadoop.shaded.org.glassfish.grizzly.http.server.util.MimeType;
import io.hops.hadoop.shaded.org.glassfish.grizzly.http.util.DataChunk;
import io.hops.hadoop.shaded.org.glassfish.grizzly.localization.LogMessages;
import io.hops.hadoop.shaded.org.glassfish.grizzly.servlet.DefaultServlet;
import io.hops.hadoop.shaded.org.glassfish.grizzly.servlet.FilterChainFactory;
import io.hops.hadoop.shaded.org.glassfish.grizzly.servlet.FilterConfigImpl;
import io.hops.hadoop.shaded.org.glassfish.grizzly.servlet.FilterRegistration;
import io.hops.hadoop.shaded.org.glassfish.grizzly.servlet.RequestDispatcherImpl;
import io.hops.hadoop.shaded.org.glassfish.grizzly.servlet.ServletConfigImpl;
import io.hops.hadoop.shaded.org.glassfish.grizzly.servlet.ServletHandler;
import io.hops.hadoop.shaded.org.glassfish.grizzly.servlet.ServletRegistration;
import io.hops.hadoop.shaded.org.glassfish.grizzly.servlet.ServletUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WebappContext
implements ServletContext {
    private static final Logger LOGGER = Grizzly.logger(WebappContext.class);
    private static final Map<WebappContext, HttpServer> DEPLOYED_APPS = new HashMap<WebappContext, HttpServer>();
    private static final int MAJOR_VERSION = 2;
    private static final int MINOR_VERSION = 5;
    private final String displayName;
    private final String contextPath;
    private final String basePath;
    private Map<String, String> contextInitParams;
    private Map<String, ServletRegistration> servletRegistrations;
    private LinkedHashMap<String, FilterRegistration> filterRegistrations;
    private Set<ServletHandler> servletHandlers;
    private Set<Class<? extends EventListener>> eventListenerClasses;
    private Set<String> eventListenerClassNames;
    private EventListener[] eventListeners = new EventListener[0];
    protected boolean deployed;
    private FilterChainFactory filterChainFactory;
    private final ConcurrentHashMap<String, Object> attributes = new ConcurrentHashMap(16, 0.75f, 64);
    private volatile String serverInfo = "Grizzly " + Grizzly.getDotedVersion();
    private ThreadLocal<DispatchData> dispatchData = new ThreadLocal();
    private DispatcherHelper dispatcherHelper;
    private final Runnable onDestroyListener = new Runnable(){

        @Override
        public void run() {
            if (WebappContext.this.deployed) {
                WebappContext.this.undeploy();
            }
        }
    };

    protected WebappContext() {
        this.displayName = "";
        this.contextPath = "";
        this.basePath = "";
    }

    public WebappContext(String displayName) {
        this(displayName, "");
    }

    public WebappContext(String displayName, String contextPath) {
        this(displayName, contextPath, ".");
    }

    public WebappContext(String displayName, String contextPath, String basePath) {
        if (displayName == null || displayName.length() == 0) {
            throw new IllegalArgumentException("'displayName' cannot be null or zero-length");
        }
        if (contextPath == null) {
            throw new IllegalArgumentException("'contextPath' cannot be null");
        }
        if (contextPath.length() > 0) {
            if (contextPath.charAt(0) != '/') {
                throw new IllegalArgumentException("'contextPath' must start with a forward slash");
            }
            if (!contextPath.equals("/") && contextPath.charAt(contextPath.length() - 1) == '/') {
                throw new IllegalArgumentException("'contextPath' must not end with a forward slash");
            }
        }
        this.displayName = displayName;
        this.contextPath = contextPath;
        this.basePath = basePath;
        this.contextInitParams = new LinkedHashMap<String, String>(8, 1.0f);
        this.servletRegistrations = new HashMap<String, ServletRegistration>(8, 1.0f);
        this.filterRegistrations = new LinkedHashMap(4, 1.0f);
        this.eventListenerClasses = new LinkedHashSet<Class<? extends EventListener>>(4, 1.0f);
        this.eventListenerClassNames = new LinkedHashSet<String>(4, 1.0f);
        Mapper.setAllowReplacement(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deploy(HttpServer targetServer) {
        if (!this.deployed) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "Starting application [{0}] ...", this.displayName);
            }
            this.filterChainFactory = new FilterChainFactory(this, this.filterRegistrations.values());
            boolean error = false;
            try {
                this.initializeListeners();
                this.contextInitialized();
                this.initServlets(targetServer);
                this.initFilters();
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, "Application [{0}] is ready to service requests.  Root: [{1}].", new Object[]{this.displayName, this.contextPath});
                }
                DEPLOYED_APPS.put(this, targetServer);
                this.deployed = true;
            }
            catch (Exception e) {
                error = true;
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, "[" + this.displayName + "] Exception deploying application.  See stack trace for details.", e);
                }
            }
            finally {
                if (error) {
                    this.undeploy();
                }
            }
        }
    }

    public synchronized void undeploy() {
        block3: {
            try {
                if (this.deployed) {
                    this.deployed = false;
                    HttpServer server = DEPLOYED_APPS.remove(this);
                    this.destoryServlets(server);
                    this.destroyFilters();
                    this.contextDestroyed();
                }
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block3;
                LOGGER.log(Level.SEVERE, "[" + this.displayName + "] Exception undeploying application.  See stack trace for details.", e);
            }
        }
    }

    public void addContextInitParameter(String name, String value) {
        if (!this.deployed) {
            this.contextInitParams.put(name, value);
        }
    }

    public void removeContextInitParameter(String name) {
        if (!this.deployed) {
            this.contextInitParams.remove(name);
        }
    }

    public void clearContextInitParameters() {
        if (!this.deployed) {
            this.contextInitParams.clear();
        }
    }

    public FilterRegistration addFilter(String filterName, Class<? extends Filter> filterClass) {
        if (this.deployed) {
            throw new IllegalArgumentException("WebappContext has already been deployed");
        }
        if (filterName == null) {
            throw new IllegalArgumentException("'filterName' cannot be null");
        }
        if (filterClass == null) {
            throw new IllegalArgumentException("'filterClass' cannot be null");
        }
        FilterRegistration registration = this.filterRegistrations.get(filterName);
        if (registration == null) {
            registration = new FilterRegistration(this, filterName, filterClass);
            this.filterRegistrations.put(filterName, registration);
        } else if (registration.filterClass != filterClass) {
            registration.filter = null;
            registration.filterClass = filterClass;
            registration.className = filterClass.getName();
        }
        return registration;
    }

    public FilterRegistration addFilter(String filterName, Filter filter) {
        if (this.deployed) {
            throw new IllegalArgumentException("WebappContext has already been deployed");
        }
        if (filterName == null) {
            throw new IllegalArgumentException("'filterName' cannot be null");
        }
        if (filter == null) {
            throw new IllegalArgumentException("'filter' cannot be null");
        }
        FilterRegistration registration = this.filterRegistrations.get(filterName);
        if (registration == null) {
            registration = new FilterRegistration(this, filterName, filter);
            this.filterRegistrations.put(filterName, registration);
        } else if (registration.filter != filter) {
            registration.filter = filter;
            registration.filterClass = filter.getClass();
            registration.className = filter.getClass().getName();
        }
        return registration;
    }

    public FilterRegistration addFilter(String filterName, String className) {
        if (this.deployed) {
            throw new IllegalArgumentException("WebappContext has already been deployed");
        }
        if (filterName == null) {
            throw new IllegalArgumentException("'filterName' cannot be null");
        }
        if (className == null) {
            throw new IllegalArgumentException("'className' cannot be null");
        }
        FilterRegistration registration = this.filterRegistrations.get(filterName);
        if (registration == null) {
            registration = new FilterRegistration(this, filterName, className);
            this.filterRegistrations.put(filterName, registration);
        } else if (!registration.className.equals(className)) {
            registration.className = className;
            registration.filterClass = null;
            registration.filter = null;
        }
        return registration;
    }

    public ServletRegistration addServlet(String servletName, Class<? extends Servlet> servletClass) {
        if (this.deployed) {
            throw new IllegalArgumentException("WebappContext has already been deployed");
        }
        if (servletName == null) {
            throw new IllegalArgumentException("'servletName' cannot be null");
        }
        if (servletClass == null) {
            throw new IllegalArgumentException("'servletClass' cannot be null");
        }
        ServletRegistration registration = this.servletRegistrations.get(servletName);
        if (registration == null) {
            registration = new ServletRegistration(this, servletName, servletClass);
            this.servletRegistrations.put(servletName, registration);
        } else if (registration.servletClass != servletClass) {
            registration.servlet = null;
            registration.servletClass = servletClass;
            registration.className = servletClass.getName();
        }
        return registration;
    }

    public ServletRegistration addServlet(String servletName, Servlet servlet) {
        if (this.deployed) {
            throw new IllegalArgumentException("WebappContext has already been deployed");
        }
        if (servletName == null) {
            throw new IllegalArgumentException("'servletName' cannot be null");
        }
        if (servlet == null) {
            throw new IllegalArgumentException("'servlet' cannot be null");
        }
        if (servlet instanceof SingleThreadModel) {
            throw new IllegalArgumentException("SingleThreadModel Servlet instances are not allowed.");
        }
        ServletRegistration registration = this.servletRegistrations.get(servletName);
        if (registration == null) {
            registration = new ServletRegistration(this, servletName, servlet);
            this.servletRegistrations.put(servletName, registration);
        } else if (registration.servlet != servlet) {
            registration.servlet = servlet;
            registration.servletClass = servlet.getClass();
            registration.className = servlet.getClass().getName();
        }
        return registration;
    }

    public ServletRegistration addServlet(String servletName, String className) {
        if (this.deployed) {
            throw new IllegalArgumentException("WebappContext has already been deployed");
        }
        if (servletName == null) {
            throw new IllegalArgumentException("'servletName' cannot be null");
        }
        if (className == null) {
            throw new IllegalArgumentException("'className' cannot be null");
        }
        ServletRegistration registration = this.servletRegistrations.get(servletName);
        if (registration == null) {
            registration = new ServletRegistration(this, servletName, className);
            this.servletRegistrations.put(servletName, registration);
        } else if (!registration.className.equals(className)) {
            registration.servlet = null;
            registration.servletClass = null;
            registration.className = className;
        }
        return registration;
    }

    public FilterRegistration getFilterRegistration(String name) {
        if (name == null) {
            return null;
        }
        return this.filterRegistrations.get(name);
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        return Collections.unmodifiableMap(this.filterRegistrations);
    }

    public ServletRegistration getServletRegistration(String name) {
        if (name == null) {
            return null;
        }
        return this.servletRegistrations.get(name);
    }

    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        return Collections.unmodifiableMap(this.servletRegistrations);
    }

    public void addListener(Class<? extends EventListener> listener) {
        if (this.deployed) {
            throw new IllegalStateException("WebappContext has already been deployed");
        }
        if (listener == null) {
            throw new IllegalArgumentException("'listener' cannot be null");
        }
        this.eventListenerClasses.add(listener);
    }

    public void addListener(String className) {
        if (this.deployed) {
            throw new IllegalStateException("WebappContext has already been deployed");
        }
        if (className == null) {
            throw new IllegalArgumentException("'className' cannot be null");
        }
        this.eventListenerClassNames.add(className);
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public ServletContext getContext(String uri) {
        if (uri == null || !uri.startsWith("/")) {
            return null;
        }
        if (this.dispatcherHelper == null) {
            return null;
        }
        DispatchData dd = this.dispatchData.get();
        if (dd == null) {
            dd = new DispatchData();
            this.dispatchData.set(dd);
        } else {
            dd.recycle();
        }
        DataChunk uriDC = dd.uriDC;
        MappingData mappingData = dd.mappingData;
        try {
            uriDC.setString(uri);
            this.dispatcherHelper.mapPath(dd.hostDC, uriDC, mappingData);
            if (mappingData.context == null) {
                return null;
            }
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "Error during mapping", e);
            }
            return null;
        }
        if (!(mappingData.context instanceof ServletHandler)) {
            return null;
        }
        ServletHandler context = (ServletHandler)mappingData.context;
        return context.getServletCtx();
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 5;
    }

    public String getMimeType(String file) {
        if (file == null) {
            return null;
        }
        int period = file.lastIndexOf(".");
        if (period < 0) {
            return null;
        }
        String extension = file.substring(period + 1);
        if (extension.length() < 1) {
            return null;
        }
        return MimeType.get(extension);
    }

    public Set getResourcePaths(String path) {
        if (path == null) {
            return null;
        }
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException(path);
        }
        if ((path = this.normalize(path)) == null) {
            return null;
        }
        File[] files = new File(this.basePath, path).listFiles();
        Set set = Collections.emptySet();
        if (files != null) {
            set = new HashSet(files.length);
            for (File f : files) {
                try {
                    String canonicalPath = f.getCanonicalPath();
                    if (f.isDirectory()) {
                        canonicalPath = canonicalPath + "/";
                    }
                    canonicalPath = canonicalPath.substring(canonicalPath.indexOf(this.basePath) + this.basePath.length());
                    set.add(canonicalPath.replace("\\", "/"));
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        return set;
    }

    public URL getResource(String path) throws MalformedURLException {
        if (path == null || !path.startsWith("/")) {
            throw new MalformedURLException(path);
        }
        if ((path = this.normalize(path)) == null) {
            return null;
        }
        if (path.length() > 1) {
            path = path.substring(1);
        }
        return Thread.currentThread().getContextClassLoader().getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        String pathLocal = this.normalize(path);
        if (pathLocal == null) {
            return null;
        }
        if (pathLocal.length() > 1) {
            pathLocal = pathLocal.substring(1);
        }
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(pathLocal);
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (path == null) {
            return null;
        }
        if (this.dispatcherHelper == null) {
            return null;
        }
        if (!path.startsWith("/") && !path.isEmpty()) {
            throw new IllegalArgumentException("Path " + path + " does not start with ''/'' and is not empty");
        }
        String queryString = null;
        int pos = path.indexOf(63);
        if (pos >= 0) {
            queryString = path.substring(pos + 1);
            path = path.substring(0, pos);
        }
        if ((path = this.normalize(path)) == null) {
            return null;
        }
        DispatchData dd = this.dispatchData.get();
        if (dd == null) {
            dd = new DispatchData();
            this.dispatchData.set(dd);
        } else {
            dd.recycle();
        }
        DataChunk uriDC = dd.uriDC;
        MappingData mappingData = dd.mappingData;
        try {
            if (this.contextPath.length() == 1 && this.contextPath.charAt(0) == '/') {
                uriDC.setString(path);
            } else {
                uriDC.setString(this.contextPath + path);
            }
            this.dispatcherHelper.mapPath(dd.hostDC, uriDC, mappingData);
            if (mappingData.wrapper == null) {
                return null;
            }
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "Error during mapping", e);
            }
            return null;
        }
        if (!(mappingData.wrapper instanceof ServletHandler)) {
            return null;
        }
        ServletHandler wrapper = (ServletHandler)mappingData.wrapper;
        String wrapperPath = mappingData.wrapperPath.toString();
        String pathInfo = mappingData.pathInfo.toString();
        return new RequestDispatcherImpl(wrapper, uriDC.toString(), wrapperPath, pathInfo, queryString, null);
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        if (name == null) {
            return null;
        }
        if (this.dispatcherHelper == null) {
            return null;
        }
        DispatchData dd = this.dispatchData.get();
        if (dd == null) {
            dd = new DispatchData();
            this.dispatchData.set(dd);
        } else {
            dd.recycle();
        }
        DataChunk servletNameDC = dd.servletNameDC;
        MappingData mappingData = dd.mappingData;
        servletNameDC.setString(name);
        try {
            this.dispatcherHelper.mapName(servletNameDC, mappingData);
            if (!(mappingData.wrapper instanceof ServletHandler)) {
                return null;
            }
            ServletHandler h = (ServletHandler)mappingData.wrapper;
            if (!this.contextPath.equals(h.getContextPath())) {
                return null;
            }
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "Error during mapping", e);
            }
            return null;
        }
        ServletHandler wrapper = (ServletHandler)mappingData.wrapper;
        return new RequestDispatcherImpl(wrapper, null, null, null, null, name);
    }

    @Deprecated
    public Servlet getServlet(String name) throws ServletException {
        return null;
    }

    @Deprecated
    public Enumeration getServlets() {
        return new Enumerator(Collections.emptyList());
    }

    @Deprecated
    public Enumeration getServletNames() {
        return new Enumerator(Collections.emptyList());
    }

    public void log(String message) {
        LOGGER.log(Level.INFO, String.format("[%s] %s", this.displayName, message));
    }

    @Deprecated
    public void log(Exception e, String message) {
        this.log(message, e);
    }

    public void log(String message, Throwable throwable) {
        LOGGER.log(Level.INFO, String.format("[%s] %s", this.displayName, message), throwable);
    }

    public String getRealPath(String path) {
        if (path == null) {
            return null;
        }
        return new File(this.basePath, path).getAbsolutePath();
    }

    public String getServerInfo() {
        return this.serverInfo;
    }

    public String getInitParameter(String name) {
        return this.contextInitParams.get(name);
    }

    public Enumeration getInitParameterNames() {
        return new Enumerator<String>((Collection<String>)this.contextInitParams.keySet());
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return new Enumerator(this.attributes.keySet());
    }

    public void setAttribute(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("Cannot be null");
        }
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        Object oldValue = this.attributes.put(name, value);
        ServletContextAttributeEvent event = null;
        int len = this.eventListeners.length;
        for (int i = 0; i < len; ++i) {
            if (!(this.eventListeners[i] instanceof ServletContextAttributeListener)) continue;
            ServletContextAttributeListener listener = (ServletContextAttributeListener)this.eventListeners[i];
            try {
                if (event == null) {
                    event = oldValue != null ? new ServletContextAttributeEvent((ServletContext)this, name, oldValue) : new ServletContextAttributeEvent((ServletContext)this, name, value);
                }
                if (oldValue != null) {
                    listener.attributeReplaced(event);
                    continue;
                }
                listener.attributeAdded(event);
                continue;
            }
            catch (Throwable t) {
                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_HTTP_SERVLET_ATTRIBUTE_LISTENER_ADD_ERROR("ServletContextAttributeListener", listener.getClass().getName()), t);
            }
        }
    }

    public void removeAttribute(String name) {
        Object value = this.attributes.remove(name);
        if (value == null) {
            return;
        }
        ServletContextAttributeEvent event = null;
        int len = this.eventListeners.length;
        for (int i = 0; i < len; ++i) {
            if (!(this.eventListeners[i] instanceof ServletContextAttributeListener)) continue;
            ServletContextAttributeListener listener = (ServletContextAttributeListener)this.eventListeners[i];
            try {
                if (event == null) {
                    event = new ServletContextAttributeEvent((ServletContext)this, name, value);
                }
                listener.attributeRemoved(event);
                continue;
            }
            catch (Throwable t) {
                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_HTTP_SERVLET_ATTRIBUTE_LISTENER_REMOVE_ERROR("ServletContextAttributeListener", listener.getClass().getName()), t);
            }
        }
    }

    public String getServletContextName() {
        return this.displayName;
    }

    protected String normalize(String path) {
        int index;
        if (path == null) {
            return null;
        }
        String normalized = path;
        if (normalized.indexOf(92) >= 0) {
            normalized = normalized.replace('\\', '/');
        }
        while ((index = normalized.indexOf("/../")) >= 0) {
            if (index == 0) {
                return null;
            }
            int index2 = normalized.lastIndexOf(47, index - 1);
            normalized = normalized.substring(0, index2) + normalized.substring(index + 3);
        }
        return normalized;
    }

    protected String getBasePath() {
        return this.basePath;
    }

    protected void setDispatcherHelper(DispatcherHelper dispatcherHelper) {
        this.dispatcherHelper = dispatcherHelper;
    }

    protected EventListener[] getEventListeners() {
        return this.eventListeners;
    }

    private void destroyFilters() {
        for (FilterRegistration registration : this.filterRegistrations.values()) {
            registration.filter.destroy();
        }
    }

    private void destoryServlets(HttpServer server) {
        if (this.servletHandlers != null && !this.servletHandlers.isEmpty()) {
            ServerConfiguration config = server.getServerConfiguration();
            for (ServletHandler handler : this.servletHandlers) {
                config.removeHttpHandler(handler);
            }
        }
    }

    private void initializeListeners() {
        if (!this.eventListenerClasses.isEmpty() || !this.eventListenerClassNames.isEmpty()) {
            ArrayList<EventListener> listeners = new ArrayList<EventListener>(this.eventListenerClasses.size());
            for (String string : this.eventListenerClassNames) {
                listeners.add((EventListener)ClassLoaderUtil.load(string));
            }
            for (Class clazz : this.eventListenerClasses) {
                try {
                    listeners.add((EventListener)clazz.newInstance());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            this.eventListeners = listeners.toArray(new EventListener[listeners.size()]);
        }
    }

    private void initServlets(HttpServer server) {
        boolean defaultMappingAdded = false;
        if (!this.servletRegistrations.isEmpty()) {
            ServerConfiguration serverConfig = server.getServerConfiguration();
            this.servletHandlers = new LinkedHashSet<ServletHandler>(this.servletRegistrations.size(), 1.0f);
            LinkedList<ServletRegistration> sortedRegistrations = new LinkedList<ServletRegistration>(this.servletRegistrations.values());
            Collections.sort(sortedRegistrations);
            for (ServletRegistration registration : sortedRegistrations) {
                ServletConfigImpl sConfig = this.createServletConfig(registration);
                if (registration.servlet != null) {
                    try {
                        registration.servlet.init((ServletConfig)sConfig);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                if (registration.loadOnStartup >= 0) {
                    Servlet servletInstance;
                    String servletClassName = registration.className;
                    Class<? extends Servlet> servletClass = registration.servletClass;
                    if (servletClassName != null) {
                        servletInstance = (Servlet)ClassLoaderUtil.load(servletClassName);
                    } else {
                        try {
                            servletInstance = servletClass.newInstance();
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                    try {
                        LOGGER.log(Level.INFO, "Loading Servlet: {0}", servletInstance.getClass().getName());
                        servletInstance.init((ServletConfig)sConfig);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                ServletHandler servletHandler = new ServletHandler(sConfig);
                servletHandler.setServletInstance(registration.servlet);
                servletHandler.setServletClass(registration.servletClass);
                servletHandler.setServletClassName(registration.className);
                servletHandler.setContextPath(this.contextPath);
                servletHandler.setFilterChainFactory(this.filterChainFactory);
                servletHandler.setExpectationHandler(registration.expectationHandler);
                servletHandler.addOnDestroyListener(this.onDestroyListener);
                Object[] patterns = registration.urlPatterns.getArray();
                if (patterns != null && patterns.length > 0) {
                    for (String string : patterns) {
                        if (string.length() == 0 || "/".equals(string)) {
                            defaultMappingAdded = true;
                        }
                        serverConfig.addHttpHandler(servletHandler, WebappContext.updateMappings(servletHandler, string));
                    }
                } else {
                    serverConfig.addHttpHandler(servletHandler, WebappContext.updateMappings(servletHandler, ""));
                }
                this.servletHandlers.add(servletHandler);
                if (!LOGGER.isLoggable(Level.INFO)) continue;
                String p = patterns == null ? "" : Arrays.toString(patterns);
                LOGGER.log(Level.INFO, "[{0}] Servlet [{1}] registered for url pattern(s) [{2}].", new Object[]{this.displayName, registration.className, p});
            }
        }
        if (!defaultMappingAdded) {
            this.registerDefaultServlet(server);
        }
    }

    private void registerDefaultServlet(HttpServer server) {
        ServerConfiguration serverConfig = server.getServerConfiguration();
        Map<HttpHandler, String[]> handlers = serverConfig.getHttpHandlers();
        for (Map.Entry<HttpHandler, String[]> entry : handlers.entrySet()) {
            String[] mappings;
            HttpHandler h = entry.getKey();
            if (!(h instanceof StaticHttpHandler)) continue;
            for (String mapping : mappings = entry.getValue()) {
                if (!"/".equals(mapping)) continue;
                DefaultServlet s = new DefaultServlet(((StaticHttpHandler)h).getDocRoots());
                ServletRegistration registration = this.addServlet("DefaultServlet", (Servlet)s);
                registration.addMapping("/");
                ServletConfigImpl sConfig = this.createServletConfig(registration);
                try {
                    s.init(sConfig);
                }
                catch (ServletException ignored) {
                    // empty catch block
                }
                ServletHandler servletHandler = new ServletHandler(sConfig);
                servletHandler.setServletInstance(registration.servlet);
                servletHandler.setServletClass(registration.servletClass);
                servletHandler.setServletClassName(registration.className);
                servletHandler.setContextPath(this.contextPath);
                servletHandler.setFilterChainFactory(this.filterChainFactory);
                servletHandler.setExpectationHandler(registration.expectationHandler);
                servletHandler.addOnDestroyListener(this.onDestroyListener);
                serverConfig.addHttpHandler(servletHandler, WebappContext.updateMappings(servletHandler, "/"));
                if (this.servletHandlers == null) {
                    this.servletHandlers = new LinkedHashSet<ServletHandler>(1, 1.0f);
                }
                this.servletHandlers.add(servletHandler);
            }
        }
    }

    private void initFilters() {
        if (!this.filterRegistrations.isEmpty()) {
            for (FilterRegistration registration : this.filterRegistrations.values()) {
                try {
                    Filter f = registration.filter;
                    if (f == null) {
                        Class<Object> filterClass = registration.filterClass;
                        if (filterClass == null) {
                            filterClass = Thread.currentThread().getContextClassLoader().loadClass(registration.className);
                        }
                        f = filterClass.newInstance();
                    }
                    FilterConfigImpl filterConfig = this.createFilterConfig(registration);
                    registration.filter = f;
                    f.init((FilterConfig)filterConfig);
                    if (!LOGGER.isLoggable(Level.INFO)) continue;
                    LOGGER.log(Level.INFO, "[{0}] Filter [{1}] registered for url pattern(s) [{2}] and servlet name(s) [{3}]", new Object[]{this.displayName, registration.className, ServletUtils.getUnifiedKeyView(registration.urlPatterns), ServletUtils.getUnifiedKeyView(registration.servletNames)});
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static String updateMappings(ServletHandler handler, String mapping) {
        String mappingLocal = mapping;
        if (mappingLocal.length() == 0) {
            mappingLocal = "/";
        } else {
            if (mappingLocal.charAt(0) == '*') {
                mappingLocal = "/" + mapping;
            }
            if (mappingLocal.indexOf("//", 1) != -1) {
                mappingLocal = mappingLocal.replaceAll("//", "/");
            }
        }
        String contextPath = handler.getContextPath();
        contextPath = contextPath.length() == 0 ? "/" : contextPath;
        return contextPath + mappingLocal;
    }

    private FilterConfigImpl createFilterConfig(FilterRegistration registration) {
        FilterConfigImpl fConfig = new FilterConfigImpl(this);
        fConfig.setFilterName(registration.getName());
        if (!registration.initParameters.isEmpty()) {
            fConfig.setInitParameters(registration.initParameters);
        }
        return fConfig;
    }

    private ServletConfigImpl createServletConfig(ServletRegistration registration) {
        ServletConfigImpl sConfig = new ServletConfigImpl(this);
        sConfig.setServletName(registration.getName());
        if (!registration.initParameters.isEmpty()) {
            sConfig.setInitParameters(registration.initParameters);
        }
        return sConfig;
    }

    private void contextInitialized() {
        ServletContextEvent event = null;
        int len = this.eventListeners.length;
        for (int i = 0; i < len; ++i) {
            if (!(this.eventListeners[i] instanceof ServletContextListener)) continue;
            ServletContextListener listener = (ServletContextListener)this.eventListeners[i];
            if (event == null) {
                event = new ServletContextEvent((ServletContext)this);
            }
            try {
                listener.contextInitialized(event);
                continue;
            }
            catch (Throwable t) {
                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_HTTP_SERVLET_CONTAINER_OBJECT_INITIALIZED_ERROR("contextInitialized", "ServletContextListener", listener.getClass().getName()), t);
            }
        }
    }

    private void contextDestroyed() {
        ServletContextEvent event = null;
        int len = this.eventListeners.length;
        for (int i = 0; i < len; ++i) {
            if (!(this.eventListeners[i] instanceof ServletContextListener)) continue;
            ServletContextListener listener = (ServletContextListener)this.eventListeners[i];
            if (event == null) {
                event = new ServletContextEvent((ServletContext)this);
            }
            try {
                listener.contextDestroyed(event);
                continue;
            }
            catch (Throwable t) {
                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_HTTP_SERVLET_CONTAINER_OBJECT_DESTROYED_ERROR("contextDestroyed", "ServletContextListener", listener.getClass().getName()), t);
            }
        }
    }

    private static final class DispatchData {
        public final DataChunk hostDC = DataChunk.newInstance();
        public final DataChunk uriDC = DataChunk.newInstance();
        public final DataChunk servletNameDC = DataChunk.newInstance();
        public final MappingData mappingData = new MappingData();

        public void recycle() {
            this.hostDC.recycle();
            this.uriDC.recycle();
            this.servletNameDC.recycle();
            this.mappingData.recycle();
        }
    }
}

