/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.mockito;

import io.hops.hadoop.shaded.org.hamcrest.Matcher;
import io.hops.hadoop.shaded.org.mockito.internal.matchers.Any;
import io.hops.hadoop.shaded.org.mockito.internal.matchers.AnyVararg;
import io.hops.hadoop.shaded.org.mockito.internal.matchers.Contains;
import io.hops.hadoop.shaded.org.mockito.internal.matchers.EndsWith;
import io.hops.hadoop.shaded.org.mockito.internal.matchers.Equals;
import io.hops.hadoop.shaded.org.mockito.internal.matchers.InstanceOf;
import io.hops.hadoop.shaded.org.mockito.internal.matchers.Matches;
import io.hops.hadoop.shaded.org.mockito.internal.matchers.NotNull;
import io.hops.hadoop.shaded.org.mockito.internal.matchers.Null;
import io.hops.hadoop.shaded.org.mockito.internal.matchers.Same;
import io.hops.hadoop.shaded.org.mockito.internal.matchers.StartsWith;
import io.hops.hadoop.shaded.org.mockito.internal.matchers.apachecommons.ReflectionEquals;
import io.hops.hadoop.shaded.org.mockito.internal.progress.HandyReturnValues;
import io.hops.hadoop.shaded.org.mockito.internal.progress.MockingProgress;
import io.hops.hadoop.shaded.org.mockito.internal.progress.ThreadSafeMockingProgress;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Matchers {
    private static MockingProgress mockingProgress = new ThreadSafeMockingProgress();

    public static boolean anyBoolean() {
        return Matchers.reportMatcher(Any.ANY).returnFalse();
    }

    public static byte anyByte() {
        return Matchers.reportMatcher(Any.ANY).returnZero();
    }

    public static char anyChar() {
        return Matchers.reportMatcher(Any.ANY).returnChar();
    }

    public static int anyInt() {
        return Matchers.reportMatcher(Any.ANY).returnZero();
    }

    public static long anyLong() {
        return Matchers.reportMatcher(Any.ANY).returnZero();
    }

    public static float anyFloat() {
        return Matchers.reportMatcher(Any.ANY).returnZero();
    }

    public static double anyDouble() {
        return Matchers.reportMatcher(Any.ANY).returnZero();
    }

    public static short anyShort() {
        return Matchers.reportMatcher(Any.ANY).returnZero();
    }

    public static <T> T anyObject() {
        return Matchers.reportMatcher(Any.ANY).returnNull();
    }

    public static <T> T anyVararg() {
        return Matchers.reportMatcher(AnyVararg.ANY_VARARG).returnNull();
    }

    public static <T> T any(Class<T> clazz) {
        return Matchers.anyObject();
    }

    public static <T> T any() {
        return Matchers.anyObject();
    }

    public static String anyString() {
        return Matchers.reportMatcher(Any.ANY).returnString();
    }

    public static List anyList() {
        return Matchers.reportMatcher(Any.ANY).returnList();
    }

    public static <T> List<T> anyListOf(Class<T> clazz) {
        return Matchers.reportMatcher(Any.ANY).returnList();
    }

    public static Set anySet() {
        return Matchers.reportMatcher(Any.ANY).returnSet();
    }

    public static <T> Set<T> anySetOf(Class<T> clazz) {
        return Matchers.reportMatcher(Any.ANY).returnSet();
    }

    public static Map anyMap() {
        return Matchers.reportMatcher(Any.ANY).returnMap();
    }

    public static Collection anyCollection() {
        return Matchers.reportMatcher(Any.ANY).returnList();
    }

    public static <T> Collection<T> anyCollectionOf(Class<T> clazz) {
        return Matchers.reportMatcher(Any.ANY).returnList();
    }

    public static <T> T isA(Class<T> clazz) {
        return (T)Matchers.reportMatcher(new InstanceOf(clazz)).returnFor(clazz);
    }

    public static boolean eq(boolean value) {
        return Matchers.reportMatcher(new Equals(value)).returnFalse();
    }

    public static byte eq(byte value) {
        return Matchers.reportMatcher(new Equals(value)).returnZero();
    }

    public static char eq(char value) {
        return Matchers.reportMatcher(new Equals(Character.valueOf(value))).returnChar();
    }

    public static double eq(double value) {
        return Matchers.reportMatcher(new Equals(value)).returnZero();
    }

    public static float eq(float value) {
        return Matchers.reportMatcher(new Equals(Float.valueOf(value))).returnZero();
    }

    public static int eq(int value) {
        return Matchers.reportMatcher(new Equals(value)).returnZero();
    }

    public static long eq(long value) {
        return Matchers.reportMatcher(new Equals(value)).returnZero();
    }

    public static short eq(short value) {
        return Matchers.reportMatcher(new Equals(value)).returnZero();
    }

    public static <T> T eq(T value) {
        return Matchers.reportMatcher(new Equals(value)).returnFor(value);
    }

    public static <T> T refEq(T value, String ... excludeFields) {
        return Matchers.reportMatcher(new ReflectionEquals(value, excludeFields)).returnNull();
    }

    public static <T> T same(T value) {
        return Matchers.reportMatcher(new Same(value)).returnFor(value);
    }

    public static Object isNull() {
        return Matchers.reportMatcher(Null.NULL).returnNull();
    }

    public static Object notNull() {
        return Matchers.reportMatcher(NotNull.NOT_NULL).returnNull();
    }

    public static Object isNotNull() {
        return Matchers.notNull();
    }

    public static String contains(String substring) {
        return Matchers.reportMatcher(new Contains(substring)).returnString();
    }

    public static String matches(String regex) {
        return Matchers.reportMatcher(new Matches(regex)).returnString();
    }

    public static String endsWith(String suffix) {
        return Matchers.reportMatcher(new EndsWith(suffix)).returnString();
    }

    public static String startsWith(String prefix) {
        return Matchers.reportMatcher(new StartsWith(prefix)).returnString();
    }

    public static <T> T argThat(Matcher<T> matcher) {
        return Matchers.reportMatcher(matcher).returnNull();
    }

    public static char charThat(Matcher<Character> matcher) {
        return Matchers.reportMatcher(matcher).returnChar();
    }

    public static boolean booleanThat(Matcher<Boolean> matcher) {
        return Matchers.reportMatcher(matcher).returnFalse();
    }

    public static byte byteThat(Matcher<Byte> matcher) {
        return Matchers.reportMatcher(matcher).returnZero();
    }

    public static short shortThat(Matcher<Short> matcher) {
        return Matchers.reportMatcher(matcher).returnZero();
    }

    public static int intThat(Matcher<Integer> matcher) {
        return Matchers.reportMatcher(matcher).returnZero();
    }

    public static long longThat(Matcher<Long> matcher) {
        return Matchers.reportMatcher(matcher).returnZero();
    }

    public static float floatThat(Matcher<Float> matcher) {
        return Matchers.reportMatcher(matcher).returnZero();
    }

    public static double doubleThat(Matcher<Double> matcher) {
        return Matchers.reportMatcher(matcher).returnZero();
    }

    private static HandyReturnValues reportMatcher(Matcher<?> matcher) {
        return mockingProgress.getArgumentMatcherStorage().reportMatcher(matcher);
    }
}

