/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.mockito.internal.invocation;

import io.hops.hadoop.shaded.org.hamcrest.Matcher;
import io.hops.hadoop.shaded.org.mockito.exceptions.PrintableInvocation;
import io.hops.hadoop.shaded.org.mockito.internal.debugging.Location;
import io.hops.hadoop.shaded.org.mockito.internal.invocation.ArgumentsComparator;
import io.hops.hadoop.shaded.org.mockito.internal.invocation.CapturesArgumensFromInvocation;
import io.hops.hadoop.shaded.org.mockito.internal.invocation.Invocation;
import io.hops.hadoop.shaded.org.mockito.internal.matchers.CapturesArguments;
import io.hops.hadoop.shaded.org.mockito.internal.reporting.PrintSettings;
import io.hops.hadoop.shaded.org.mockito.internal.reporting.PrintingFriendlyInvocation;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvocationMatcher
implements PrintableInvocation,
PrintingFriendlyInvocation,
CapturesArgumensFromInvocation,
Serializable {
    private static final long serialVersionUID = -3047126096857467610L;
    private final Invocation invocation;
    private final List<Matcher> matchers;

    public InvocationMatcher(Invocation invocation, List<Matcher> matchers) {
        this.invocation = invocation;
        this.matchers = matchers.isEmpty() ? invocation.argumentsToMatchers() : matchers;
    }

    public InvocationMatcher(Invocation invocation) {
        this(invocation, Collections.emptyList());
    }

    public Method getMethod() {
        return this.invocation.getMethod();
    }

    public Invocation getInvocation() {
        return this.invocation;
    }

    public List<Matcher> getMatchers() {
        return this.matchers;
    }

    @Override
    public String toString() {
        return this.invocation.toString(this.matchers, new PrintSettings());
    }

    public boolean matches(Invocation actual) {
        return this.invocation.getMock().equals(actual.getMock()) && this.hasSameMethod(actual) && new ArgumentsComparator().argumentsMatch(this, actual);
    }

    private boolean safelyArgumentsMatch(Object[] actualArgs) {
        try {
            return new ArgumentsComparator().argumentsMatch(this, actualArgs);
        }
        catch (Throwable t) {
            return false;
        }
    }

    public boolean hasSimilarMethod(Invocation candidate) {
        String wantedMethodName = this.getMethod().getName();
        String currentMethodName = candidate.getMethod().getName();
        boolean methodNameEquals = wantedMethodName.equals(currentMethodName);
        boolean isUnverified = !candidate.isVerified();
        boolean mockIsTheSame = this.getInvocation().getMock() == candidate.getMock();
        boolean methodEquals = this.hasSameMethod(candidate);
        if (!(methodNameEquals && isUnverified && mockIsTheSame)) {
            return false;
        }
        boolean overloadedButSameArgs = !methodEquals && this.safelyArgumentsMatch(candidate.getArguments());
        return !overloadedButSameArgs;
    }

    public boolean hasSameMethod(Invocation candidate) {
        return this.invocation.getMethod().equals(candidate.getMethod());
    }

    @Override
    public Location getLocation() {
        return this.invocation.getLocation();
    }

    @Override
    public String toString(PrintSettings printSettings) {
        return this.invocation.toString(this.matchers, printSettings);
    }

    @Override
    public void captureArgumentsFrom(Invocation i) {
        int k = 0;
        for (Matcher m : this.matchers) {
            if (m instanceof CapturesArguments && i.getArguments().length > k) {
                ((CapturesArguments)((Object)m)).captureFrom(i.getArguments()[k]);
            }
            ++k;
        }
    }

    public static List<InvocationMatcher> createFrom(List<Invocation> invocations) {
        LinkedList<InvocationMatcher> out = new LinkedList<InvocationMatcher>();
        for (Invocation i : invocations) {
            out.add(new InvocationMatcher(i));
        }
        return out;
    }
}

