/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.mockito.internal.verification.checkers;

import io.hops.hadoop.shaded.org.mockito.exceptions.Discrepancy;
import io.hops.hadoop.shaded.org.mockito.exceptions.Reporter;
import io.hops.hadoop.shaded.org.mockito.internal.debugging.Location;
import io.hops.hadoop.shaded.org.mockito.internal.invocation.CapturesArgumensFromInvocation;
import io.hops.hadoop.shaded.org.mockito.internal.invocation.Invocation;
import io.hops.hadoop.shaded.org.mockito.internal.invocation.InvocationMarker;
import io.hops.hadoop.shaded.org.mockito.internal.invocation.InvocationMatcher;
import io.hops.hadoop.shaded.org.mockito.internal.invocation.InvocationsFinder;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberOfInvocationsChecker {
    private final Reporter reporter;
    private final InvocationsFinder finder;
    private final InvocationMarker invocationMarker = new InvocationMarker();

    public NumberOfInvocationsChecker() {
        this(new Reporter(), new InvocationsFinder());
    }

    NumberOfInvocationsChecker(Reporter reporter, InvocationsFinder finder) {
        this.reporter = reporter;
        this.finder = finder;
    }

    public void check(List<Invocation> invocations, InvocationMatcher wanted, int wantedCount) {
        List<Invocation> actualInvocations = this.finder.findInvocations(invocations, wanted);
        int actualCount = actualInvocations.size();
        if (wantedCount > actualCount) {
            Location lastInvocation = this.finder.getLastLocation(actualInvocations);
            this.reporter.tooLittleActualInvocations(new Discrepancy(wantedCount, actualCount), wanted, lastInvocation);
        } else if (wantedCount == 0 && actualCount > 0) {
            Location firstUndesired = actualInvocations.get(wantedCount).getLocation();
            this.reporter.neverWantedButInvoked(wanted, firstUndesired);
        } else if (wantedCount < actualCount) {
            Location firstUndesired = actualInvocations.get(wantedCount).getLocation();
            this.reporter.tooManyActualInvocations(wantedCount, actualCount, wanted, firstUndesired);
        }
        this.invocationMarker.markVerified(actualInvocations, (CapturesArgumensFromInvocation)wanted);
    }
}

