/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.terracotta.statistics.extended;

import io.hops.hadoop.shaded.org.terracotta.statistics.OperationStatistic;
import io.hops.hadoop.shaded.org.terracotta.statistics.SourceStatistic;
import io.hops.hadoop.shaded.org.terracotta.statistics.Time;
import io.hops.hadoop.shaded.org.terracotta.statistics.derived.EventParameterSimpleMovingAverage;
import io.hops.hadoop.shaded.org.terracotta.statistics.derived.LatencySampling;
import io.hops.hadoop.shaded.org.terracotta.statistics.extended.Latency;
import io.hops.hadoop.shaded.org.terracotta.statistics.extended.SampledStatistic;
import io.hops.hadoop.shaded.org.terracotta.statistics.extended.SampledStatisticImpl;
import io.hops.hadoop.shaded.org.terracotta.statistics.extended.StatisticType;
import io.hops.hadoop.shaded.org.terracotta.statistics.observer.ChainedOperationObserver;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

class LatencyImpl<T extends Enum<T>>
implements Latency {
    private final SourceStatistic<ChainedOperationObserver<? super T>> source;
    private final LatencySampling<T> latencySampler;
    private final EventParameterSimpleMovingAverage average;
    private final SampledStatisticImpl<Long> minimumStatistic;
    private final SampledStatisticImpl<Long> maximumStatistic;
    private final SampledStatisticImpl<Double> averageStatistic;
    private boolean active = false;
    private long touchTimestamp = -1L;

    public LatencyImpl(OperationStatistic<T> statistic, Set<T> targets, long averagePeriod, TimeUnit averageTimeUnit, ScheduledExecutorService executor, int historySize, long historyPeriod, TimeUnit historyTimeUnit) {
        this.average = new EventParameterSimpleMovingAverage(averagePeriod, averageTimeUnit);
        this.minimumStatistic = new SampledStatisticImpl<Long>(this, this.average.minimumStatistic(), executor, historySize, historyPeriod, historyTimeUnit, StatisticType.LATENCY_MIN);
        this.maximumStatistic = new SampledStatisticImpl<Long>(this, this.average.maximumStatistic(), executor, historySize, historyPeriod, historyTimeUnit, StatisticType.LATENCY_MAX);
        this.averageStatistic = new SampledStatisticImpl<Double>(this, this.average.averageStatistic(), executor, historySize, historyPeriod, historyTimeUnit, StatisticType.LATENCY_AVG);
        this.latencySampler = new LatencySampling<T>(targets, 1.0);
        this.latencySampler.addDerivedStatistic(this.average);
        this.source = statistic;
    }

    synchronized void start() {
        if (!this.active) {
            this.source.addDerivedStatistic(this.latencySampler);
            this.minimumStatistic.startSampling();
            this.maximumStatistic.startSampling();
            this.averageStatistic.startSampling();
            this.active = true;
        }
    }

    @Override
    public SampledStatistic<Long> minimum() {
        return this.minimumStatistic;
    }

    @Override
    public SampledStatistic<Long> maximum() {
        return this.maximumStatistic;
    }

    @Override
    public SampledStatistic<Double> average() {
        return this.averageStatistic;
    }

    synchronized void touch() {
        this.touchTimestamp = Time.absoluteTime();
        this.start();
    }

    public synchronized boolean expire(long expiry) {
        if (this.touchTimestamp < expiry) {
            if (this.active) {
                this.source.removeDerivedStatistic(this.latencySampler);
                this.minimumStatistic.stopSampling();
                this.maximumStatistic.stopSampling();
                this.averageStatistic.stopSampling();
                this.active = false;
            }
            return true;
        }
        return false;
    }

    void setWindow(long averagePeriod, TimeUnit averageTimeUnit) {
        this.average.setWindow(averagePeriod, averageTimeUnit);
    }

    void setHistory(int historySize, long historyPeriod, TimeUnit historyTimeUnit) {
        this.minimumStatistic.setHistory(historySize, historyPeriod, historyTimeUnit);
        this.maximumStatistic.setHistory(historySize, historyPeriod, historyTimeUnit);
        this.averageStatistic.setHistory(historySize, historyPeriod, historyTimeUnit);
    }

    public boolean active() {
        return this.active;
    }
}

