/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import io.hops.hadoop.shaded.org.apache.commons.lang3.builder.EqualsBuilder;
import io.hops.hadoop.shaded.org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;

@InterfaceAudience.Private
public final class ExtendedBlockId {
    private final long blockId;
    private final String bpId;

    public static ExtendedBlockId fromExtendedBlock(ExtendedBlock block) {
        return new ExtendedBlockId(block.getBlockId(), block.getBlockPoolId());
    }

    public ExtendedBlockId(long blockId, String bpId) {
        this.blockId = blockId;
        this.bpId = bpId;
    }

    public long getBlockId() {
        return this.blockId;
    }

    public String getBlockPoolId() {
        return this.bpId;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        ExtendedBlockId other = (ExtendedBlockId)o;
        return new EqualsBuilder().append(this.blockId, other.blockId).append((Object)this.bpId, (Object)other.bpId).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.blockId).append((Object)this.bpId).toHashCode();
    }

    public String toString() {
        return this.blockId + "_" + this.bpId;
    }
}

