/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server;

import io.hops.hadoop.shaded.com.nimbusds.jose.JOSEException;
import io.hops.hadoop.shaded.com.nimbusds.jwt.JWTClaimsSet;
import io.hops.security.MockJWTIssuer;
import io.hops.security.ServiceJWTManager;
import java.net.MalformedURLException;
import java.security.GeneralSecurityException;
import java.sql.Date;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Random;
import org.apache.hadoop.yarn.server.resourcemanager.security.HopsworksRMAppSecurityActions;

public class MockHopsworksRMAppSecurityActions
extends HopsworksRMAppSecurityActions {
    private final byte[] secret;
    private final MockJWTIssuer jwtIssuer;

    public MockHopsworksRMAppSecurityActions() throws MalformedURLException, GeneralSecurityException, JOSEException {
        Random rand = new Random();
        this.secret = new byte[32];
        rand.nextBytes(this.secret);
        this.jwtIssuer = new MockJWTIssuer(this.secret);
    }

    protected ServiceJWTManager createJWTManager() {
        return new MockJWTManager("Mock JWT Manager", this.jwtIssuer);
    }

    private class MockJWTManager
    extends ServiceJWTManager {
        private final MockJWTIssuer jwtIssuer;

        public MockJWTManager(String name, MockJWTIssuer jwtIssuer) {
            super(name);
            this.jwtIssuer = jwtIssuer;
        }

        protected void loadMasterJWT() throws GeneralSecurityException {
            LocalDateTime masterExpiration = LocalDateTime.now().plus(10L, ChronoUnit.MINUTES);
            JWTClaimsSet.Builder claimsBuilder = new JWTClaimsSet.Builder();
            claimsBuilder.expirationTime(Date.from(masterExpiration.atZone(ZoneId.systemDefault()).toInstant()));
            try {
                String masterToken = this.jwtIssuer.generate(claimsBuilder);
                this.setMasterToken(masterToken);
                this.setMasterTokenExpiration(masterExpiration);
            }
            catch (JOSEException ex) {
                throw new GeneralSecurityException(ex.getMessage(), ex);
            }
        }

        protected void loadRenewalJWTs() throws GeneralSecurityException {
            this.setRenewalTokens(new String[0]);
        }

        protected void reloadJWTs() throws GeneralSecurityException {
            this.loadMasterJWT();
            this.loadRenewalJWTs();
        }
    }
}

