/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.amrmproxy;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.client.ClientRMProxy;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.server.api.DistributedSchedulingAMProtocol;
import org.apache.hadoop.yarn.server.api.ServerRMProxy;
import org.apache.hadoop.yarn.server.api.protocolrecords.DistributedSchedulingAllocateRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.DistributedSchedulingAllocateResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterDistributedSchedulingAMResponse;
import org.apache.hadoop.yarn.server.nodemanager.amrmproxy.AMRMProxyApplicationContext;
import org.apache.hadoop.yarn.server.nodemanager.amrmproxy.AbstractRequestInterceptor;
import org.apache.hadoop.yarn.server.nodemanager.amrmproxy.RequestInterceptor;
import org.apache.hadoop.yarn.server.utils.YarnServerSecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultRequestInterceptor
extends AbstractRequestInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultRequestInterceptor.class);
    private ApplicationMasterProtocol rmClient;
    private UserGroupInformation user = null;

    @Override
    public void init(AMRMProxyApplicationContext appContext) {
        super.init(appContext);
        try {
            this.user = UserGroupInformation.createProxyUser((String)appContext.getApplicationAttemptId().toString(), (UserGroupInformation)UserGroupInformation.getCurrentUser());
            this.user.addToken(appContext.getAMRMToken());
            Configuration conf = this.getConf();
            this.rmClient = this.createRMClient(appContext, conf);
        }
        catch (IOException e) {
            String message = "Error while creating of RM app master service proxy for attemptId:" + appContext.getApplicationAttemptId().toString();
            if (this.user != null) {
                message = message + ", user: " + this.user;
            }
            LOG.info(message);
            throw new YarnRuntimeException(message, (Throwable)e);
        }
        catch (Exception e) {
            throw new YarnRuntimeException((Throwable)e);
        }
    }

    private ApplicationMasterProtocol createRMClient(AMRMProxyApplicationContext appContext, final Configuration conf) throws IOException, InterruptedException {
        if (appContext.getNMCotext().isDistributedSchedulingEnabled()) {
            return (ApplicationMasterProtocol)this.user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<DistributedSchedulingAMProtocol>(){

                @Override
                public DistributedSchedulingAMProtocol run() throws Exception {
                    DefaultRequestInterceptor.setAMRMTokenService(conf);
                    return ServerRMProxy.createRMProxy(conf, DistributedSchedulingAMProtocol.class);
                }
            });
        }
        return (ApplicationMasterProtocol)this.user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<ApplicationMasterProtocol>(){

            @Override
            public ApplicationMasterProtocol run() throws Exception {
                DefaultRequestInterceptor.setAMRMTokenService(conf);
                return (ApplicationMasterProtocol)ClientRMProxy.createRMProxy((Configuration)conf, ApplicationMasterProtocol.class);
            }
        });
    }

    public RegisterApplicationMasterResponse registerApplicationMaster(RegisterApplicationMasterRequest request) throws YarnException, IOException {
        LOG.info("Forwarding registration request to the real YARN RM");
        return this.rmClient.registerApplicationMaster(request);
    }

    public AllocateResponse allocate(AllocateRequest request) throws YarnException, IOException {
        AllocateResponse allocateResponse;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Forwarding allocate request to the real YARN RM");
        }
        if ((allocateResponse = this.rmClient.allocate(request)).getAMRMToken() != null) {
            YarnServerSecurityUtils.updateAMRMToken(allocateResponse.getAMRMToken(), this.user, this.getConf());
        }
        return allocateResponse;
    }

    @Override
    public RegisterDistributedSchedulingAMResponse registerApplicationMasterForDistributedScheduling(RegisterApplicationMasterRequest request) throws YarnException, IOException {
        if (this.getApplicationContext().getNMCotext().isDistributedSchedulingEnabled()) {
            LOG.info("Forwarding registerApplicationMasterForDistributedSchedulingrequest to the real YARN RM");
            return ((DistributedSchedulingAMProtocol)this.rmClient).registerApplicationMasterForDistributedScheduling(request);
        }
        throw new YarnException("Distributed Scheduling is not enabled.");
    }

    @Override
    public DistributedSchedulingAllocateResponse allocateForDistributedScheduling(DistributedSchedulingAllocateRequest request) throws YarnException, IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Forwarding allocateForDistributedScheduling requestto the real YARN RM");
        }
        if (this.getApplicationContext().getNMCotext().isDistributedSchedulingEnabled()) {
            DistributedSchedulingAllocateResponse allocateResponse = ((DistributedSchedulingAMProtocol)this.rmClient).allocateForDistributedScheduling(request);
            if (allocateResponse.getAllocateResponse().getAMRMToken() != null) {
                YarnServerSecurityUtils.updateAMRMToken(allocateResponse.getAllocateResponse().getAMRMToken(), this.user, this.getConf());
            }
            return allocateResponse;
        }
        throw new YarnException("Distributed Scheduling is not enabled.");
    }

    public FinishApplicationMasterResponse finishApplicationMaster(FinishApplicationMasterRequest request) throws YarnException, IOException {
        LOG.info("Forwarding finish application request to the real YARN Resource Manager");
        return this.rmClient.finishApplicationMaster(request);
    }

    @Override
    public void setNextInterceptor(RequestInterceptor next) {
        throw new YarnRuntimeException("setNextInterceptor is being called on DefaultRequestInterceptor,which should be the last one in the chain Check if the interceptor pipeline configuration is correct");
    }

    @VisibleForTesting
    public void setRMClient(final ApplicationMasterProtocol rmClient) {
        this.rmClient = rmClient instanceof DistributedSchedulingAMProtocol ? (DistributedSchedulingAMProtocol)rmClient : new DistributedSchedulingAMProtocol(){

            public RegisterApplicationMasterResponse registerApplicationMaster(RegisterApplicationMasterRequest request) throws YarnException, IOException {
                return rmClient.registerApplicationMaster(request);
            }

            public FinishApplicationMasterResponse finishApplicationMaster(FinishApplicationMasterRequest request) throws YarnException, IOException {
                return rmClient.finishApplicationMaster(request);
            }

            public AllocateResponse allocate(AllocateRequest request) throws YarnException, IOException {
                return rmClient.allocate(request);
            }

            @Override
            public RegisterDistributedSchedulingAMResponse registerApplicationMasterForDistributedScheduling(RegisterApplicationMasterRequest request) throws YarnException, IOException {
                throw new IOException("Not Supported !!");
            }

            @Override
            public DistributedSchedulingAllocateResponse allocateForDistributedScheduling(DistributedSchedulingAllocateRequest request) throws YarnException, IOException {
                throw new IOException("Not Supported !!");
            }
        };
    }

    private static void setAMRMTokenService(Configuration conf) throws IOException {
        for (Token token : UserGroupInformation.getCurrentUser().getTokens()) {
            if (!token.getKind().equals((Object)AMRMTokenIdentifier.KIND_NAME)) continue;
            token.setService(ClientRMProxy.getAMRMTokenService((Configuration)conf));
        }
    }

    @InterfaceStability.Unstable
    public static Text getTokenService(Configuration conf, String address, String defaultAddr, int defaultPort) {
        if (HAUtil.isHAEnabled((Configuration)conf)) {
            ArrayList<String> services = new ArrayList<String>();
            YarnConfiguration yarnConf = new YarnConfiguration(conf);
            for (String rmId : HAUtil.getRMHAIds((Configuration)conf)) {
                yarnConf.set("yarn.resourcemanager.ha.id", rmId);
                services.add(SecurityUtil.buildTokenService((InetSocketAddress)yarnConf.getSocketAddr(address, defaultAddr, defaultPort)).toString());
            }
            return new Text(Joiner.on((char)',').join(services));
        }
        return SecurityUtil.buildTokenService((InetSocketAddress)conf.getSocketAddr(address, defaultAddr, defaultPort));
    }
}

