/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.security;

import io.hops.hadoop.shaded.org.apache.http.HttpEntity;
import io.hops.hadoop.shaded.org.apache.http.HttpRequest;
import io.hops.hadoop.shaded.org.apache.http.HttpResponse;
import io.hops.hadoop.shaded.org.apache.http.client.methods.CloseableHttpResponse;
import io.hops.hadoop.shaded.org.apache.http.client.methods.HttpDelete;
import io.hops.hadoop.shaded.org.apache.http.client.methods.HttpPost;
import io.hops.hadoop.shaded.org.apache.http.client.methods.HttpPut;
import io.hops.hadoop.shaded.org.apache.http.client.utils.URIBuilder;
import io.hops.hadoop.shaded.org.apache.http.entity.StringEntity;
import io.hops.hadoop.shaded.org.apache.http.util.EntityUtils;
import io.hops.hadoop.shaded.org.bouncycastle.openssl.jcajce.JcaMiscPEMGenerator;
import io.hops.hadoop.shaded.org.bouncycastle.pkcs.PKCS10CertificationRequest;
import io.hops.hadoop.shaded.org.bouncycastle.util.io.pem.PemObjectGenerator;
import io.hops.hadoop.shaded.org.bouncycastle.util.io.pem.PemWriter;
import io.hops.security.AbstractSecurityActions;
import io.hops.security.ServiceJWTManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.DateUtils;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.security.JWTSecurityHandler;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppSecurityActions;
import org.apache.hadoop.yarn.server.resourcemanager.security.X509SecurityHandler;

public class HopsworksRMAppSecurityActions
extends AbstractSecurityActions
implements RMAppSecurityActions {
    public static final String REVOKE_CERT_ID_PARAM = "certId";
    protected static final int MAX_CONNECTIONS_PER_ROUTE = 50;
    private static final Log LOG = LogFactory.getLog(HopsworksRMAppSecurityActions.class);
    private static final Pattern SUBJECT_USERNAME = Pattern.compile("^(.+)(?>_{2})(.+)$");
    private URI signEndpoint;
    private URI revokePath;
    private CertificateFactory certificateFactory;
    private boolean x509Configured = false;
    private URI jwtGeneratePath;
    private URI jwtInvalidatePath;
    private URI jwtRenewPath;
    private boolean jwtConfigured = false;

    public HopsworksRMAppSecurityActions() {
        super("HopsworksRMAppSecurityActions");
    }

    protected void serviceInit(Configuration conf) throws Exception {
        if (!conf.getBoolean("ipc.server.ssl.enabled", false) && conf.getBoolean(YarnConfiguration.RM_JWT_ENABLED, false)) {
            super.serviceInit(conf);
            this.initJWT(conf);
        } else if (conf.getBoolean("ipc.server.ssl.enabled", false)) {
            super.serviceInit(conf);
            this.initJWT(conf);
            this.initX509(conf);
        }
    }

    protected void serviceStart() throws Exception {
        if (this.getConfig().getBoolean("ipc.server.ssl.enabled", false) || this.getConfig().getBoolean(YarnConfiguration.RM_JWT_ENABLED, false)) {
            super.serviceStart();
        }
    }

    protected void serviceStop() throws Exception {
        if (this.getConfig().getBoolean("ipc.server.ssl.enabled", false) || this.getConfig().getBoolean(YarnConfiguration.RM_JWT_ENABLED, false)) {
            super.serviceStop();
        }
    }

    private void initX509(Configuration conf) throws URISyntaxException, GeneralSecurityException {
        this.signEndpoint = new URI(conf.get(YarnConfiguration.HOPS_HOPSWORKS_SIGN_ENDPOINT_KEY, "/hopsworks-ca/v2/certificate/app"));
        this.revokePath = new URI(conf.get(YarnConfiguration.HOPS_HOPSWORKS_REVOKE_ENDPOINT_KEY, "/hopsworks-ca/v2/certificate/app"));
        this.certificateFactory = CertificateFactory.getInstance("X.509", "BC");
        this.x509Configured = true;
    }

    private void initJWT(Configuration conf) throws URISyntaxException {
        this.jwtGeneratePath = new URI(conf.get(YarnConfiguration.RM_JWT_GENERATE_PATH, "/hopsworks-api/api/jwt"));
        String jwtInvalidatePathConf = conf.get(YarnConfiguration.RM_JWT_INVALIDATE_PATH, "/hopsworks-api/api/jwt/key");
        if (!jwtInvalidatePathConf.endsWith("/")) {
            jwtInvalidatePathConf = jwtInvalidatePathConf + "/";
        }
        this.jwtInvalidatePath = new URI(jwtInvalidatePathConf);
        this.jwtRenewPath = new URI(conf.get(YarnConfiguration.RM_JWT_RENEW_PATH, "/hopsworks-api/api/jwt"));
        this.jwtConfigured = true;
    }

    private void x509NotConfigured(String methodName) throws GeneralSecurityException {
        this.notConfigured(methodName, "X.509");
    }

    private void jwtNotConfigured(String methodName) throws GeneralSecurityException {
        this.notConfigured(methodName, "JWT");
    }

    private void notConfigured(String methodName, String mechanism) throws GeneralSecurityException {
        throw new GeneralSecurityException("Called method " + methodName + " of " + HopsworksRMAppSecurityActions.class.getSimpleName() + " but " + mechanism + " is not configured");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public X509SecurityHandler.CertificateBundle sign(PKCS10CertificationRequest csr) throws IOException, GeneralSecurityException {
        if (!this.x509Configured) {
            this.x509NotConfigured("sign");
        }
        try (CloseableHttpResponse signResponse = null;){
            String csrStr = this.stringifyCSR(csr);
            CSRDTO payload = new CSRDTO();
            payload.csr = csrStr;
            HttpPost request = new HttpPost(this.signEndpoint);
            request.setEntity((HttpEntity)new StringEntity(this.parser.toJson((Object)payload)));
            signResponse = this.doJSONCall((HttpRequest)request, "Hopsworks CA could not sign CSR");
            CSRDTO csrResponse = (CSRDTO)this.parser.fromJson(EntityUtils.toString((HttpEntity)signResponse.getEntity()), CSRDTO.class);
            X509Certificate certificate = this.parseCertificate(csrResponse.signedCert);
            X509Certificate issuer = this.parseCertificate(csrResponse.intermediateCaCert);
            X509SecurityHandler.CertificateBundle certificateBundle = new X509SecurityHandler.CertificateBundle(certificate, issuer);
            return certificateBundle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int revoke(String certificateIdentifier) throws URISyntaxException, IOException, GeneralSecurityException {
        if (!this.x509Configured) {
            this.x509NotConfigured("revoke");
        }
        try (CloseableHttpResponse response = null;){
            URI parameterizedURI = new URIBuilder(this.revokePath).addParameter(REVOKE_CERT_ID_PARAM, certificateIdentifier).build();
            HttpDelete request = new HttpDelete(parameterizedURI);
            response = this.doTextPlainCall((HttpRequest)request, "Hopsworks CA could not revoke certificate " + certificateIdentifier);
            int n = response.getStatusLine().getStatusCode();
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String generateJWT(JWTSecurityHandler.JWTMaterialParameter jwtParameter) throws IOException, GeneralSecurityException {
        if (!this.jwtConfigured) {
            this.jwtNotConfigured("generateJWT");
        }
        try (CloseableHttpResponse response = null;){
            Matcher matcher = SUBJECT_USERNAME.matcher(jwtParameter.getAppUser());
            String username = matcher.matches() ? matcher.group(2) : jwtParameter.getAppUser();
            ServiceJWTManager.JWTDTO payload = new ServiceJWTManager.JWTDTO();
            payload.setSubject(username);
            payload.setKeyName(jwtParameter.getApplicationId().toString());
            payload.setAudiences(String.join((CharSequence)",", jwtParameter.getAudiences()));
            payload.setExpiresAt(DateUtils.localDateTime2Date((LocalDateTime)jwtParameter.getExpirationDate()));
            payload.setNbf(DateUtils.localDateTime2Date((LocalDateTime)jwtParameter.getValidNotBefore()));
            payload.setRenewable(Boolean.valueOf(jwtParameter.isRenewable()));
            payload.setExpLeeway(Integer.valueOf(jwtParameter.getExpLeeway()));
            HttpPost request = new HttpPost(this.jwtGeneratePath);
            request.setEntity((HttpEntity)new StringEntity(this.parser.toJson((Object)payload)));
            response = this.doJSONCall((HttpRequest)request, "Hopsworks could not generate JWT for " + jwtParameter.getAppUser() + "/" + jwtParameter.getApplicationId().toString());
            ServiceJWTManager.JWTDTO jwtResponse = (ServiceJWTManager.JWTDTO)this.parser.fromJson(EntityUtils.toString((HttpEntity)response.getEntity()), ServiceJWTManager.JWTDTO.class);
            String string = jwtResponse.getToken();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String renewJWT(JWTSecurityHandler.JWTMaterialParameter jwtParameter) throws IOException, GeneralSecurityException {
        if (!this.jwtConfigured) {
            this.jwtNotConfigured("renewJWT");
        }
        try (CloseableHttpResponse response = null;){
            ServiceJWTManager.JWTDTO payload = new ServiceJWTManager.JWTDTO();
            payload.setToken(jwtParameter.getToken());
            payload.setExpiresAt(DateUtils.localDateTime2Date((LocalDateTime)jwtParameter.getExpirationDate()));
            payload.setNbf(DateUtils.localDateTime2Date((LocalDateTime)jwtParameter.getValidNotBefore()));
            HttpPut request = new HttpPut(this.jwtRenewPath);
            request.setEntity((HttpEntity)new StringEntity(this.parser.toJson((Object)payload)));
            response = this.doJSONCall((HttpRequest)request, "Could not renew JWT for " + jwtParameter.getAppUser() + "/" + jwtParameter.getApplicationId());
            ServiceJWTManager.JWTDTO jwtResponse = (ServiceJWTManager.JWTDTO)this.parser.fromJson(EntityUtils.toString((HttpEntity)response.getEntity()), ServiceJWTManager.JWTDTO.class);
            String string = jwtResponse.getToken();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateJWT(String signingKeyName) throws URISyntaxException, IOException, GeneralSecurityException {
        if (!this.jwtConfigured) {
            this.jwtNotConfigured("invalidateJWT");
        }
        try (CloseableHttpResponse response = null;){
            URI invalidateURI = new URI(this.jwtInvalidatePath.getPath() + signingKeyName);
            HttpDelete request = new HttpDelete(invalidateURI);
            response = this.doJSONCall((HttpRequest)request, "Hopsworks could to invalidate JWT signing key " + signingKeyName);
        }
    }

    private CloseableHttpResponse doJSONCall(HttpRequest request, String errorMessage) throws IOException {
        this.addJSONContentType(request);
        return this.doCall(request, errorMessage);
    }

    private CloseableHttpResponse doTextPlainCall(HttpRequest request, String errorMessage) throws IOException {
        this.addTextPlainContentType(request);
        return this.doCall(request, errorMessage);
    }

    private CloseableHttpResponse doCall(HttpRequest request, String errorMessage) throws IOException {
        this.addJWTAuthHeader(request, this.serviceJWTManager.getMasterToken());
        CloseableHttpResponse response = this.httpClient.execute(this.remoteHost, request);
        this.checkHTTPResponseCode((HttpResponse)response, errorMessage);
        return response;
    }

    private X509Certificate parseCertificate(String certificateStr) throws IOException, GeneralSecurityException {
        try (ByteArrayInputStream bis = new ByteArrayInputStream(certificateStr.getBytes());){
            X509Certificate x509Certificate = (X509Certificate)this.certificateFactory.generateCertificate(bis);
            return x509Certificate;
        }
    }

    private String stringifyCSR(PKCS10CertificationRequest csr) throws IOException {
        try (StringWriter sw = new StringWriter();){
            PemWriter pw = new PemWriter((Writer)sw);
            JcaMiscPEMGenerator pog = new JcaMiscPEMGenerator((Object)csr);
            pw.writeObject((PemObjectGenerator)pog.generate());
            pw.flush();
            sw.flush();
            pw.close();
            String string = sw.toString();
            return string;
        }
    }

    private class CSRDTO {
        private String csr;
        private String signedCert;
        private String intermediateCaCert;
        private String rootCaCert;

        private CSRDTO() {
        }
    }
}

