/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.eclipse.jetty.server;

import io.hops.hadoop.shaded.org.eclipse.jetty.server.Server;
import io.hops.hadoop.shaded.org.eclipse.jetty.util.TypeUtil;
import io.hops.hadoop.shaded.org.eclipse.jetty.util.component.ContainerLifeCycle;
import io.hops.hadoop.shaded.org.eclipse.jetty.util.component.Dumpable;
import java.io.IOException;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Collections;

public class ClassLoaderDump
implements Dumpable {
    final ClassLoader _loader;

    public ClassLoaderDump(ClassLoader loader) {
        this._loader = loader;
    }

    public String dump() {
        return ContainerLifeCycle.dump((Dumpable)this);
    }

    public void dump(Appendable out, String indent) throws IOException {
        if (this._loader == null) {
            out.append("No ClassLoader\n");
        } else if (this._loader instanceof Dumpable) {
            ContainerLifeCycle.dump((Appendable)out, (String)indent, (Collection[])new Collection[]{Collections.singleton(this._loader)});
        } else if (this._loader instanceof URLClassLoader) {
            out.append(String.valueOf(this._loader)).append("\n");
            ClassLoader parent = this._loader.getParent();
            if (parent == null) {
                ContainerLifeCycle.dump((Appendable)out, (String)indent, (Collection[])new Collection[]{TypeUtil.asList((Object[])((URLClassLoader)this._loader).getURLs())});
            } else if (parent == Server.class.getClassLoader()) {
                ContainerLifeCycle.dump((Appendable)out, (String)indent, (Collection[])new Collection[]{TypeUtil.asList((Object[])((URLClassLoader)this._loader).getURLs()), Collections.singleton(parent.toString())});
            } else if (parent instanceof Dumpable) {
                ContainerLifeCycle.dump((Appendable)out, (String)indent, (Collection[])new Collection[]{TypeUtil.asList((Object[])((URLClassLoader)this._loader).getURLs()), Collections.singleton(parent)});
            } else {
                ContainerLifeCycle.dump((Appendable)out, (String)indent, (Collection[])new Collection[]{TypeUtil.asList((Object[])((URLClassLoader)this._loader).getURLs()), Collections.singleton(new ClassLoaderDump(parent))});
            }
        } else {
            out.append(String.valueOf(this._loader)).append("\n");
            ClassLoader parent = this._loader.getParent();
            if (parent == Server.class.getClassLoader()) {
                ContainerLifeCycle.dump((Appendable)out, (String)indent, (Collection[])new Collection[]{Collections.singleton(parent.toString())});
            } else if (parent instanceof Dumpable) {
                ContainerLifeCycle.dump((Appendable)out, (String)indent, (Collection[])new Collection[]{Collections.singleton(parent)});
            } else if (parent != null) {
                ContainerLifeCycle.dump((Appendable)out, (String)indent, (Collection[])new Collection[]{Collections.singleton(new ClassLoaderDump(parent))});
            }
        }
    }
}

