/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.auth;

import io.hops.hadoop.shaded.org.apache.commons.io.FileUtils;
import io.hops.hadoop.shaded.org.apache.commons.io.FilenameUtils;
import io.hops.hadoop.shaded.org.apache.zookeeper.CreateMode;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooDefs;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPeerTestBase;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.auth.KerberosSecurityTestcase;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.auth.KerberosTestUtils;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import java.io.File;
import java.util.HashMap;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.Test;

public class QuorumKerberosAuthTest
extends KerberosSecurityTestcase {
    private static File keytabFile;

    @Before
    public void setUp() throws Exception {
        keytabFile = new File(KerberosTestUtils.getKeytabFile());
        String learnerPrincipal = KerberosTestUtils.getLearnerPrincipal();
        String serverPrincipal = KerberosTestUtils.getServerPrincipal();
        learnerPrincipal = learnerPrincipal.substring(0, learnerPrincipal.lastIndexOf("@"));
        serverPrincipal = serverPrincipal.substring(0, serverPrincipal.lastIndexOf("@"));
        QuorumKerberosAuthTest.getKdc().createPrincipal(keytabFile, learnerPrincipal, serverPrincipal);
    }

    @After
    public void tearDown() throws Exception {
        for (QuorumPeerTestBase.MainThread mainThread : this.mt) {
            mainThread.shutdown();
            mainThread.deleteBaseDir();
        }
    }

    @AfterClass
    public static void cleanup() {
        if (keytabFile != null) {
            FileUtils.deleteQuietly((File)keytabFile);
        }
        QuorumKerberosAuthTest.cleanupJaasConfig();
    }

    @Test(timeout=120000L)
    public void testValidCredentials() throws Exception {
        String serverPrincipal = KerberosTestUtils.getServerPrincipal();
        serverPrincipal = serverPrincipal.substring(0, serverPrincipal.lastIndexOf("@"));
        HashMap<String, String> authConfigs = new HashMap<String, String>();
        authConfigs.put("quorum.auth.enableSasl", "true");
        authConfigs.put("quorum.auth.serverRequireSasl", "true");
        authConfigs.put("quorum.auth.learnerRequireSasl", "true");
        authConfigs.put("quorum.auth.kerberos.servicePrincipal", serverPrincipal);
        String connectStr = this.startQuorum(3, authConfigs, 3, true);
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        ZooKeeper zk = new ZooKeeper(connectStr, ClientBase.CONNECTION_TIMEOUT, watcher);
        watcher.waitForConnected(ClientBase.CONNECTION_TIMEOUT);
        for (int i = 0; i < 10; ++i) {
            zk.create("/" + i, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        zk.close();
    }

    static {
        String keytabFilePath = FilenameUtils.normalize((String)KerberosTestUtils.getKeytabFile(), (boolean)true);
        String jaasEntries = new String("QuorumServer {\n       com.sun.security.auth.module.Krb5LoginModule required\n       useKeyTab=true\n       keyTab=\"" + keytabFilePath + "\"\n       storeKey=true\n       useTicketCache=false\n       debug=true\n       doNotPrompt=true\n       refreshKrb5Config=true\n       principal=\"" + KerberosTestUtils.getServerPrincipal() + "\";\n};\nQuorumLearner {\n       com.sun.security.auth.module.Krb5LoginModule required\n       useKeyTab=true\n       keyTab=\"" + keytabFilePath + "\"\n       storeKey=true\n       useTicketCache=false\n       debug=true\n       doNotPrompt=true\n       refreshKrb5Config=true\n       isInitiator=true\n       principal=\"" + KerberosTestUtils.getLearnerPrincipal() + "\";\n};\n");
        QuorumKerberosAuthTest.setupJaasConfig(jaasEntries);
    }
}

