/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.test;

import io.hops.hadoop.shaded.org.apache.zookeeper.CreateMode;
import io.hops.hadoop.shaded.org.apache.zookeeper.WatchedEvent;
import io.hops.hadoop.shaded.org.apache.zookeeper.Watcher;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZKTestCase;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooDefs;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.QuorumBase;
import java.io.File;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class QuorumZxidSyncTest
extends ZKTestCase {
    QuorumBase qb = new QuorumBase();

    @Before
    public void setUp() throws Exception {
        this.qb.setUp();
    }

    @Test
    public void testBehindLeader() throws Exception {
        ClientBase.waitForServerUp(this.qb.hostPort, 10000L);
        ClientBase.waitForServerUp(this.qb.hostPort, 10000L);
        ZooKeeper zk = new ZooKeeper(this.qb.hostPort, 10000, new Watcher(){

            @Override
            public void process(WatchedEvent event) {
            }
        });
        zk.create("/0", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.close();
        this.qb.shutdownServers();
        this.qb.startServers();
        ClientBase.waitForServerUp(this.qb.hostPort, 10000L);
        this.qb.shutdownServers();
        this.qb.startServers();
        ClientBase.waitForServerUp(this.qb.hostPort, 10000L);
        zk = new ZooKeeper(this.qb.hostPort, 10000, new Watcher(){

            @Override
            public void process(WatchedEvent event) {
            }
        });
        zk.create("/1", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.close();
        this.qb.shutdownServers();
        this.qb.startServers();
        ClientBase.waitForServerUp(this.qb.hostPort, 10000L);
        this.qb.shutdownServers();
        this.qb.startServers();
        ClientBase.waitForServerUp(this.qb.hostPort, 10000L);
        zk = new ZooKeeper(this.qb.hostPort, 10000, new Watcher(){

            @Override
            public void process(WatchedEvent event) {
            }
        });
        zk.create("/2", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.close();
        this.qb.shutdownServers();
        this.deleteFiles(this.qb.s1dir);
        this.deleteFiles(this.qb.s2dir);
        this.deleteFiles(this.qb.s3dir);
        this.deleteFiles(this.qb.s4dir);
        this.qb.setupServers();
        this.qb.s1.start();
        this.qb.s2.start();
        this.qb.s3.start();
        this.qb.s4.start();
        Assert.assertTrue((String)"Servers didn't come up", (boolean)ClientBase.waitForServerUp(this.qb.hostPort, 10000L));
        this.qb.s5.start();
        String hostPort = "127.0.0.1:" + this.qb.s5.getClientPort();
        Assert.assertFalse((String)"Servers came up, but shouldn't have since it's ahead of leader", (boolean)ClientBase.waitForServerUp(hostPort, 10000L));
    }

    private void deleteFiles(File f) {
        File v = new File(f, "version-2");
        for (File c : v.listFiles()) {
            c.delete();
        }
    }

    @Test
    public void testLateLogs() throws Exception {
        ClientBase.waitForServerUp(this.qb.hostPort, 10000L);
        ClientBase.waitForServerUp(this.qb.hostPort, 10000L);
        ZooKeeper zk = new ZooKeeper(this.qb.hostPort, 10000, new Watcher(){

            @Override
            public void process(WatchedEvent event) {
            }
        });
        zk.create("/0", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.close();
        this.qb.shutdownServers();
        this.qb.startServers();
        ClientBase.waitForServerUp(this.qb.hostPort, 10000L);
        this.qb.shutdownServers();
        this.qb.startServers();
        ClientBase.waitForServerUp(this.qb.hostPort, 10000L);
        zk = new ZooKeeper(this.qb.hostPort, 10000, new Watcher(){

            @Override
            public void process(WatchedEvent event) {
            }
        });
        zk.create("/1", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.close();
        this.qb.shutdownServers();
        this.qb.startServers();
        ClientBase.waitForServerUp(this.qb.hostPort, 10000L);
        this.qb.shutdownServers();
        this.deleteLogs(this.qb.s1dir);
        this.deleteLogs(this.qb.s2dir);
        this.deleteLogs(this.qb.s3dir);
        this.deleteLogs(this.qb.s4dir);
        this.deleteLogs(this.qb.s5dir);
        this.qb.startServers();
        ClientBase.waitForServerUp(this.qb.hostPort, 10000L);
        zk = new ZooKeeper(this.qb.hostPort, 10000, new Watcher(){

            @Override
            public void process(WatchedEvent event) {
            }
        });
        zk.create("/2", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.close();
        this.qb.shutdownServers();
        this.qb.startServers();
        ClientBase.waitForServerUp(this.qb.hostPort, 10000L);
        zk = new ZooKeeper(this.qb.hostPort, 10000, new Watcher(){

            @Override
            public void process(WatchedEvent event) {
            }
        });
        boolean saw2 = false;
        for (String child : zk.getChildren("/", false)) {
            if (!child.equals("2")) continue;
            saw2 = true;
        }
        zk.close();
        Assert.assertTrue((String)"Didn't see /2 (went back in time)", (boolean)saw2);
    }

    private void deleteLogs(File f) {
        File v = new File(f, "version-2");
        for (File c : v.listFiles()) {
            if (!c.getName().startsWith("log")) continue;
            c.delete();
        }
    }

    @After
    public void tearDown() throws Exception {
        this.qb.tearDown();
    }
}

