/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.sun.xml.bind.marshaller;

import io.hops.hadoop.shaded.com.sun.istack.FinalArrayList;
import io.hops.hadoop.shaded.com.sun.xml.bind.marshaller.Messages;
import io.hops.hadoop.shaded.com.sun.xml.bind.util.Which;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class SAX2DOMEx
implements ContentHandler {
    private Node node = null;
    private boolean isConsolidate;
    protected final Stack<Node> nodeStack = new Stack();
    private final FinalArrayList<String> unprocessedNamespaces = new FinalArrayList();
    protected final Document document;

    public SAX2DOMEx(Node node) {
        this(node, false);
    }

    public SAX2DOMEx(Node node, boolean isConsolidate) {
        this.node = node;
        this.isConsolidate = isConsolidate;
        this.nodeStack.push(this.node);
        this.document = node instanceof Document ? (Document)node : node.getOwnerDocument();
    }

    public SAX2DOMEx() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        this.document = factory.newDocumentBuilder().newDocument();
        this.node = this.document;
        this.nodeStack.push(this.document);
    }

    public final Element getCurrentElement() {
        return (Element)this.nodeStack.peek();
    }

    public Node getDOM() {
        return this.node;
    }

    public void startDocument() {
    }

    public void endDocument() {
    }

    protected void namespace(Element element, String prefix, String uri) {
        String qname = "".equals(prefix) || prefix == null ? "xmlns" : "xmlns:" + prefix;
        if (element.hasAttributeNS("http://www.w3.org/2000/xmlns/", qname)) {
            element.removeAttributeNS("http://www.w3.org/2000/xmlns/", qname);
        }
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", qname, uri);
    }

    public void startElement(String namespace, String localName, String qName, Attributes attrs) {
        Node parent = this.nodeStack.peek();
        Element element = this.document.createElementNS(namespace, qName);
        if (element == null) {
            throw new AssertionError((Object)Messages.format("SAX2DOMEx.DomImplDoesntSupportCreateElementNs", this.document.getClass().getName(), Which.which(this.document.getClass())));
        }
        for (int i = 0; i < this.unprocessedNamespaces.size(); i += 2) {
            String prefix = (String)this.unprocessedNamespaces.get(i + 0);
            String uri = (String)this.unprocessedNamespaces.get(i + 1);
            this.namespace(element, prefix, uri);
        }
        this.unprocessedNamespaces.clear();
        if (attrs != null) {
            int length = attrs.getLength();
            for (int i = 0; i < length; ++i) {
                String namespaceuri = attrs.getURI(i);
                String value = attrs.getValue(i);
                String qname = attrs.getQName(i);
                element.setAttributeNS(namespaceuri, qname, value);
            }
        }
        parent.appendChild(element);
        this.nodeStack.push(element);
    }

    public void endElement(String namespace, String localName, String qName) {
        this.nodeStack.pop();
    }

    public void characters(char[] ch, int start, int length) {
        this.characters(new String(ch, start, length));
    }

    protected Text characters(String s) {
        Text text;
        Node parent = this.nodeStack.peek();
        Node lastChild = parent.getLastChild();
        if (this.isConsolidate && lastChild != null && lastChild.getNodeType() == 3) {
            text = (Text)lastChild;
            text.appendData(s);
        } else {
            text = this.document.createTextNode(s);
            parent.appendChild(text);
        }
        return text;
    }

    public void ignorableWhitespace(char[] ch, int start, int length) {
    }

    public void processingInstruction(String target, String data) throws SAXException {
        Node parent = this.nodeStack.peek();
        ProcessingInstruction n = this.document.createProcessingInstruction(target, data);
        parent.appendChild(n);
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String name) {
    }

    public void startPrefixMapping(String prefix, String uri) {
        this.unprocessedNamespaces.add(prefix);
        this.unprocessedNamespaces.add(uri);
    }

    public void endPrefixMapping(String prefix) {
    }
}

