/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"HBase", "HDFS", "Hive", "MapReduce", "Pig", "HOPS"})
@InterfaceStability.Unstable
public class MiniDFSNNTopology {
    private final List<NNConf> namenodes = Lists.newArrayList();

    public static MiniDFSNNTopology simpleSingleNN(int nameNodePort, int nameNodeHttpPort) {
        return new MiniDFSNNTopology().addNameNode(new NNConf(null).setHttpPort(nameNodeHttpPort).setIpcPort(nameNodePort));
    }

    public MiniDFSNNTopology addNameNode(NNConf namenode) {
        this.namenodes.add(namenode);
        return this;
    }

    public int countNameNodes() {
        return this.namenodes.size();
    }

    public NNConf getOnlyNameNode() {
        Preconditions.checkState((this.countNameNodes() == 1 ? 1 : 0) != 0, (Object)"must have exactly one NN!");
        return this.namenodes.get(0);
    }

    public boolean allHttpPortsSpecified() {
        for (NNConf nn : this.namenodes) {
            if (nn.getHttpPort() != 0) continue;
            return false;
        }
        return true;
    }

    public boolean allIpcPortsSpecified() {
        for (NNConf nn : this.namenodes) {
            if (nn.getIpcPort() != 0) continue;
            return false;
        }
        return true;
    }

    public List<NNConf> getNamenodes() {
        return this.namenodes;
    }

    public static MiniDFSNNTopology simpleHOPSTopology(int nnCount) {
        if (nnCount < 1) {
            return null;
        }
        MiniDFSNNTopology topology = new MiniDFSNNTopology();
        for (int i = 1; i <= nnCount; ++i) {
            topology.addNameNode(new NNConf("nn" + i));
        }
        return topology;
    }

    public static class NNConf {
        private String nnId;
        private int httpPort;
        private int ipcPort;
        private String clusterId;

        public NNConf(String nnId) {
            this.nnId = nnId;
        }

        String getNnId() {
            return this.nnId;
        }

        int getIpcPort() {
            return this.ipcPort;
        }

        int getHttpPort() {
            return this.httpPort;
        }

        String getClusterId() {
            return this.clusterId;
        }

        public NNConf setHttpPort(int httpPort) {
            this.httpPort = httpPort;
            return this;
        }

        public NNConf setIpcPort(int ipcPort) {
            this.ipcPort = ipcPort;
            return this;
        }

        public NNConf setClusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }
    }
}

