/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.entity.CachedBlock;
import io.hops.transaction.EntityManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;

@InterfaceAudience.LimitedPrivate(value={"HDFS"})
public final class CachedBlock {
    private final long blockId;
    private final long inodeId;
    private short replicationAndMark;
    Map<Type, Set<DatanodeDescriptor>> datanodesMap = new HashMap<Type, Set<DatanodeDescriptor>>();

    public CachedBlock(long blockId, long inodeId, short replication, boolean mark) {
        this.blockId = blockId;
        this.inodeId = inodeId;
        this.setReplicationAndMark(replication, mark);
    }

    public CachedBlock(long blockId, long inodeId, short replicationAndMark) throws TransactionContextException, StorageException {
        this.blockId = blockId;
        this.inodeId = inodeId;
        this.replicationAndMark = replicationAndMark;
    }

    public CachedBlock(long blockId, long inodeId, short replicationAndMark, Type type, DatanodeDescriptor datanode) throws TransactionContextException, StorageException {
        this.blockId = blockId;
        this.inodeId = inodeId;
        this.replicationAndMark = replicationAndMark;
        if (!type.equals((Object)Type.INIT)) {
            HashSet<DatanodeDescriptor> node = new HashSet<DatanodeDescriptor>();
            node.add(datanode);
            this.datanodesMap.put(type, node);
        }
    }

    public CachedBlock(long blockId, long inodeId, short replication, boolean mark, DatanodeDescriptor datanode, Type type) throws TransactionContextException, StorageException {
        this.blockId = blockId;
        this.inodeId = inodeId;
        this.setReplicationAndMark(replication, mark);
        HashSet<DatanodeDescriptor> node = new HashSet<DatanodeDescriptor>();
        node.add(datanode);
        this.datanodesMap.put(type, node);
    }

    public long getBlockId() {
        return this.blockId;
    }

    public long getInodeId() {
        return this.inodeId;
    }

    public int hashCode() {
        return (int)(this.blockId ^ this.blockId >>> 32);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        CachedBlock other = (CachedBlock)o;
        return other.blockId == this.blockId;
    }

    public void setReplicationAndMark(short replication, boolean mark) {
        assert (replication >= 0);
        this.replicationAndMark = (short)(replication << 1 | (mark ? 1 : 0));
    }

    public boolean getMark() {
        return (this.replicationAndMark & 1) != 0;
    }

    public short getReplication() {
        return (short)(this.replicationAndMark >>> 1);
    }

    public List<DatanodeDescriptor> getDatanodes(Type type) {
        Set<DatanodeDescriptor> nodes = this.datanodesMap.get((Object)type);
        if (nodes == null) {
            nodes = new HashSet<DatanodeDescriptor>();
        }
        return new ArrayList<DatanodeDescriptor>(nodes);
    }

    public void addDatanode(DatanodeDescriptor datanode, String type) {
        this.addDatanode(datanode, Type.valueOf(type));
    }

    public void addDatanode(DatanodeDescriptor datanode, Type type) {
        Set<DatanodeDescriptor> nodes = this.datanodesMap.get((Object)type);
        if (nodes == null) {
            nodes = new HashSet<DatanodeDescriptor>();
            this.datanodesMap.put(type, nodes);
        }
        nodes.add(datanode);
    }

    public String toString() {
        return "{" + "blockId=" + this.blockId + ", " + "replication=" + this.getReplication() + ", " + "mark=" + this.getMark() + "}";
    }

    public void switchPendingCachedToCached(DatanodeDescriptor datanode) throws TransactionContextException, StorageException {
        if (this.datanodesMap.get((Object)Type.PENDING_CACHED) != null && this.datanodesMap.get((Object)Type.PENDING_CACHED).remove((Object)datanode)) {
            this.addDatanode(datanode, Type.CACHED);
            EntityManager.update((Object)new io.hops.metadata.hdfs.entity.CachedBlock(this.blockId, this.inodeId, datanode.getDatanodeUuid(), Type.CACHED.name(), this.replicationAndMark));
        }
    }

    public void switchPendingUncachedToCached(DatanodeDescriptor datanode) throws TransactionContextException, StorageException {
        assert (this.datanodesMap.get((Object)Type.PENDING_UNCACHED).remove((Object)datanode));
        this.addDatanode(datanode, Type.CACHED);
        EntityManager.update((Object)new io.hops.metadata.hdfs.entity.CachedBlock(this.blockId, this.inodeId, datanode.getDatanodeUuid(), Type.CACHED.name(), this.replicationAndMark));
    }

    public boolean setPendingUncached(DatanodeDescriptor datanode) throws TransactionContextException, StorageException {
        Set<DatanodeDescriptor> nodes = this.datanodesMap.get((Object)Type.PENDING_UNCACHED);
        if (nodes == null) {
            nodes = new HashSet<DatanodeDescriptor>();
            this.datanodesMap.put(Type.PENDING_UNCACHED, nodes);
        }
        if (!nodes.add(datanode)) {
            return false;
        }
        EntityManager.update((Object)new io.hops.metadata.hdfs.entity.CachedBlock(this.blockId, this.inodeId, datanode.getDatanodeUuid(), Type.PENDING_UNCACHED.name(), this.replicationAndMark));
        return true;
    }

    public boolean addPendingCached(DatanodeDescriptor datanode) throws TransactionContextException, StorageException {
        Set<DatanodeDescriptor> nodes = this.datanodesMap.get((Object)Type.PENDING_CACHED);
        if (nodes == null) {
            nodes = new HashSet<DatanodeDescriptor>();
            this.datanodesMap.put(Type.PENDING_CACHED, nodes);
        }
        if (!nodes.add(datanode)) {
            return false;
        }
        EntityManager.update((Object)new io.hops.metadata.hdfs.entity.CachedBlock(this.blockId, this.inodeId, datanode.getDatanodeUuid(), Type.PENDING_CACHED.name(), this.replicationAndMark));
        return true;
    }

    public boolean isCached() {
        if (this.datanodesMap.get((Object)Type.CACHED) != null && !this.datanodesMap.get((Object)Type.CACHED).isEmpty()) {
            return true;
        }
        return this.datanodesMap.get((Object)Type.PENDING_UNCACHED) != null && !this.datanodesMap.get((Object)Type.PENDING_UNCACHED).isEmpty();
    }

    public void save() throws TransactionContextException, StorageException {
        EntityManager.update((Object)new io.hops.metadata.hdfs.entity.CachedBlock(this.blockId, this.inodeId, "", Type.INIT.name(), this.replicationAndMark));
        for (Type type : this.datanodesMap.keySet()) {
            for (DatanodeDescriptor datanode : this.datanodesMap.get((Object)type)) {
                EntityManager.update((Object)new io.hops.metadata.hdfs.entity.CachedBlock(this.blockId, this.inodeId, datanode.getDatanodeUuid(), type.name(), this.replicationAndMark));
            }
        }
    }

    public void remove() throws TransactionContextException, StorageException {
        for (Type type : this.datanodesMap.keySet()) {
            for (DatanodeDescriptor datanode : this.datanodesMap.get((Object)type)) {
                EntityManager.remove((Object)new io.hops.metadata.hdfs.entity.CachedBlock(this.blockId, this.inodeId, datanode.getDatanodeUuid(), type.name(), this.replicationAndMark));
            }
        }
        EntityManager.remove((Object)new io.hops.metadata.hdfs.entity.CachedBlock(this.blockId, this.inodeId, "", null, this.replicationAndMark));
    }

    public void remove(DatanodeDescriptor datanode) throws TransactionContextException, StorageException {
        EntityManager.remove((Object)new io.hops.metadata.hdfs.entity.CachedBlock(this.blockId, this.inodeId, datanode.getDatanodeUuid(), null, this.replicationAndMark));
    }

    public void removePending(DatanodeDescriptor datanode) throws TransactionContextException, StorageException {
        EntityManager.remove((Object)new io.hops.metadata.hdfs.entity.CachedBlock(this.blockId, this.inodeId, datanode.getDatanodeUuid(), Type.PENDING_CACHED.name(), this.replicationAndMark));
    }

    public static Collection<CachedBlock> getAll(DatanodeManager datanodeManager) throws TransactionContextException, StorageException {
        return CachedBlock.toHops(EntityManager.findList((FinderType)CachedBlock.Finder.All, null), datanodeManager);
    }

    public static Collection<CachedBlock> toHops(Collection<io.hops.metadata.hdfs.entity.CachedBlock> dbBlocks, DatanodeManager datanodeManager) throws TransactionContextException, StorageException {
        if (dbBlocks == null) {
            return new ArrayList<CachedBlock>();
        }
        HashMap<Long, CachedBlock> result = new HashMap<Long, CachedBlock>();
        for (io.hops.metadata.hdfs.entity.CachedBlock dalBlock : dbBlocks) {
            if (dalBlock.getStatus().equals("")) continue;
            CachedBlock block = (CachedBlock)result.get(dalBlock.getBlockId());
            if (block == null) {
                DatanodeDescriptor datanode = null;
                if (!Type.valueOf(dalBlock.getStatus()).equals((Object)Type.INIT)) {
                    datanode = datanodeManager.getDatanodeByUuid(dalBlock.getDatanodeId());
                }
                result.put(dalBlock.getBlockId(), new CachedBlock(dalBlock.getBlockId(), dalBlock.getInodeId(), dalBlock.getReplicationAndMark(), Type.valueOf(dalBlock.getStatus()), datanode));
                continue;
            }
            if (Type.valueOf(dalBlock.getStatus()).equals((Object)Type.INIT)) continue;
            block.addDatanode(datanodeManager.getDatanodeByUuid(dalBlock.getDatanodeId()), dalBlock.getStatus());
        }
        return result.values();
    }

    public static enum Type {
        INIT,
        PENDING_CACHED,
        CACHED,
        PENDING_UNCACHED;

    }
}

