/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.ehcache.impl.internal.store.offheap.portability;

import io.hops.hadoop.shaded.org.ehcache.impl.internal.store.BinaryValueHolder;
import io.hops.hadoop.shaded.org.ehcache.impl.internal.store.offheap.LazyOffHeapValueHolder;
import io.hops.hadoop.shaded.org.ehcache.impl.internal.store.offheap.OffHeapValueHolder;
import io.hops.hadoop.shaded.org.ehcache.spi.serialization.Serializer;
import io.hops.hadoop.shaded.org.terracotta.offheapstore.storage.portability.WriteBackPortability;
import io.hops.hadoop.shaded.org.terracotta.offheapstore.storage.portability.WriteContext;
import java.nio.ByteBuffer;

public class OffHeapValueHolderPortability<V>
implements WriteBackPortability<OffHeapValueHolder<V>> {
    public static final int ACCESS_TIME_OFFSET = 16;
    public static final int EXPIRE_TIME_OFFSET = 24;
    public static final int HITS_OFFSET = 32;
    private static final int FIELDS_OVERHEAD = 40;
    private final Serializer<V> serializer;

    public OffHeapValueHolderPortability(Serializer<V> serializer) {
        this.serializer = serializer;
    }

    @Override
    public ByteBuffer encode(OffHeapValueHolder<V> valueHolder) {
        ByteBuffer serialized = valueHolder instanceof BinaryValueHolder && ((BinaryValueHolder)((Object)valueHolder)).isBinaryValueAvailable() ? ((BinaryValueHolder)((Object)valueHolder)).getBinaryValue() : this.serializer.serialize(valueHolder.value());
        ByteBuffer byteBuffer = ByteBuffer.allocate(serialized.remaining() + 40);
        byteBuffer.putLong(valueHolder.getId());
        byteBuffer.putLong(valueHolder.creationTime(OffHeapValueHolder.TIME_UNIT));
        byteBuffer.putLong(valueHolder.lastAccessTime(OffHeapValueHolder.TIME_UNIT));
        byteBuffer.putLong(valueHolder.expirationTime(OffHeapValueHolder.TIME_UNIT));
        byteBuffer.putLong(valueHolder.hits());
        byteBuffer.put(serialized);
        byteBuffer.flip();
        return byteBuffer;
    }

    @Override
    public OffHeapValueHolder<V> decode(ByteBuffer byteBuffer) {
        return this.decode(byteBuffer, null);
    }

    @Override
    public boolean equals(Object o, ByteBuffer byteBuffer) {
        return o.equals(this.decode(byteBuffer));
    }

    @Override
    public OffHeapValueHolder<V> decode(ByteBuffer byteBuffer, WriteContext writeContext) {
        long id = byteBuffer.getLong();
        long creationTime = byteBuffer.getLong();
        long lastAccessTime = byteBuffer.getLong();
        long expireTime = byteBuffer.getLong();
        long hits = byteBuffer.getLong();
        return new LazyOffHeapValueHolder<V>(id, byteBuffer.slice(), this.serializer, creationTime, expireTime, lastAccessTime, hits, writeContext);
    }
}

