/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.nustaq.serialization.simpleapi;

import io.hops.hadoop.shaded.org.nustaq.offheap.bytez.malloc.MallocBytez;
import io.hops.hadoop.shaded.org.nustaq.serialization.FSTConfiguration;
import io.hops.hadoop.shaded.org.nustaq.serialization.FSTDecoder;
import io.hops.hadoop.shaded.org.nustaq.serialization.FSTEncoder;
import io.hops.hadoop.shaded.org.nustaq.serialization.FSTObjectInput;
import io.hops.hadoop.shaded.org.nustaq.serialization.FSTObjectInputNoShared;
import io.hops.hadoop.shaded.org.nustaq.serialization.FSTObjectOutput;
import io.hops.hadoop.shaded.org.nustaq.serialization.FSTObjectOutputNoShared;
import io.hops.hadoop.shaded.org.nustaq.serialization.coders.FSTBytezDecoder;
import io.hops.hadoop.shaded.org.nustaq.serialization.coders.FSTBytezEncoder;
import java.io.IOException;

public class OffHeapCoder {
    protected FSTConfiguration conf = FSTConfiguration.createUnsafeBinaryConfiguration();
    MallocBytez writeTarget;
    MallocBytez readTarget;
    FSTObjectOutput out;
    FSTObjectInput in;

    public OffHeapCoder() {
        this(true);
    }

    public OffHeapCoder(boolean sharedRefs) {
        this.conf.setShareReferences(sharedRefs);
        this.writeTarget = new MallocBytez(0L, 0L);
        this.readTarget = new MallocBytez(0L, 0L);
        this.conf.setStreamCoderFactory(new FSTConfiguration.StreamCoderFactory(){
            ThreadLocal input = new ThreadLocal();
            ThreadLocal output = new ThreadLocal();

            @Override
            public FSTEncoder createStreamEncoder() {
                FSTBytezEncoder fstBytezEncoder = new FSTBytezEncoder(OffHeapCoder.this.conf, OffHeapCoder.this.writeTarget);
                fstBytezEncoder.setAutoResize(false);
                return fstBytezEncoder;
            }

            @Override
            public FSTDecoder createStreamDecoder() {
                return new FSTBytezDecoder(OffHeapCoder.this.conf, OffHeapCoder.this.readTarget);
            }

            @Override
            public ThreadLocal getInput() {
                return this.input;
            }

            @Override
            public ThreadLocal getOutput() {
                return this.output;
            }
        });
        if (sharedRefs) {
            this.out = this.conf.getObjectOutput();
            this.in = this.conf.getObjectInput();
        } else {
            this.out = new FSTObjectOutputNoShared(this.conf);
            this.in = new FSTObjectInputNoShared(this.conf);
        }
    }

    public OffHeapCoder(boolean sharedRefs, Class ... preregister) {
        this(sharedRefs);
        this.conf.registerClass(preregister);
    }

    public OffHeapCoder(Class ... preregister) {
        this(true);
        this.conf.registerClass(preregister);
    }

    public int toMemory(Object o, long address, int availableSize) throws IOException {
        this.out.resetForReUse();
        this.writeTarget.setBase(address, availableSize);
        this.out.writeObject(o);
        int written = this.out.getWritten();
        return written;
    }

    public Object toObject(long address, int availableSize) throws IOException, ClassNotFoundException {
        this.in.resetForReuse(null);
        this.readTarget.setBase(address, availableSize);
        Object o = this.in.readObject();
        return o;
    }
}

